/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */

#ifndef HK_CHARACTER_RIGIDBODY_AND_COLLISION_ARTIFACTS_H
#define HK_CHARACTER_RIGIDBODY_AND_COLLISION_ARTIFACTS_H

#include <Demos/DemoCommon/DemoFramework/hkDefaultPhysics2012Demo.h>

#include <Common/Base/Algorithm/PseudoRandom/hkPseudoRandomGenerator.h>

class hkpRigidBody;
class hkpCharacterRigidBody;
class hkpCharacterContext;
class hkpSimpleShapePhantom;
class MyPhantomForCharacterRbListener;


class CharacterRbAndCollisionArtifactsDemo : public hkDefaultPhysics2012Demo
{
	public:

		HK_DECLARE_CLASS_ALLOCATOR(HK_MEMORY_CLASS_DEMO);

		CharacterRbAndCollisionArtifactsDemo(hkDemoEnvironment* env);
		
		~CharacterRbAndCollisionArtifactsDemo();

		// Collision Layers used in this demo.
		// By enabling and disabling collisions between these layers, we can tweak the behaviour of the demo
		enum
		{
			LAYER_GROUND = 1,
			LAYER_CHARACTER = 2,
			LAYER_PLANT = 3
		};

		hkDemo::Result stepDemo();

private:

		hkReal m_currentAngle;

		hkpShape* m_standShape;
		
		hkpCharacterRigidBody* m_characterRigidBody;

		hkpCharacterContext* m_characterContext;
};

#endif // HK_CHARACTER_RIGIDBODY_AND_COLLISION_ARTIFACTS_H

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
