/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */

#ifndef HK_BUMPS_DEMO_H
#define HK_BUMPS_DEMO_H

#include <Demos/DemoCommon/DemoFramework/hkDefaultPhysics2012Demo.h>

#include <Physics2012/Utilities/CharacterControl/hkpCharacterControl.h>

extern const class hkClass UnevenTerrainVsDemoOptionsClass;

class hkpCharacterRigidBody;
class hkpCharacterContext;

class hkpCharacterProxy;
class hkpShapePhantom;
struct hkpCharacterInput;


class UnevenTerrainVsDemo : public hkDefaultPhysics2012Demo
{
	public:

		HK_DECLARE_CLASS_ALLOCATOR(HK_MEMORY_CLASS_DEMO);

		UnevenTerrainVsDemo(hkDemoEnvironment* env);
		
		~UnevenTerrainVsDemo();

		Result stepDemo();

		// Collision Layers used in this demo.
		// By enabling and disabling collisions between these layers, we can tweak the behaviour of the demo
		// Disable collision between CHARACTER_PROXY and CHARACTER_RIGIDBODY
		enum
		{
			LAYER_LANDSCAPE = 1,
			LAYER_CHARACTER_PROXY = 2,
			LAYER_CHARACTER_RIGIDBODY = 3			
		};

	public:
		struct Options
		{
			HK_DECLARE_REFLECTION();

			Options()
			:	m_worldCollisionTolerance( 0.1f ),
				m_characterCylinderHeight( 0.8f	),
				m_characterRadius( 0.6f ),
				// Gravity as applied to characters is typically higher than world gravity.
				m_characterGravity( -16.0f ),
				m_characterWalkSpeed( 10.0f ),
				m_clientStateFiltering( 3 ),
				m_rbSupportDistance( 0.1f ),
				m_rbHardSupportDistance( 0.0f ),
				m_rbAllowedPenetrationDepth( -0.1f )
			{
			}

			hkReal m_worldCollisionTolerance; //+default(0.1) +absmin(0.0) +absmax(1.0)
			hkReal m_characterCylinderHeight; //+default(0.8) +absmin(0.1) +absmax(20.0)
			hkReal m_characterRadius; //+default(0.6) +absmin(0.1) +absmax(20.0)
			hkReal m_characterGravity; //+default(-16.0) +absmin(-100.0) +absmax(100.0)
			hkReal m_characterWalkSpeed; //+default(10.0) +absmin(1.0) +absmax(100.0)
			int m_clientStateFiltering; //+default(3) +absmin(0) +absmax(100)
			// For the character rigid body only
			hkReal m_rbSupportDistance; //+default(0.1) +absmin(0.0) +absmax(1.0)
			hkReal m_rbHardSupportDistance; //+default(0.0) +absmin(-0.1) +absmax(1.0)
			hkReal m_rbAllowedPenetrationDepth; //+default(-0.1) +absmin(-5.0) +absmax(5.0)
		};

		DEMO_OPTIONS_DECLARE(Options);

	protected:
		
		
		hkInt32 m_supportHistoryRb;
		hkInt32 m_supportHistoryProxy;

		hkInt32 m_unsupportedFramesCountRb;
		hkInt32 m_unsupportedFramesCountProxy;

		hkpCharacterRigidBody* m_characterRigidBody;
		hkpCharacterContext* m_characterContext;

		// Character proxy
		hkpShapePhantom* m_phantom;
		hkpCharacterProxy* m_characterProxy;

		hkpCharacterContext* m_characterProxyContext;

		int m_tick;

		class LandscapeContainer* m_landscapeContainer;

	public:

		struct FilterInfo
		{
			hkpSurfaceInfo m_previousGround;
			int m_framesInAir;
		};

			/// Ignore changes in support unless they last for more than a few frames.	
		void filterStates( FilterInfo& filter, hkpSurfaceInfo& input );

		FilterInfo m_filterRigidBody;
		FilterInfo m_filterProxy;
};

#endif // HK_BUMPS_DEMO_H

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
