/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */

#ifndef HK_MULTITHREADED_CHARACTER_DEMO_H
#define HK_MULTITHREADED_CHARACTER_DEMO_H

#include <Demos/DemoCommon/DemoFramework/hkDefaultPhysics2012Demo.h>
#include <Physics2012/Utilities/CharacterControl/CharacterProxy/Multithreaded/Util/hkpCharacterProxyJobUtil.h>
#include <Physics2012/Utilities/CharacterControl/CharacterProxy/Multithreaded/Cpu/hkpCpuCharacterProxyUtil.h>
#include <Physics2012/Collide/Agent/Collidable/hkpCdPoint.h>

class hkpCharacterProxy;
class hkpCharacterRigidBody;
class hkpCharacterContext;
class FlatLand;
class hkpCharacterProxyJobUtil;
class hkpTriggerVolume;

class MultithreadedCharactersDemo : public hkDefaultPhysics2012Demo
{
public:

	HK_DECLARE_CLASS_ALLOCATOR(HK_MEMORY_CLASS_DEMO);

	MultithreadedCharactersDemo(hkDemoEnvironment* env);

	~MultithreadedCharactersDemo();

	Result stepDemo();

protected:

	hkArray<hkpCharacterProxy*>		m_characterProxies;
	hkArray<hkpCharacterRigidBody*> m_characterRigidBodies;
	hkArray<hkpCharacterContext*>	m_characterContexts;

	hkpCharacterProxyJobUtil::JobData* m_characterProxyJobData;

	int m_tick;

	hkStepInfo m_stepInfo;
	FlatLand* m_flatLand;

	hkArray<hkUchar> m_treeManagerData;
	hkArray<const class hkpCollidable*> m_collidables;

	hkpGroupFilter* m_groupFilter;
};

#endif // HK_MULTITHREADED_CHARACTER_DEMO_H

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
