/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */

#ifndef HK_CHARACTER_AND_TRIGGERS_VOLUME_H
#define HK_CHARACTER_AND_TRIGGERS_VOLUME_H

#include <Demos/DemoCommon/DemoFramework/hkDefaultPhysics2012Demo.h>

#include <Common/Base/Algorithm/PseudoRandom/hkPseudoRandomGenerator.h>

class hkpShapePhantom;
class hkpCharacterProxy;
class hkpCharacterContext;
class hkColor;

class hkpMoppBvTreeShape;
class MyAllCdPointCollector;

/// This is a version of the CharacterAndTriggers demo which shows how to make the
/// hkpCharacterProxy interact usefully with the hkpTriggerVolume.
class CharacterAndTriggerVolumesDemo : public hkDefaultPhysics2012Demo
{
	public:

		HK_DECLARE_CLASS_ALLOCATOR(HK_MEMORY_CLASS_DEMO);

		CharacterAndTriggerVolumesDemo(hkDemoEnvironment* env);
		
		~CharacterAndTriggerVolumesDemo();

		hkDemo::Result stepDemo();

		virtual void setupContexts(hkArray<hkProcessContext*>& contexts);

	protected:

		void addViewer(const char* name, int& tag);
		void removeViewer(int& tag);


		void swapPhantomShape(hkpShape* newShape);

			// Helper class to get a flat mesh shape
		hkpMoppBvTreeShape* getTiledPlanarMoppBvTreeShape(int sideDivisions, hkReal sideLength, hkReal radius = 0.05f);

			// Helper method to generate a 'random' shape (type)
		hkpShape* getRandomShape();

			// Helper method to find a position far enough away from the current character position that it's
			// safe to add in a new hkRigidBopdy or Phantom at this spot.
		hkVector4 getRandomPositionAwayFromCharacter(hkReal planerange, hkReal heightrange, hkReal mindist);


		class TriggerVolumeAwareCharacterProxy* m_characterProxy;
		hkpCharacterContext* m_characterContext;
		hkReal m_currentAngle;

		hkpShapePhantom* m_phantom;

		hkpShape* m_standShape;
		hkpShape* m_crouchShape;

		hkReal m_characterVelocity;

		hkReal m_wallDistance;

		hkPseudoRandomGenerator m_generator;

		class hkLoader* m_loader;

		enum ShapeViewerMode
		{
			VIEWER_OFF = 0, 
			VIEWER_ON_WITH_DISPLAY_OBJECT, 
			VIEWER_ON_WITH_NO_DISPLAY_OBJECTS, 
			NUM_SHAPE_VIEWER_MODES, 

		};
		int m_shapeViewerState;
		
		int m_shapeDisplayViewerTag;

		hkPointerMap<hkpRigidBody*, hkgDisplayObject*> m_rigidBodyDisplayObjects;

};

#endif // HK_PHANTOM_AND_TRIGGERS_VOLUME_H

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
