/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */

#ifndef HK_VEHICLE_STYLES_DEMO_BASE_H
#define HK_VEHICLE_STYLES_DEMO_BASE_H

#include <Demos/DemoCommon/DemoFramework/hkDefaultPhysics2012Demo.h>
#include <Physics2012/Vehicle/Camera/hkp1dAngularFollowCam.h>

class hkpVehicleInstance;
class hkpReorientAction;
class hkRagdoll;

#include <Demos/DemoCommon/Utilities/VehicleApi/VehicleSetup.h>

extern const class hkClass VehicleSettingsClass;

struct VehicleSettings
{
	//+hk.ReflectedFile("VehicleStyles")
	HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR( HK_MEMORY_CLASS_DEMO, VehicleSettings );
	HK_DECLARE_REFLECTION();
	VehicleSettings(): m_suspensionStrength ( 50.f ),m_suspensionHardPoint ( 0.1f ){}
	hkReal m_suspensionStrength;
	hkReal m_suspensionHardPoint;
};

struct VehicleStylesBaseOptions
{
	HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR(HK_MEMORY_CLASS_BASE,VehicleStylesBaseOptions);

	enum VehicleType
	{
		CRUISER = 0,
		SPORTS_CAR,
		GOKART,
		BIG_RIG, 
		BIG_RIG_TRAILER, 
		NUM_VEHICLE_TYPES,
		MOTORBIKE, //Moved it here as it's not supported for the moment
	};

	enum VehicleManagerType
	{
		NO_VEHICLE_MANAGER, 
		SINGLETHREADED_RAY_CAST,
		MULTITHREADED_RAY_CAST, // Full vehicle job is multithreaded
		WHEEL_BATCHED_RAY_CAST, // Wheel cast job only is multithreaded
	};

	enum LandscapeType
	{
		PLANE_LANDSCAPE,
	};

	VehicleType m_vehicleType;
	VehicleManagerType m_vehicleManagerType;
	int m_numVehiclesPerType;
	bool m_switchControlledVehicle;
	int m_landscapeType;
	int m_numCameras;

	hkBool m_enableVehicleShadows;
	hkBool m_enablePropShadows;
	hkBool m_enableReflection;
};

class VehicleStylesDemoBase : public hkDefaultPhysics2012Demo
{
public:
	enum 
	{
		GROUND_LAYER = 1,
		CHASSIS_LAYER,
		WHEEL_LAYER,
		PROP_LAYER,
		RAGDOLL_LAYER,
		TRAILER_LAYER,
		TRUCK_LAYER,
		PHANTOM_LAYER,
	};

public:
	HK_DECLARE_CLASS_ALLOCATOR(HK_MEMORY_CLASS_DEMO);

	VehicleStylesDemoBase( hkDemoEnvironment* env, VehicleStylesBaseOptions options, hkBool fireCollisionCallbacks = false, hkBool createWorld = true );

	virtual ~VehicleStylesDemoBase();

	virtual Result stepDemo(); 

	virtual void setupContexts(hkArray<hkProcessContext*>& contexts);

	virtual void updateTyremarks( hkReal timestep, hkpVehicleInstance* vehicle );

protected:
	struct InstancedDisplayData
	{
		HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR(HK_MEMORY_CLASS_DEMO, InstancedDisplayData);
		hkArray<class hkgInstancedDisplayObject* > m_bodyDisplayObjects;
		hkArray<class hkgInstancedDisplayObject* > m_wheelDisplayObjects;
		int m_numObjects;
	};
	InstancedDisplayData* _setupInstancedGeometry(hkxScene* scene, hkArray<hkStringBuf* >& meshNames, int numObjects, hkBool enableShadows = true);
	void _loadLandscape();
	//void _loadVehicle(int variantID, int numVehicles);
	void _loadVehicle(const char* vehicleModelName, const char* assetFileName, int vehicleType, int numVehicles);
	void _attachTrailers(bool isMultiVehicleDemo);
	void _handleBaseKeyPresses();
	void _setupCamera(int cameraType);
	void _setupBigRigCamera();
	void _setupCruiserCamera();
	void _setupSportsCarCamera();
	void _setupGoKartCamera();

	virtual void _panCamera();

private:
	int _dummyCallback();

public:
	enum CameraMode
	{
		PAN_CAMERA = 0, // Pans around the vehicle
		THIRD_PERSON_BEHIND, // 3rd person behind the car
		THIRD_PERSON_FRONT, // 3rd person looking back at the car
		THIRD_PERSON_SIDE, // 3rd person to the side looking at the car
		TOP_DOWN, // Top down View
		NUM_CAMERA_MODES,
		NAVIGATE_CAMERA, // Display the whole scene
	};

	int m_cameraMode;
	hkp1dAngularFollowCam m_camera;

	hkReal m_inputXPosition;
	hkReal m_inputYPosition;

	// For use with calls to the displayHandler.
	int m_tag;

	hkArray<int> m_displayWheelId;

	// This action uprights the vehicle when it turns over. 	 
	hkArray<hkpReorientAction* > m_reorientActions;

	hkArray<hkRagdoll*>	m_ragdolls;

	int m_numVehiclesPerType;

	hkBool m_tweaking;
	hkStringPtr m_tweakName;
	VehicleSettings m_settings;

protected:
	hkLoader* m_loader;

	hkArray<InstancedDisplayData* > m_vehicleTypeDisplayData;

	
	// Depending on the variant, this will either be rayCastBatchingManager or a linearCastBatchingManager.
	class hkpVehicleManager* m_vehicleManager;
	// The multithreaded vehicle manager is currently not run on SPU, thus number of CPUs is used
	int m_numJobs;

	struct VehicleInstanceData
	{
		HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR(HK_MEMORY_CLASS_DEMO, VehicleInstanceData);
		hkpVehicleInstance* m_vehicleInstance;
		hkUint32 m_instancedDisplayID;
		int m_vehicleType;
		hkBool m_simulated;
	};
	hkArray<VehicleInstanceData* > m_vehiclesData;
	
	// Methods for dynamically adding/removing vehicles to the world
	void _addVehicle(VehicleInstanceData* vehicleInstanceData, const hkTransform& initialTransform);
	void _removeVehicle(VehicleInstanceData* vehicleInstanceData);
	
	int m_controlledVehicleID;

	VehicleStylesBaseOptions m_demoOptions;

	static const float GROUND_SIZE;
	static const float WORLD_SIZE;

};

#endif // HK_VEHICLE_STYLES_DEMO_BASE_H

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
