/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */

#ifndef HK_VEHICLE_STYLES_DEMO_H
#define HK_VEHICLE_STYLES_DEMO_H

#include<Demos/Physics2012/ShowCase/VehicleStyles/VehicleStylesBase.h>
#include <Demos/DemoCommon/Utilities/VehicleDisplay/VehicleDisplayUtils.h>

struct VehicleStylesDemoVariant
{
	HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR(HK_MEMORY_CLASS_BASE,VehicleStylesDemoVariant);
	const char*	 m_name;
	VehicleStylesBaseOptions m_options;
	const char*  m_details;
};

class VehicleStylesDemo : public VehicleStylesDemoBase
{
public:
	HK_DECLARE_CLASS_ALLOCATOR(HK_MEMORY_CLASS_DEMO);

	static const VehicleStylesDemoVariant g_variants[];

	VehicleStylesDemo( hkDemoEnvironment* env, hkBool createWorld = true );

	virtual ~VehicleStylesDemo();

	void _loadProps(const char* asset, const char* meshName, int propType);

	virtual Result stepDemo(); 

	void _handleKeyPresses();

private:
	int _dummyCallback() { return 0; }

public:
	enum PropTypes
	{
		PROP_BARREL = 0,//Need to be loaded in this order
		PROP_CONE, 
		PROP_CRATE, 
		PROP_WHITETYRE, 
		PROP_REDTYRE,
		NUM_PROPS,
	};
	struct PropInstanceData
	{
		HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR(HK_MEMORY_CLASS_DEMO, PropInstanceData);
		hkpRigidBody* m_propRigidBody;
		hkUint32 m_instancedDisplayID;
		int m_propType;
	};
	hkArray<PropInstanceData* > m_propRBData;
	hkArray<InstancedDisplayData* > m_propTypeDisplayData;

	hkBool m_displayVehicleData;
	hkArray<class hkpRigidBodyResetUtil* > m_resetableRigidBodies;
	hkArray< VehicleDisplayUtils::VehicleDataAndDisplayInfo > m_vehiclesDisplayInfo;

};

#endif // HK_VEHICLE_STYLES_DEMO_H

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
