/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */

#include <Demos/demos.h>

#include <Demos/Physics2012/ShowCase/VehicleStyles/VehicleStyles.h>
#include <Demos/Physics2012/ShowCase/VehicleStyles/CruiserSetup.h>
#include <Demos/Physics2012/ShowCase/VehicleStyles/SportsCarSetup.h>
#include <Demos/Physics2012/ShowCase/VehicleStyles/BigRigSetup.h>
#include <Demos/Physics2012/ShowCase/VehicleStyles/BigRigTrailerSetup.h>
#include <Demos/Physics2012/ShowCase/VehicleStyles/BikeSetup.h>
#include <Demos/Physics2012/ShowCase/VehicleStyles/GoKartSetup.h>

#include <Demos/DemoCommon/Utilities/Asset/hkAssetManagementUtil.h>
#include <Demos/DemoCommon/Utilities/GameUtils/GameUtils.h>
#include <Demos/DemoCommon/Utilities/GameUtils/Landscape/FlatLand.h>
#include <Demos/DemoCommon/Utilities/GameUtils/TweakerUtils.h>
#include <Demos/DemoCommon/Utilities/VehicleApi/VehicleApiUtils.h>
#include <Demos/DemoCommon/Utilities/VehicleDisplay/VehicleDisplayUtils.h>

#include <Common/Base/Container/LocalArray/hkLocalArray.h>
#include <Common/Base/Thread/Pool/hkCpuThreadPool.h>
#include <Common/SceneData/Scene/hkxScene.h>
#include <Common/Serialize/Util/hkLoader.h>
#include <Common/Serialize/Util/hkRootLevelContainer.h>
#include <Common/Visualize/hkDebugDisplay.h>

#include <Graphics/Bridge/DisplayHandler/hkgDisplayHandler.h>
#include <Graphics/Bridge/SceneData/hkgSceneDataConverter.h>
#include <Graphics/Common/DisplayObject/hkgDisplayObject.h>
#include <Graphics/Common/DisplayObject/hkgInstancedDisplayObject.h>
#include <Graphics/Common/DisplayWorld/hkgDisplayWorld.h>
#include <Graphics/Common/Light/hkgLightManager.h>
#include <Graphics/Common/Material/hkgMaterial.h>

#include <Physics2012/Collide/Agent/hkpProcessCollisionInput.h>
#include <Physics2012/Collide/Query/CastUtil/hkpWorldRayCastInput.h>
#include <Physics2012/Collide/Query/CastUtil/hkpWorldRayCastOutput.h>
#include <Physics2012/Collide/Shape/HeightField/Plane/hkpPlaneShape.h>
#include <Physics2012/Collide/Query/Collector/PointCollector/hkpFixedBufferCdPointCollector.h>
#include <Physics2012/Collide/Query/Multithreaded/CollisionQuery/hkpCollisionQueryJobQueueUtils.h>
#include <Physics/Constraint/Data/Ragdoll/hkpRagdollConstraintData.h>
#include <Physics2012/Dynamics/Phantom/hkpAabbPhantom.h>
#include <Physics2012/Dynamics/World/hkpPhysicsSystem.h>
#include <Physics2012/Utilities/Actions/Reorient/hkpReorientAction.h>
#include <Physics2012/Utilities/Serialize/hkpPhysicsData.h>
#include <Physics2012/Utilities/VisualDebugger/hkpPhysicsContext.h>
#include <Physics2012/Utilities/VisualDebugger/Viewer/Dynamics/hkpPhantomDisplayViewer.h>
#include <Physics2012/Vehicle/hkpVehicleInstance.h>
#include <Physics2012/Vehicle/Manager/RayCastBatchingManager/hkpVehicleRayCastBatchingManager.h>
#include <Physics2012/Vehicle/Manager/MultithreadedVehicle/hkpMultithreadedVehicleManager.h>
#include <Physics2012/Vehicle/Manager/MultithreadedVehicle/hkpVehicleJobQueueUtils.h>
#include <Physics2012/Utilities/Dynamics/RigidBodyReset/hkpRigidBodyResetUtil.h>

#define PLANE_LANDSCAPE_ASSET "Resources/Physics2012/Showcase/VehicleStyles/Vehicle/PlaneLandscape.hkt"
#define BARREL_ASSET "Resources/Physics2012/Showcase/VehicleStyles/Vehicle/Props/Barrel/barrel.hkt"
#define CRATE_ASSET "Resources/Physics2012/Showcase/VehicleStyles/Vehicle/Props/Crate/crate.hkt"
#define WHITE_TYRE_ASSET "Resources/Physics2012/Showcase/VehicleStyles/Vehicle/Props/Tyre/WhiteTyres.hkt"
#define RED_TYRE_ASSET "Resources/Physics2012/Showcase/VehicleStyles/Vehicle/Props/Tyre/RedTyres.hkt"

static const char variantHelpString[] = "Press F1 for help";

const VehicleStylesDemoVariant VehicleStylesDemo::g_variants[] =
{
	//Note: The first variants are ordered based on the vehicle type so that we can use these variants when loading the multiple vehicle variant
	{ "Cruiser",
	{ VehicleStylesBaseOptions::CRUISER, VehicleStylesBaseOptions:: NO_VEHICLE_MANAGER, 1, false, VehicleStylesBaseOptions::PLANE_LANDSCAPE, VehicleStylesDemoBase::NUM_CAMERA_MODES,
		true, false, true
	},
	variantHelpString
	},

	{ "Sports Car",
		{ VehicleStylesBaseOptions::SPORTS_CAR, VehicleStylesBaseOptions:: NO_VEHICLE_MANAGER, 1, false, VehicleStylesBaseOptions::PLANE_LANDSCAPE, VehicleStylesDemoBase::NUM_CAMERA_MODES,
		true, false, true
	},
	variantHelpString
	},

	{ "Go-Kart",
		{ VehicleStylesBaseOptions::GOKART, VehicleStylesBaseOptions:: NO_VEHICLE_MANAGER, 1, false, VehicleStylesBaseOptions::PLANE_LANDSCAPE, VehicleStylesDemoBase::NUM_CAMERA_MODES,
		true, false, true
	},
	variantHelpString
	},

	/*{ "Motor Bike", 1, VehicleStylesBaseOptions::MOTORBIKE, variantHelpString, PLANE_LANDSCAPE_ASSET,VehicleStylesBaseOptions:: NO_VEHICLE_MANAGER},*/
	{ "Big Rig",
		{ VehicleStylesBaseOptions::BIG_RIG, VehicleStylesBaseOptions::NO_VEHICLE_MANAGER, 1, false, VehicleStylesBaseOptions::PLANE_LANDSCAPE, VehicleStylesDemoBase::NUM_CAMERA_MODES,
		true, false, true
	},
	variantHelpString
	},


	// No shadows in this demo variant as it's too slow
	{ "Vehicle Physics Comparison",
		{ VehicleStylesBaseOptions::NUM_VEHICLE_TYPES, VehicleStylesBaseOptions::NO_VEHICLE_MANAGER, 1, true, VehicleStylesBaseOptions::PLANE_LANDSCAPE, VehicleStylesDemoBase::NUM_CAMERA_MODES,
		true, false, true
	},
	variantHelpString
	},

	{ "Multiple Vehicles",
		{ VehicleStylesBaseOptions::NUM_VEHICLE_TYPES, VehicleStylesBaseOptions::NO_VEHICLE_MANAGER, 10, false, VehicleStylesBaseOptions::PLANE_LANDSCAPE, VehicleStylesDemoBase::NUM_CAMERA_MODES,
		true, false, true},
	variantHelpString
	},


	/*{ "Multiple Vehicles (Single-Threaded Raycast Vehicle Manager)",
		{ VehicleStylesBaseOptions::NUM_VEHICLE_TYPES, VehicleStylesBaseOptions::SINGLETHREADED_RAY_CAST, 10, false, VehicleStylesBaseOptions::PLANE_LANDSCAPE, VehicleStylesDemoBase::NUM_CAMERA_MODES, false, false, true},
		variantHelpString
	},
	{ "Multiple Vehicles (Multi-Threaded Raycast Vehicle Manager)",
		{ VehicleStylesBaseOptions::NUM_VEHICLE_TYPES, VehicleStylesBaseOptions::MULTITHREADED_RAY_CAST, 10, false, VehicleStylesBaseOptions::PLANE_LANDSCAPE, VehicleStylesDemoBase::NUM_CAMERA_MODES, false, false, true},
		variantHelpString
	},
	{ "Multiple Vehicles (Wheel Batched Raycast Vehicle Manager)",
		{ VehicleStylesBaseOptions::NUM_VEHICLE_TYPES, VehicleStylesBaseOptions::WHEEL_BATCHED_RAY_CAST, 10, false, VehicleStylesBaseOptions::PLANE_LANDSCAPE, VehicleStylesDemoBase::NUM_CAMERA_MODES, false, false, true},
		variantHelpString
	}*/
};

VehicleStylesDemo::VehicleStylesDemo( hkDemoEnvironment* env, hkBool createWorld )
:	VehicleStylesDemoBase(env, g_variants[env->m_variantId].m_options, createWorld)
{

	m_displayVehicleData = false;
#if defined(HK_DEBUG)
	m_displayVehicleData = true;
#endif

	if(m_displayVehicleData)
	{
		for(int v=0; v<m_vehiclesData.getSize(); v++)
		{
			m_vehiclesDisplayInfo.expandOne();
			//VehicleDisplayUtils::VehicleDataAndDisplayInfo info;
			//info.m_vehicle = m_vehiclesData[v]->m_vehicleInstance;

			m_vehiclesDisplayInfo[v].m_vehicle = m_vehiclesData[v]->m_vehicleInstance;
			m_vehiclesDisplayInfo[v].m_lastRPM = 0;
		}
	}

	m_world->lock();

	// Setup props and their display objects
	{
		m_propTypeDisplayData.setSize(VehicleStylesDemo::NUM_PROPS, HK_NULL);
		_loadProps(BARREL_ASSET, "Barrel001", VehicleStylesDemo::PROP_BARREL);
		_loadProps(CRATE_ASSET, "Crate001", VehicleStylesDemo::PROP_CRATE);
		_loadProps(WHITE_TYRE_ASSET, "WhiteTyre01", VehicleStylesDemo::PROP_WHITETYRE);
		_loadProps(RED_TYRE_ASSET, "RedTyre01", VehicleStylesDemo::PROP_REDTYRE);

	}

	bindKeyPressed('V' /*HKG_PAD_BUTTON_3*/, "Reset props", KeyPressCallback::Method(&VehicleStylesDemo::_dummyCallback, this));

	// Disable rendering of non-controlled vehicles in switching variant as it causes a slow-down
	if(g_variants[m_variantId].m_options.m_switchControlledVehicle)
	{
		for(int v = 0; v < m_vehiclesData.getSize(); v++)
		{
			if(v != m_controlledVehicleID)
			{
				_removeVehicle(m_vehiclesData[v]);
			}
		}
	}
	m_world->unlock();

	for(int step=0; step< 60; step++)
	{
		m_world->stepDeltaTime(1.0f / 240.f);
	}
}

void VehicleStylesDemo::_loadProps(const char* assetName, const char* meshName, int propType)
{
	// Add asset texture search paths
	{
		m_env->m_sceneConverter->clearTextureSearchOrder();
		m_env->m_sceneConverter->addTextureSearchOrder("dds");

		m_env->m_sceneConverter->clearTextureSearchPaths();
		switch (propType)
		{
		case VehicleStylesDemo::PROP_BARREL:
			m_env->m_sceneConverter->addTextureSearchPath("Resources/Physics2012/Showcase/VehicleStyles/Vehicle/Props/Barrel");
			break;
		case VehicleStylesDemo::PROP_CRATE:
			m_env->m_sceneConverter->addTextureSearchPath("Resources/Physics2012/Showcase/VehicleStyles/Vehicle/Props/Crate");
			break;
		case VehicleStylesDemo::PROP_CONE:
			m_env->m_sceneConverter->addTextureSearchPath("Resources/Physics2012/Showcase/VehicleStyles/Vehicle/Props/TrafficCone");
			break;
		case VehicleStylesDemo::PROP_WHITETYRE:
		case VehicleStylesDemo::PROP_REDTYRE:
			m_env->m_sceneConverter->addTextureSearchPath("Resources/Physics2012/Showcase/VehicleStyles/Vehicle/Props/Tyre");
			break;
		}
	}

	hkStringBuf fileName(HK_GET_DEMOS_ASSET_FILENAME(assetName));hkAssetManagementUtil::getFilePath(fileName);
	hkRootLevelContainer* container = m_loader->load( fileName.cString() );
	HK_ASSERT2(0x0, container != HK_NULL, "Could not load root level object" );

	// Get the physics data for the landscape
	{
		hkpPhysicsData* physicsData = static_cast<hkpPhysicsData*>( container->findObjectByType( hkpPhysicsDataClass.getName() ) );
		HK_ASSERT2(0x0, physicsData != HK_NULL, "Could not find physics data in root level object" );
		HK_ASSERT2(0x0, physicsData->getWorldCinfo() != HK_NULL, "No physics cinfo in loaded file - cannot create a hkpWorld" );

		int originalSizeOfProps = m_propRBData.getSize();
		for ( int i = 0; i < physicsData->getPhysicsSystems().getSize(); ++i )
		{
			hkpPhysicsSystem* pSystem = physicsData->getPhysicsSystems()[i];

			hkPseudoRandomGenerator rand(1234);
			for (int j=0; j < 40; j++)
			{
				hkpPhysicsSystem* physicsSystem = pSystem->clone();
				hkVector4 offset; rand.getRandomVector11( offset );
				offset(1) = 0.0f; offset.mul4( 100.0f );

				const hkArray<hkpRigidBody *>& bodies = physicsSystem->getRigidBodies();

				for (int propIdx = 0; propIdx<bodies.getSize(); propIdx++)
				{
					hkpRigidBody* rigidBody = bodies[propIdx];
					hkVector4 newPos;
					newPos.setAdd4( rigidBody->getPosition(), offset );
					rigidBody->setPosition( newPos );

					rigidBody->setCollisionFilterInfo( hkpGroupFilter::calcFilterInfo( PROP_LAYER ) );
					m_world->addEntity(rigidBody);

					PropInstanceData* propData = new PropInstanceData();
					m_resetableRigidBodies.pushBack(new hkpRigidBodyResetUtil(rigidBody));
					propData->m_propRigidBody = rigidBody;
					propData->m_instancedDisplayID = propIdx;
					propData->m_propType = propType;
					m_propRBData.pushBack(propData);
				}
				physicsSystem->removeReference();

			}
		}

		hkxScene* scene = HK_NULL;

		// Setup the instanced geometry
		{
			int numPropsAdded = m_propRBData.getSize() - originalSizeOfProps;

			scene = reinterpret_cast<hkxScene*>( container->findObjectByType( hkxSceneClass.getName() ));
			HK_ASSERT2(0x0, scene, "No Scene Data found");

			hkArray<hkStringBuf* > meshNames;
			meshNames.pushBack(new hkStringBuf(meshName));
			m_propTypeDisplayData[propType] = _setupInstancedGeometry(scene, meshNames, numPropsAdded, m_demoOptions.m_enablePropShadows);
			m_propTypeDisplayData[propType]->m_numObjects = numPropsAdded;

			delete meshNames[0];
		}
	}
}

void VehicleStylesDemo::_handleKeyPresses()
{
	// Reset all the props, vehicle code commented out
	if ( m_env->m_gamePad->wasButtonPressed( HKG_PAD_BUTTON_3 ) || m_env->m_window->getKeyboard().wasKeyPressed( 'V' ))
	{
		m_world->lock();

		//_loadProps(BARREL_ASSET, "Barrel001", VehicleStylesDemo::PROP_BARREL, true);
		////_loadProps(CONE_ASSET, "TrafficCone001", VehicleStylesDemo::PROP_CONE, true);
		//_loadProps(WHITE_TYRE_ASSET, "tyre009", VehicleStylesDemo::PROP_WHITETYRE, true);
		//_loadProps(RED_TYRE_ASSET, "tyre001", VehicleStylesDemo::PROP_REDTYRE, true);

		for(int rb=0; rb<m_resetableRigidBodies.getSize(); rb++)
		{
			m_resetableRigidBodies[rb]->resetRB(m_world);
		}

		m_world->unlock();

		for(int step=0; step< 60; step++)
		{
			m_world->stepDeltaTime(1.0f / 240.f);
		}
	}
}

hkDemo::Result VehicleStylesDemo::stepDemo()
{
	_handleKeyPresses();

	//
	// Step the world.
	//
	{
		VehicleStylesDemoBase::stepDemo();
	}

	// Update the prop display objects transform based on the their rbs
	{
		const hkBool frustumCull = true;
		if(!frustumCull)
		{
			for(int propID=0; propID<m_propRBData.getSize(); ++propID)
			{
				int displayObjectId = m_propRBData[propID]->m_instancedDisplayID;
				int propType = m_propRBData[propID]->m_propType;

				hkpRigidBody* propRB = m_propRBData[propID]->m_propRigidBody;
				hkTransform rbTransform = propRB->getTransform();

				const int numBodyDisplayObjs = m_propTypeDisplayData[propType]->m_bodyDisplayObjects.getSize();
				for(int propPartIdx=0; propPartIdx<numBodyDisplayObjs; ++propPartIdx)
				{
					hkgInstancedDisplayObject* propMesh = m_propTypeDisplayData[propType]->m_bodyDisplayObjects[propPartIdx];
                    propMesh->setTransformAligned(rbTransform, displayObjectId);
               }
			}
		}
		else
		{
			// Only render props that are visible by the camera
			hkArray<int > numVisibleObjectsPerProp; numVisibleObjectsPerProp.setSize(m_propTypeDisplayData.getSize(), 0);

			hkgCamera* cam = m_env->m_window->getViewport(0)->getCamera();
			for(int propID=0; propID<m_propRBData.getSize(); ++propID)
			{
				int propType = m_propRBData[propID]->m_propType;

				hkpRigidBody* propRB = m_propRBData[propID]->m_propRigidBody;
				hkTransform rbTransform = propRB->getTransform();
				HK_ALIGN_REAL(float pos[4]); rbTransform.getTranslation().store<4>(&pos[0]);


				if(cam->sphereVisible(pos, 1.f))
				{
					const int numBodyDisplayObjs = m_propTypeDisplayData[propType]->m_bodyDisplayObjects.getSize();
					for(int propPartIdx=0; propPartIdx<numBodyDisplayObjs; ++propPartIdx)
					{
						hkgInstancedDisplayObject* propMesh = m_propTypeDisplayData[propType]->m_bodyDisplayObjects[propPartIdx];
                        propMesh->setTransformAligned(rbTransform, numVisibleObjectsPerProp[propType]);
                    }
                    numVisibleObjectsPerProp[propType] += 1;
				}
			}

			// Set the number of objects based on what's visible
			for(int propType=0; propType<m_propTypeDisplayData.getSize(); propType++)
			{
				if(m_propTypeDisplayData[propType] == HK_NULL)
					continue;

				for(int propPartIdx=0; propPartIdx<m_propTypeDisplayData[propType]->m_bodyDisplayObjects.getSize(); ++propPartIdx)
				{
					if(m_propTypeDisplayData[propType]->m_bodyDisplayObjects[propPartIdx]->getNumObjects() != numVisibleObjectsPerProp[propType])
					{
						m_propTypeDisplayData[propType]->m_bodyDisplayObjects[propPartIdx]->setNumObjects(numVisibleObjectsPerProp[propType]);
					}
				}
			}
		}
	}

	m_world->lock();

	// Keep the vehicle activated.
	if(m_displayVehicleData)
	{
		VehicleDisplayUtils::updateInfo( m_env, m_vehiclesDisplayInfo[m_controlledVehicleID] );
	}

	m_world->unlock();

	return DEMO_OK;
}

VehicleStylesDemo::~VehicleStylesDemo( )
{
	m_world->lock();

	for(int rb=0; rb<m_resetableRigidBodies.getSize(); rb++)
	{
		m_resetableRigidBodies[rb]->removeReference();
	}
	for(int p=0; p<m_propRBData.getSize(); ++p)
	{
		delete m_propRBData[p];
	}
	if (m_env->m_displayWorld)
	{
		for(int p=0; p<m_propTypeDisplayData.getSize(); ++p)
		{
			if(m_propTypeDisplayData[p] == HK_NULL)
				continue;

			for(int d=0; d<m_propTypeDisplayData[p]->m_bodyDisplayObjects.getSize(); d++)
			{
				m_env->m_displayWorld->removeDisplayObject( m_propTypeDisplayData[p]->m_bodyDisplayObjects[d] );
				m_propTypeDisplayData[p]->m_bodyDisplayObjects[d]->removeReference();
			}

			delete m_propTypeDisplayData[p];
		}
		m_propTypeDisplayData.clear();
	}


	m_world->unlock();
}


static const char helpString[] = "Linear casts give the wheels better interaction with the landscape";

HK_DECLARE_DEMO_VARIANT_USING_STRUCT( VehicleStylesDemo, HK_DEMO_TYPE_PHYSICS_2012, VehicleStylesDemoVariant, VehicleStylesDemo::g_variants, helpString );

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
