/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */

#ifndef HK_WheelVehicleDemo_H
#define HK_WheelVehicleDemo_H

#include <Demos/DemoCommon/DemoFramework/hkDefaultPhysics2012Demo.h>
#include <Demos/DemoCommon/Utilities/VehicleApi/VehicleSetup.h>
#include <Demos/DemoCommon/Utilities/VehicleDisplay/VehicleDisplayUtils.h>
#include <Demos/DemoCommon/Utilities/GameUtils/TweakerUtils.h>

#include <Physics2012/Vehicle/hkpVehicleInstance.h>
#include <Physics2012/Vehicle/Camera/hkp1dAngularFollowCam.h>

class hkpVehicleInstance;
class hkp1dAngularFollowCam;
class hkDefaultAnalogDriverInput;
class hkpReorientAction;
class hkRagdoll;

struct WheelVehicleDemoTweakerOptions
{
	HK_DECLARE_REFLECTION();
	bool m_landscape;		// True = mopp landscape, false = simple flat landscape
	bool m_hill;			// True = simple landscale has hill
	bool m_axles;			// True = simulate solid axle connecting each pair of wheels (0 and 1, 2 and 3, etc.), false = spin independently
	bool m_linearCast;		// True = use linear cast, false = use raycast

	WheelVehicleDemoTweakerOptions()
	{
		m_landscape = true;
		m_hill = false;
		m_axles = false;
		m_linearCast = false;
	}
};

class WheelVehicleDemo : public hkDefaultPhysics2012Demo
{
	public:
		HK_DECLARE_CLASS_ALLOCATOR(HK_MEMORY_CLASS_DEMO);

		WheelVehicleDemo(hkDemoEnvironment* env);

		virtual ~WheelVehicleDemo();

		void makeFakeInput();
		virtual Result stepDemo(); 

	protected:

		virtual void steer();

		void setupWorld();		// Create the hkpWorld and add static geometry
		void buildLandscape();	// Create a MOPP surface to drive on and add it to the world
		void setupVehicles();	// Create vehicles and add them to the world

		// Helpers for buildLandscape()
		void createDodgeBoxes(hkUint16 num, hkVector4& halfExtents, hkVector4& startPos, hkVector4& diffPos);
		static void createRagdollGrid( hkpWorld* world, int x_size, int y_size, hkReal xStep, hkReal yStep);

		// Creates an individual vehicle given a setup and a rigid body
		void createVehicle( VehicleSetup& vehicleSetup, hkpRigidBody* chassis);

		// Functions to create different types of vehicles
		void createCar();
		void createArticulated();

		// Creates display wheels for all vehicles
		virtual void createDisplayWheels(hkReal radius = 0.4f, hkReal thickness = 0.2f);

		// Collision filtering layers
		static const int m_collisionLayer = 1;	// ragdolls
		static const int m_castLayer = 2;		// Wheel raycasts, linear casts
		static const int m_chassisLayer = 3;	// chassis

		hkArray< VehicleDisplayUtils::VehicleDataAndDisplayInfo > m_vehicles;
		hkArray< hkArray< class hkpWheel* > > m_wheels;
		hkArray< hkArray< hkpWheelFrictionConstraintAtom::Axle > > m_axles;
	
		hkp1dAngularFollowCam m_camera;

		hkReal m_inputXPosition;
		hkReal m_inputYPosition;
		
		// Stores triangle data for extended mesh shape landscape
		class FlatLand* m_track;

		// For use with calls to the displayHandler.
		int m_tag;

		// m_displayWheelId is for display reference only.
		// An hkArray with one element for each vehicle. Each vehicle element in turn
		// is an hkArray with one element for each wheel.
		hkArray< hkArray<int> > m_displayWheelId;

		static WheelVehicleDemoTweakerOptions s_tweakerOptions;
		DemoMouseTweaker::MouseTweakerSettings m_mouseTweakerSettings;
};

#endif // HK_WheelVehicleDemo_H

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
