/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */

#include <Demos/demos.h>
#include <Demos/Physics2012/Api/Dynamics/RigidBodies/Modifiers/SoftContact/SoftContactDemo.h>

#include <Physics2012/Utilities/Collide/ContactModifiers/SoftContact/hkpSoftContactUtil.h>

SoftContactDemo::SoftContactDemo(hkDemoEnvironment* env)
:	hkDefaultPhysics2012Demo(env)
{
	// Disable warnings:									
	hkError::getInstance().setEnabled(0xf0de4356, false); // 'Your m_contactRestingVelocity seems to be too small'
	hkError::getInstance().setEnabled(0x12015a6e, false); // 'Using soft contacts (scaling of response force) in TOI events. This may cause a significant performance drop...'
	
	//
	// Setup the camera
	//
	{
		hkVector4 from(0.0f, -12.0f, 4.0f);
		hkVector4 to  (0.0f, 0.0f,  0.0f);
		hkVector4 up  (0.0f, 0.0f,  1.0f);
		setupDefaultCameras( env, from, to, up );
	}

	//
	// Create the world
	//

	{
		hkpWorldCinfo info;

		info.m_gravity.set(0.0f, 0.0f, -9.81f);
		info.setupSolverInfo(hkpWorldCinfo::SOLVER_TYPE_4ITERS_MEDIUM); 
		info.m_collisionTolerance = 0.01f;
		info.m_contactRestingVelocity = 0.01f;
		info.m_simulationType = info.SIMULATION_TYPE_CONTINUOUS;
		//info.m_contactRestingVelocity = HK_REAL_MAX;
		info.m_enableDeactivation = false;
		
		m_world = new hkpWorld( info );
		m_world->lock();

		// Register ALL agents (though some may not be necessary)
		hkpAgentRegisterUtil::registerAllAgents(m_world->getCollisionDispatcher());

		setupGraphics();
	}


	//
	// Create the base
	//
	hkpRigidBody* ground;
	{
		hkVector4 baseSize( 15.0f, 15.0f, 15.0f);
		hkpConvexShape* shape = new hkpBoxShape( baseSize , 0 );

		hkpRigidBodyCinfo ci;

		ci.m_shape = shape;
		ci.m_motionType = hkpMotion::MOTION_FIXED;
		ci.m_position(2) = -15.0f;

		ground = new hkpRigidBody( ci );
		m_world->addEntity( ground )->removeReference();
		shape->removeReference();
	}	

	// 
	// Create normal + wiggly pole
	// 
	for(int i = 0; i < 2; i++)
	{
		hkpRigidBodyCinfo info;
		info.m_shape = new hkpBoxShape( hkVector4(1.0f, 1.0f, 1.0f), 0.0f );
		hkpInertiaTensorComputer::setShapeVolumeMassProperties(info.m_shape, 1.0f, info);
		info.m_position.set( !i? -1.8f : 1.8f, 0.0f, 2.0f );
		info.m_rotation.setAxisAngle( hkVector4(0.0f, 1.0f, 0.0f), 30.0f * HK_REAL_DEG_TO_RAD );
		
		hkpRigidBody* body = new hkpRigidBody(info);
		m_world->addEntity(body);

			// the second object will get a soft contact 
		if (i == 1)
		{
			hkReal forceScale = 0.05f;
			hkReal maxAccel   = 20.0f;
			hkpSoftContactUtil* scu = new hkpSoftContactUtil(body, ground, forceScale, maxAccel );
			
			// the soft contact util is self referencing as long as body is lives,
			// so we can simply remove a reference here
			scu->removeReference();
		}
		body->removeReference();
		info.m_shape->removeReference();
	}

	m_world->unlock();
}

SoftContactDemo::~SoftContactDemo()
{
	// Re-enable warnings:									
	hkError::getInstance().setEnabled(0xf0de4356, true);
	hkError::getInstance().setEnabled(0x12015a6e, true);

}


static const char helpString[] = \
"This demo shows the difference in behavior of normal contacts and contacts softened with hkpSoftContactUtil. " \
"The utility scales response forces for a chosen pair of bodies. Note however that this may cause significant " \
"performance drops when using with continuous collision detection.";

HK_DECLARE_DEMO(SoftContactDemo, HK_DEMO_TYPE_PHYSICS_2012, "Softening collision response.", helpString);

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
