/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */

#ifndef HK_SOLVER_BUFFER_DEMO_H
#define HK_SOLVER_BUFFER_DEMO_H

#include <Demos/DemoCommon/DemoFramework/hkDefaultPhysics2012Demo.h>

/// This demo shows how to resize the solver buffer at runtime if you are running out of solver memory
class ResizeSolverBufferDemo : public hkDefaultPhysics2012Demo
{
public:
	HK_DECLARE_CLASS_ALLOCATOR(HK_MEMORY_CLASS_DEMO);

	ResizeSolverBufferDemo(hkDemoEnvironment* env);
	~ResizeSolverBufferDemo();

	Result stepDemo();

public:

	hkWorldMemoryAvailableWatchDog::MemUsageInfo m_memUsageInfo;

	// Backup of original buffer in the memory system's hkSolverAllocator
	char* m_originalBuffer;
	int m_originalBufferSize;

	// A manually allocated (and freed) buffer
	char* m_myBuffer;
	int m_myBufferSize;
};


#endif // HK_SOLVER_BUFFER_DEMO_H

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
