/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */

#include <Demos/demos.h>

#include <Common/Visualize/hkDebugDisplay.h>

#include <Physics2012/Dynamics/World/hkpSimulationIsland.h>
#include <Physics2012/Dynamics/World/Simulation/hkpSimulation.h>

#include <Physics/Constraint/Data/Hinge/hkpHingeConstraintData.h>
#include <Physics/Constraint/Data/LimitedHinge/hkpLimitedHingeConstraintData.h>

#include <Demos/Physics2012/Api/Constraints/Solver/SolverWorld.h>
#include <Physics2012/Dynamics/Entity/hkpRigidBody.h>

//
//	Constructor

hkpSolverWorld::hkpSolverWorld()
:	hkReferencedObject()
{
}

//
//	Destructor

hkpSolverWorld::~hkpSolverWorld()
{
}

//
//	Collects all rigid bodies from the world. Assumes the world is locked

void hkpSolverWorld::collectRigidBodies(hkpWorld* physicsWorld, hkArray<class hkpRigidBody*>& rigidBodiesOut)
{
	// Get bodies in the active islands
	const hkArray<hkpSimulationIsland*>& activeIslands = physicsWorld->getActiveSimulationIslands();
	for (int i = activeIslands.getSize() - 1; i >= 0; i--)
	{
		const hkpSimulationIsland* island = activeIslands[i];
		collectRigidBodies(island, rigidBodiesOut);
	}

	// Get bodies in the inactive islands
	const hkArray<hkpSimulationIsland*>& inactiveIslands = physicsWorld->getInactiveSimulationIslands();
	for (int i = inactiveIslands.getSize() - 1; i >= 0; i--)
	{
		const hkpSimulationIsland* island = inactiveIslands[i];
		collectRigidBodies(island, rigidBodiesOut);
	}

	// Get fixed bodies
	collectRigidBodies(physicsWorld->getFixedIsland(), rigidBodiesOut);
}

//
//	Collects all rigid bodies in the given simulation island

void hkpSolverWorld::collectRigidBodies(const class hkpSimulationIsland* island, hkArray<hkpRigidBody*>& rigidBodiesOut)
{
	const hkArray<hkpEntity*>& entities = island->getEntities();
	for (int ei = entities.getSize() - 1; ei >= 0; ei--)
	{
		hkpEntity* entity = const_cast<hkpEntity*>(entities[ei]);
		hkpRigidBody* rigidBody = (hkpRigidBody*)entity;

		// Try to locate it in the solver world
		if ( rigidBodiesOut.indexOf(rigidBody) >= 0 )
		{
			HK_ASSERT2(0x4d66add8, false, "Multiple instances of the same rigid body found in world!");
			continue;
		}

		// Must add
		rigidBodiesOut.pushBack(rigidBody);
	}
}

//
//	Collects all constraints from the world. Assumes the world is locked

void hkpSolverWorld::collectConstraints(hkArray<hkpRigidBody*>& rigidBodies, hkArray<hkpConstraintInstance*>& constraintsOut)
{
	for (int bi = rigidBodies.getSize() - 1; bi >= 0; bi--)
	{
		// Get body
		hkpRigidBody* rigidBody = rigidBodies[bi];

		// Get its constraints
		const int numConstraints = rigidBody->getNumConstraints();
		for (int ci = 0; ci < numConstraints; ci++)
		{
			hkpConstraintInstance* constraint = const_cast<hkpConstraintInstance*>(rigidBody->getConstraint(ci));
			const hkpConstraintData* data = constraint->getData();
			
			switch ( data->getType() )
			{
			case hkpConstraintData::CONSTRAINT_TYPE_CONTACT:
				{
					// Ignore contacts
				}
				break;

			default:
				{
					// See if the constraint has already been added
					int jointIdx = constraintsOut.indexOf(constraint);
					if ( jointIdx < 0 )
					{
						// Must add a new one!
						constraintsOut.pushBack(constraint);
					}
				}
				break;
			}
		}
	}
}

//
//	END!
//

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
