/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */

#include <Demos/demos.h>
#include <Demos/Physics2012/Api/Constraints/HingeWithFriction/HingeWithFrictionDemo.h>


// We will need these collision agents
#include <Physics2012/Collide/Agent/ConvexAgent/BoxBox/hkpBoxBoxAgent.h>

// We need to create a constraint
#include <Physics/Constraint/Data/LimitedHinge/hkpLimitedHingeConstraintData.h>

// We want to turn on constraint viewers for this demo
#include <Physics2012/Utilities/VisualDebugger/Viewer/Dynamics/hkpConstraintViewer.h>

#include <Physics/Constraint/Motor/Position/hkpPositionConstraintMotor.h>

HingeWithFrictionDemo::HingeWithFrictionDemo(hkDemoEnvironment* env)
: hkDefaultPhysics2012Demo(env)
{
	m_time = 0.0f;

	//
	// Setup the camera
	//
	{
		hkVector4 from(5.0f, 2.0f, 5.0f);
		hkVector4 to(0.0f, 0.0f, 0.0f);
		hkVector4 up(0.0f, 1.0f, 0.0f);
		setupDefaultCameras( env, from, to, up );
	}


	//
	// Create the world
	//
	{
		hkpWorldCinfo info;
		info.setupSolverInfo(hkpWorldCinfo::SOLVER_TYPE_8ITERS_MEDIUM); 
		info.m_enableDeactivation = false;
 		m_world = new hkpWorld( info );
		m_world->lock();

		//
		// Create constraint viewer
		//
		m_debugViewerNames.pushBack( hkpConstraintViewer::getName() );
		hkpConstraintViewer::m_scale = 1.0f;
		
		setupGraphics();

		// Register the single agent required (a hkpBoxBoxAgent)
		hkpAgentRegisterUtil::registerAllAgents( m_world->getCollisionDispatcher() );
	}
	
	//
	// Create vectors to be used for setup
	//
	hkVector4 pivot(0.0f, 0.0f, 0.0f);
	hkVector4 halfSize(1.0f, 0.25f, 0.5f);

	//
	// Create Box Shape
	//
	hkpBoxShape* boxShape;
	{
		boxShape = new hkpBoxShape( halfSize , 0 );
	}

	//
	// Create fixed rigid body
	//
	hkpRigidBody* fixedBody;
	{
		hkpRigidBodyCinfo info;
		info.m_position.set(-2.0f, 0.0f, 0.0f);
		info.m_shape = boxShape;
		info.m_motionType = hkpMotion::MOTION_FIXED;
		fixedBody = new hkpRigidBody(info);
		m_world->addEntity(fixedBody);
		fixedBody->removeReference();	
	}


	//
	// Create movable rigid body
	//
	hkpRigidBody* moveableBody;
	{
		hkpRigidBodyCinfo info;
		info.m_position.set(2.0f, 0.0f, 0.0f);
		info.m_shape = boxShape;
		
			// Compute the box inertia tensor
		hkMassProperties massProperties;
		info.m_mass = 10.0f;
		hkpInertiaTensorComputer::computeBoxVolumeMassProperties(halfSize, info.m_mass, massProperties);
		info.m_inertiaTensor = massProperties.m_inertiaTensor;
		info.m_centerOfMass = massProperties.m_centerOfMass;	
		info.m_motionType = hkpMotion::MOTION_BOX_INERTIA;
		moveableBody = new hkpRigidBody(info);
		m_world->addEntity(moveableBody);
		moveableBody->removeReference();	
	}

	//
	//	Let a few cubes fall on our hinge
	//
	{
		hkpBoxShape* smallCube = new hkpBoxShape( hkVector4(0.1f, .1f, .1f), 0 );

		for ( int i = 0; i < 10; i++)
		{
			hkpRigidBodyCinfo info;
			//info.m_position.set(2.5f, i*2.0f + 2.0f, 0.0f);
			info.m_position(0) = 2.5f;
			info.m_position(1) = i * 2.0f + 2.0f;
			info.m_position(2) = 0.0f;
			info.m_position(3) = 0.0f;
			info.m_shape = smallCube;

			// Compute the box inertia tensor
			hkMassProperties massProperties;
			info.m_mass = 1.0f;
			hkpInertiaTensorComputer::computeBoxVolumeMassProperties(halfSize, info.m_mass, massProperties);
			info.m_inertiaTensor = massProperties.m_inertiaTensor;
			info.m_centerOfMass = massProperties.m_centerOfMass;	
			info.m_motionType = hkpMotion::MOTION_BOX_INERTIA;
			hkpRigidBody* fallingBody = new hkpRigidBody(info);
			m_world->addEntity(fallingBody);
			fallingBody->removeReference();	
		}
		smallCube->removeReference();
	}



	//
	//	Cleanup shape references
	//
	boxShape->removeReference();
	boxShape = HK_NULL;

	
	//
	// CREATE POWERED HINGE CONSTRAINT
	// 
	{
		hkpLimitedHingeConstraintData* hinge = new hkpLimitedHingeConstraintData();

		hinge->setInBodySpace( hkVector4(-2,0,0), hkVector4(2,0,0),
			hkVector4(0,0,1), hkVector4(0,0,1),
		hkVector4(0,1,0), hkVector4(0,1,0));
		hinge->setMaxFrictionTorque( 250.0f );

		//
		//	Create and add the constraint
		//
		hkpConstraintInstance* constraint = new hkpConstraintInstance(moveableBody, fixedBody, hinge );
		m_world->addConstraint(constraint);

		hinge->disableLimits();

		m_constraintData = hinge;
		constraint->removeReference();
	}

	m_world->unlock();
}


HingeWithFrictionDemo::~HingeWithFrictionDemo()
{
	m_constraintData->removeReference();
}

hkDemo::Result HingeWithFrictionDemo::stepDemo()
{
	return hkDefaultPhysics2012Demo::stepDemo();
}



static const char helpString[] = \
".";

HK_DECLARE_DEMO(HingeWithFrictionDemo, HK_DEMO_TYPE_PHYSICS_2012, "A single Hinge with friction constraint", helpString);

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
