/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */

// A demo which shows a single Destruction constraint

#ifndef HK_DESTRUCTION_CONSTRAINT_API_DEMO_H
#define HK_DESTRUCTION_CONSTRAINT_API_DEMO_H

#include <Demos/DemoCommon/DemoFramework/hkDefaultPhysics2012Demo.h>

class DestructionConstraintDemo : public hkDefaultPhysics2012Demo
{
public:

	HK_DECLARE_CLASS_ALLOCATOR(HK_MEMORY_CLASS_DEMO);

	DestructionConstraintDemo(hkDemoEnvironment* env);

	hkDemo::Result stepDemo();

	hkBool objectPicked(const hkgDisplayObject* displayObject, const hkVector4& worldPosition, const hkgViewportPickData* pd);
	void objectReleased();

protected:

	hkpRigidBody* m_bodyA;
	hkpRigidBody* m_bodyB;
	class hkpDeformableFixedConstraintData* m_constraint;
	bool m_externalStress;
};

#endif	// HK_DESTRUCTION_CONSTRAINT_API_DEMO_H

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
