/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */


#ifndef HK_RAGDOLL_POSE_RECOVERY_H
#define HK_RAGDOLL_POSE_RECOVERY_H


#include <Demos/DemoCommon/DemoFramework/hkDefaultPhysics2012Demo.h>
#include <Common/Base/Algorithm/PseudoRandom/hkPseudoRandomGenerator.h>

class hkProjections;

///[introduction_text]
/// This demo shows a use of constraints projection on rag dolls. 

class RagdollPoseRecoveryDemo : public hkDefaultPhysics2012Demo
{
	public:

		HK_DECLARE_CLASS_ALLOCATOR(HK_MEMORY_CLASS_DEMO);

		RagdollPoseRecoveryDemo(hkDemoEnvironment* env);
		~RagdollPoseRecoveryDemo();

		Result stepDemo();

		void constraintViolatedCallback( hkpConstraintInstance* constraint );

		void setupInvalidRagdollPose(hkReal fraction);

	protected:

		class ConstraintProjectorListener*	m_violatedConstraintListener;
		int									m_shootGunDelay;
		hkArray<hkVector4>					m_lastImpactPositions;
		hkArray<hkVector4>					m_lastImpactDirections;
		hkPseudoRandomGenerator				m_rndGen;
		hkArray<class hkpPhysicsSystem*>	m_ragdolls;
		bool								m_doProjection;

		bool	m_settingUp;

		hkReal m_simTime;
		bool m_constraintRestorationUnderway;
		class hkpEaseConstraintsAction* m_easeConstraintsAction;
};

#endif

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
