/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */


#ifndef HK_CHAIN_CFM_DEMO_H
#define HK_CHAIN_CFM_DEMO_H

#include <Demos/DemoCommon/DemoFramework/hkDefaultPhysics2012Demo.h>


	/// This demos shows how to make constraints softer by modifying the constraint matrix with a constraint mixing force (cfm)
class ChainCfmDemo : public hkDefaultPhysics2012Demo
{
	public:

		HK_DECLARE_CLASS_ALLOCATOR(HK_MEMORY_CLASS_DEMO);

		ChainCfmDemo(hkDemoEnvironment* env);

		Result stepDemo();

			// Control of cfms
		hkReal m_cfmAdditive;
		hkReal m_cfmMultiplicative;

			//
			// Members for access to user controlled variables
			//

		int m_selectedController;

		struct ControllerInfo
		{
			HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR(HK_MEMORY_CLASS_BASE,ChainCfmDemo::ControllerInfo);
			hkReal* m_var;
			const char* m_name;
		};

		hkArray<ControllerInfo> m_controllers;

		void initControllerInfos();
};

#endif	// HK_CHAIN_CFM_DEMO_H

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
