/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */

#ifndef HK_USER_VOXEL_SHAPE_COLLECTION_H
#define HK_USER_VOXEL_SHAPE_COLLECTION_H

#include <Physics2012/Collide/Shape/Compound/Collection/hkpShapeCollection.h>

// This is an example Shape Collection used to represent a voxelized world.
// Each shape key represents a single voxel, where a voxel is made up of triangles.
// The triangle data is created and stored elsewhere (see VoxelData) but returned
// in the hkpShapeBuffer as an hkpExtendedMeshShape by getChildShape.

class MarchingCubes;
extern hkReal hkConvexShapeDefaultRadius;

class UserVoxelShapeCollection : public hkpShapeCollection
{
	public:
	HK_DECLARE_CLASS_ALLOCATOR(HK_MEMORY_CLASS_BASE);

	UserVoxelShapeCollection( MarchingCubes* voxelData, const hkReal& radius = hkConvexShapeDefaultRadius );

	virtual ~UserVoxelShapeCollection();

		/// hkpShapeCollection interface implementation.
	virtual hkpShapeKey getFirstKey() const;

		/// hkpShapeCollection interface implementation.
	virtual hkpShapeKey getNextKey( hkpShapeKey oldKey ) const;

		/// hkpShapeCollection interface implementation.
	virtual const hkpShape* getChildShape( hkpShapeKey key, hkpShapeBuffer& buffer ) const;

		/// hkpShapeContainer interface implementation.
	virtual hkUint32 getCollisionFilterInfo(hkpShapeKey key) const;

		/// hkpShapeCollection interface implementation.
	virtual void initWeldingInfo( hkpWeldingUtility::WeldingType weldingType );

		/// hkpShapeCollection interface implementation.
	virtual void setWeldingInfo(hkpShapeKey key, hkInt16 weldingInfo);

	//
	// hkpShape interface
	//

	// hkpShape interface implementation.
	virtual void getAabb(const hkTransform& localToWorld, hkReal tolerance, hkAabb& aabbOut) const;
	//HKP_SHAPE_VIRTUAL void getAabbImpl( HKP_SHAPE_VIRTUAL_THIS const hkTransform& localToWorld, hkReal tolerance, hkAabb& out ) HKP_SHAPE_VIRTUAL_CONST;

	// Don't need to implement this; just use the default hkpShapeCollection's implementation
	// Our custom BvTreeShape will handle this.
	//hkBool castRayImpl( HKP_SHAPE_VIRTUAL_THIS const hkpShapeRayCastInput& input, hkpShapeRayCastOutput& output) HKP_SHAPE_VIRTUAL_CONST;

	/// Get the radius of this shape. This will be the radius of all triangles created by the shape.
	inline hkReal getRadius() const { return m_radius; }

	/// Sets the radius of this shape.
	inline void setRadius(hkReal newRadius) { m_radius = newRadius; }

	MarchingCubes* getVoxelData() const { return m_voxelData; }

private:
	MarchingCubes* m_voxelData;

	hkReal m_radius;
};


#endif //HK_USER_VOXEL_SHAPE_COLLECTION_H

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
