/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */

#include <Demos/demos.h>
#include <Demos/Physics2012/Api/Collide/Shapes/Voxel/UserVoxelShapeCollection.h>
#include <Demos/DemoCommon/Utilities/MarchingCubes/MarchingCubes.h>

#include <Common/Base/Types/Geometry/Aabb/hkAabb.h>
#include <Common/Base/Types/Geometry/Aabb/hkAabbUtil.h>

#include <Physics2012/Collide/Shape/Compound/Collection/ExtendedMeshShape/hkpExtendedMeshShape.h>

UserVoxelShapeCollection::UserVoxelShapeCollection( MarchingCubes* voxelData, const hkReal& radius )
: hkpShapeCollection( hkcdShapeType::COLLECTION, COLLECTION_USER )
, m_voxelData(voxelData)
, m_radius(radius)
{
	m_voxelData->addReference();
}

UserVoxelShapeCollection::~UserVoxelShapeCollection()
{
	m_voxelData->removeReference();
}

hkpShapeKey UserVoxelShapeCollection::getFirstKey( ) const
{
	if (m_voxelData->isVoxelEmpty( 0 ))
	{
		return getNextKey( 0 );
	}

	return 0;
}

hkpShapeKey UserVoxelShapeCollection::getNextKey( hkpShapeKey oldKey ) const
{
	hkpShapeKey newKey = oldKey + 1;

	// Skip over empty voxels
	while (newKey < m_voxelData->getNumVoxels() && m_voxelData->isVoxelEmpty( newKey ) )
	{
		 ++newKey;
	}

	if (newKey >= m_voxelData->getNumVoxels())
	{
		return HK_INVALID_SHAPE_KEY;
	}

	return newKey;
}

const hkpShape* UserVoxelShapeCollection::getChildShape( hkpShapeKey key, hkpShapeBuffer& buffer ) const
{
	int x, y, z;
	m_voxelData->indexToVoxel( key, x, y, z );

	// Use the shape buffer to construct an extended mesh shape
	hkpExtendedMeshShape* HK_RESTRICT mesh = new (&buffer) hkpExtendedMeshShape( m_radius );
	hkpExtendedMeshShape::TrianglesSubpart subpart;
	
	const MarchingCubes::VoxelTriangles& triData = m_voxelData->getTrianglesAt( key );

	if (triData.m_indices.getSize() > 0)
	{
		subpart.m_indexBase         = triData.m_indices.begin();
		subpart.m_vertexBase        = (hkReal*)triData.m_vertices.begin();
		subpart.m_indexStriding     = 3;
		subpart.m_vertexStriding    = sizeof(hkVector4);
		subpart.m_stridingType      = hkpExtendedMeshShape::INDICES_INT8;
		subpart.m_numVertices       = triData.m_vertices.getSize();
		subpart.m_numTriangleShapes = triData.m_indices.getSize() / 3;
		mesh->addTrianglesSubpart( subpart );
	}

	return mesh;
}

// hkpShapeContainer interface implementation.
hkUint32 UserVoxelShapeCollection::getCollisionFilterInfo(hkpShapeKey key) const
{
	return 0;
}

// hkpShapeCollection interface implementation.
void UserVoxelShapeCollection::initWeldingInfo( hkpWeldingUtility::WeldingType weldingType )
{

}

// hkpShapeCollection interface implementation.
void UserVoxelShapeCollection::setWeldingInfo(hkpShapeKey key, hkInt16 weldingInfo)
{
}

void UserVoxelShapeCollection::getAabb(const hkTransform& localToWorld, hkReal tolerance, hkAabb& aabbOut) const
{
	hkVector4 halfExtents;
	{
		int x, y, z;
		m_voxelData->getGridSize( x, y, z );
		halfExtents.set( x * .5f, y * .5f, z * .5f );
		halfExtents.mul( m_voxelData->getVoxelSize() );
	}

	hkAabbUtil::calcAabb( localToWorld, halfExtents, halfExtents, hkSimdReal::fromFloat(tolerance), aabbOut );
}

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
