/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */

#ifndef HK_USER_VOXEL_BV_TREE_SHAPE_H
#define HK_USER_VOXEL_BV_TREE_SHAPE_H

#include <Physics2012/Collide/Shape/Compound/Tree/hkpBvTreeShape.h>
#include <Demos/Physics2012/Api/Collide/Shapes/Voxel/UserVoxelShapeCollection.h>

// This example shape represents a Bounding Volume (mid-phase) implementation 
// for a voxelized terrain shape.  The voxels are created and stored elsewhere
// (see VoxelData).
//
// This shape is used to quickly determine which voxels (and therefore which
// triangles) are needed to perform narrow phase collision detection.  It 
// wraps a UserVoxelShapeCollection.
//
// Note: This example only demonstrates collision detection.  Ray casting is
// not supported.  While shape casting may work, is not optimized.

class UserVoxelBvTreeShape : public hkpBvTreeShape
{
public:
	HK_DECLARE_CLASS_ALLOCATOR(HK_MEMORY_CLASS_BASE);

	UserVoxelBvTreeShape( const UserVoxelShapeCollection* c );

	//
	// hkpBvTreeShape interface
	//

	/// Returns the hkpShapeKey for all shapes in the hkpShapeCollection that intersect with the OBB (defined by obbTransform and obbExtent).
	/// This implementation simply bounds the OBB by an AABB and uses the queryAabb() method. Thus it is not as
	/// accurate as it could be if using a more sophisticated algorithm, and can return triangles completely outside the OBB.
	virtual void queryObb( const hkTransform& obbTransform, const hkVector4& obbExtent, hkReal tolerance, hkArray< hkpShapeKey >& hits ) const;

	/// Returns the hkpShapeKey for all shapes in the hkpShapeCollection that intersect with the AABB.
	virtual void queryAabb( const hkAabb& aabb, hkArray<hkpShapeKey>& hits ) const;

	// hkpBvTreeShape interface implementation.
	HKP_SHAPE_VIRTUAL hkUint32 queryAabbImpl(HKP_SHAPE_VIRTUAL_THIS const hkAabb& aabb, hkpShapeKey* hits, int maxNumKeys ) HKP_SHAPE_VIRTUAL_CONST;

	//
	// hkpShape interface
	//

	// hkpShape interface implementation.
	virtual void getAabb(const hkTransform& localToWorld, hkReal tolerance, hkAabb& out) const;

	// hkpShape interface implementation.
	virtual hkBool castRay(const hkpShapeRayCastInput& input, hkpShapeRayCastOutput& output) const;

	// hkpShape interface implementation.
	virtual void castRayWithCollector(const hkpShapeRayCastInput& input, const hkpCdBody& cdBody, hkpRayHitCollector& collector) const;

	// Retrieves the shape collection
	const UserVoxelShapeCollection* getShapeCollection() const;

	// hkpBvTreeShape interface implementation.
	inline const hkpShapeContainer* getContainer() const {return getShapeCollection()->getContainer();}

	// hkpShape interface implementation. Returns -1 which will force the shape onto the PPU.
	virtual int calcSizeForSpu(const CalcSizeForSpuInput& input, int spuBufferSizeLeft) const { return -1; }

protected:
	class hkpSingleShapeContainer m_childContainer;
};

#endif //HK_USER_VOXEL_BV_TREE_SHAPE_H

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
