/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */

#include <Demos/demos.h>
#include <Demos/Physics2012/Api/Collide/Shapes/Voxel/UserVoxelBvTreeShape.h>
#include <Demos/Physics2012/Api/Collide/Shapes/Voxel/UserVoxelShapeCollection.h>
#include <Demos/DemoCommon/Utilities/MarchingCubes/MarchingCubes.h>

#include <Common/Visualize/hkDebugDisplay.h>
#include <Common/Base/Types/Geometry/Aabb/hkAabb.h>
#include <Common/Base/Types/Geometry/Aabb/hkAabbUtil.h>
#include <Common/Base/Math/Vector/hkIntVector.h>

UserVoxelBvTreeShape::UserVoxelBvTreeShape( const UserVoxelShapeCollection* c )
:	hkpBvTreeShape( hkcdShapeType::BV_TREE, BVTREE_USER ), m_childContainer(c)
{
}

//
// hkpBvTreeShape interface
//

/// Returns the hkpShapeKey for all shapes in the hkpShapeCollection that intersect with the OBB (defined by obbTransform and obbExtent).
/// This implementation simply bounds the OBB by an AABB and uses the queryAabb() method. Thus it is not as
/// accurate as it could be if using a more sophisticated algorithm, and can return triangles completely outside the OBB.
void UserVoxelBvTreeShape::queryObb( const hkTransform& obbTransform, const hkVector4& obbExtent, hkReal tolerance, hkArray< hkpShapeKey >& hits ) const
{
	hkAabb aabb;
	hkAabbUtil::calcAabb( obbTransform, obbExtent, hkSimdReal(tolerance), aabb );

	queryAabb( aabb, hits );
}

const UserVoxelShapeCollection* UserVoxelBvTreeShape::getShapeCollection() const
{
	return static_cast<const UserVoxelShapeCollection*>(m_childContainer.getChild());
}

/// Returns the hkpShapeKey for all shapes in the hkpShapeCollection that intersect with the AABB.
void UserVoxelBvTreeShape::queryAabb( const hkAabb& aabbIn, hkArray<hkpShapeKey>& hits ) const
{
	const MarchingCubes* voxelData = getShapeCollection()->getVoxelData();

	hkIntVector min, max;
	{
		voxelData->positionToGridPoint( aabbIn.m_min, min );
		voxelData->positionToGridPoint( aabbIn.m_max, max );
		HK_DISPLAY_BOUNDING_BOX( aabbIn, hkColor::RED );
	}

	//
	// Write out list of keys
	//
	for (int x = min.getComponent<0>(); x <= max.getComponent<0>(); ++x)
	{
		for (int y = min.getComponent<1>(); y <= max.getComponent<1>(); ++y)
		{
			for (int z = min.getComponent<2>(); z <= max.getComponent<2>(); ++z)
			{
				int index = voxelData->voxelToIndex( x, y, z );
				hkpShapeKey key = (hkUint32)index;
				if (index >= 0 && !voxelData->isVoxelEmpty( key ))
				{
					// Draw debug info
					{
						hkAabb aabb;
						voxelData->gridPointToPosition( x, y, z, aabb.m_min );
						voxelData->gridPointToPosition( x + 1, y + 1, z + 1, aabb.m_max );
						HK_DISPLAY_BOUNDING_BOX( aabb, hkColor::YELLOW );
					}
					hits.pushBack(key);
				}
			}
		}
	}

}

// hkpBvTreeShape interface implementation.
hkUint32 UserVoxelBvTreeShape::queryAabbImpl(HKP_SHAPE_VIRTUAL_THIS const hkAabb& aabbIn, hkpShapeKey* hits, int maxNumKeys ) HKP_SHAPE_VIRTUAL_CONST
{
	HK_TIMER_BEGIN_LIST( "Voxel Aabb Query", "construct min/max");

	const MarchingCubes* voxelData = getShapeCollection()->getVoxelData();

	hkIntVector min, max;
	{
		voxelData->positionToGridPoint( aabbIn.m_min, min );
		voxelData->positionToGridPoint( aabbIn.m_max, max );
		HK_DISPLAY_BOUNDING_BOX( aabbIn, hkColor::RED );
	}

	int hitIndex = 0;

	//
	// Write out list of keys
	//

	HK_TIMER_SPLIT_LIST( "Check voxels" )

	for (int x = min.getComponent<0>(); x <= max.getComponent<0>(); ++x)
	{
		for (int y = min.getComponent<1>(); y <= max.getComponent<1>(); ++y)
		{
			for (int z = min.getComponent<2>(); z <= max.getComponent<2>(); ++z)
			{
				int index = voxelData->voxelToIndex( x, y, z );
				hkpShapeKey key = (hkUint32)index;
				if (index >= 0 && hitIndex < maxNumKeys && !voxelData->isVoxelEmpty( key ))
				{
					// Draw debug info
					{
						hkAabb aabb;
						voxelData->gridPointToPosition( x, y, z, aabb.m_min );
						voxelData->gridPointToPosition( x + 1, y + 1, z + 1, aabb.m_max );
						HK_DISPLAY_BOUNDING_BOX( aabb, hkColor::YELLOW );
					}
					hits[hitIndex] = key;
					++hitIndex;
				}
			}
		}
	}

	HK_TIMER_END_LIST();

	return hitIndex;
}

void UserVoxelBvTreeShape::getAabb(const hkTransform& localToWorld, hkReal tolerance, hkAabb& out) const
{
	getShapeCollection()->getAabb( localToWorld, tolerance, out );
}

hkBool UserVoxelBvTreeShape::castRay(const hkpShapeRayCastInput& input, hkpShapeRayCastOutput& output) const
{
	HK_ASSERT2( 0x0, false, "castRay not implemented." );
	return false;
}

// hkpShape interface implementation.
void UserVoxelBvTreeShape::castRayWithCollector(const hkpShapeRayCastInput& input, const hkpCdBody& cdBody, hkpRayHitCollector& collector) const
{
	HK_ASSERT2( 0x0, false, "castRayWithCollector not implemented." );
}

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
