/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */

#ifndef HK_STATIC_COMPOUND_SHAPE_FILTERING_DEMO_H
#define HK_STATIC_COMPOUND_SHAPE_FILTERING_DEMO_H

#include <Demos/DemoCommon/DemoFramework/hkDefaultPhysics2012Demo.h>
#include <Common/Base/Algorithm/PseudoRandom/hkPseudoRandomGenerator.h>
#include <Common/Base/Algorithm/Noise/hkPerlinNoise2d.h>

class hkpStaticCompoundShape;
class hkDisplayConvex;

/// Demo showing the use of collision filtering with hkpStaticCompoundShape
class StaticCompoundShapeFilteringDemo : public hkDefaultPhysics2012Demo
{
	public:

		HK_DECLARE_CLASS_ALLOCATOR(HK_MEMORY_CLASS_DEMO);

		StaticCompoundShapeFilteringDemo(hkDemoEnvironment* env);
		~StaticCompoundShapeFilteringDemo();		
		hkDemo::Result stepDemo();

	protected:		
		
		hkpShape* createTerrainShape();
		hkpShape* createTreeShape();
		void replaceDisplayGeometry(hkpRigidBody* compoundBody, int terrainInstanceId);
		void calculateTreeTransforms(hkArray<hkQsTransform>& transforms);
		void createFallingBody();
		
		hkPseudoRandomGenerator m_random;
		hkPerlinNoise2d m_heightFieldNoise;
		hkArray< hkRefPtr<hkDisplayConvex> > m_displayGeometries;
		hkRefPtr<hkpGroupFilter> m_groupFilter;				
		int m_numFrames;
		
		hkRefPtr<hkpSphereShape> m_bigSphere;
		hkRefPtr<hkpSphereShape> m_smallSphere;
		hkArray<hkpRigidBody*> m_fallingBodies;
		int m_lastBody;		
};

#endif // HK_STATIC_COMPOUND_SHAPE_FILTERING_DEMO_H

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
