/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */

#ifndef HK_STATIC_COMPOUND_SHAPE_KEY_DISABELING_DEMO_H
#define HK_STATIC_COMPOUND_SHAPE_KEY_DISABELING_DEMO_H

#include <Demos/DemoCommon/DemoFramework/hkDefaultPhysics2012Demo.h>
#include <Common/Base/Algorithm/PseudoRandom/hkPseudoRandomGenerator.h>
#include <Common/Base/Algorithm/Noise/hkPerlinNoise2d.h>
#include <Physics2012/Utilities/Deprecated/H1Group/hkpGroupCollisionFilter.h>

class hkpBvCompressedMeshShape;
class hkpStaticCompoundShape;
class hkResource;


	/// Demo showing construction of a hkpStaticCompoundShape
class StaticCompoundShapeKeyDisablingDemo : public hkDefaultPhysics2012Demo
{
	public:

		HK_DECLARE_CLASS_ALLOCATOR(HK_MEMORY_CLASS_DEMO);

		StaticCompoundShapeKeyDisablingDemo(hkDemoEnvironment* env);
		~StaticCompoundShapeKeyDisablingDemo();		
		hkDemo::Result stepDemo();

	protected:

		void createLevel();
		hkpBvCompressedMeshShape* createBlockWorld();
		void createBlockWorldDisplayShapes();
		void calculateRays(hkArray<hkVector4>& from, hkArray<hkVector4>& to);
		void addDisplayBox( const hkpShape* shape, int filterInfo ); 


		hkpStaticCompoundShape* m_staticCompoundShape;
		int m_numFrames;
};

#endif // HK_STATIC_COMPOUND_SHAPE_KEY_DISABELING_DEMO_H

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
