/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */

#ifndef HK_STATIC_COMPOUND_SHAPE_CONSTRUCTION_DEMO_H
#define HK_STATIC_COMPOUND_SHAPE_CONSTRUCTION_DEMO_H

#include <Demos/DemoCommon/DemoFramework/hkDefaultPhysics2012Demo.h>
#include <Common/Base/Algorithm/PseudoRandom/hkPseudoRandomGenerator.h>
#include <Common/Base/Algorithm/Noise/hkPerlinNoise2d.h>

class hkpStaticCompoundShape;
class hkResource;

	/// Demo showing construction of a hkpStaticCompoundShape
class StaticCompoundShapeConstructionDemo : public hkDefaultPhysics2012Demo
{
	public:

		HK_DECLARE_CLASS_ALLOCATOR(HK_MEMORY_CLASS_DEMO);

		StaticCompoundShapeConstructionDemo(hkDemoEnvironment* env);
		~StaticCompoundShapeConstructionDemo();		
		hkDemo::Result stepDemo();

	protected:		

		void createLevel();

		hkpShape* createTerrainShape();
		hkpShape* createTreeShape();
		hkpShape* createBoulderShape();

		void addDebris();
		void getNextTransform( int i, int j, hkPerlinNoise2d& scale, hkQsTransform& transform);

		class DemoData
		{
		public:
			HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR( HK_MEMORY_CLASS_DEMO, StaticCompoundShapeConstructionDemo::DemoData );
			DemoData();
			void createRays(hkArray<hkVector4>&);
			hkPerlinNoise2d m_heightFieldNoise;
			hkPerlinNoise2d m_treeScaling;
			hkPerlinNoise2d m_boulderScaling;
			hkPseudoRandomGenerator m_random;
			hkArray<hkVector4> m_rays;
		} m_data;

		hkRefPtr<hkpStaticCompoundShape> m_staticCompoundShape;

		hkResource*	m_debrisPackfileData;
};

#endif // HK_STATIC_COMPOUND_SHAPE_CONSTRUCTION_DEMO_H

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
