/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */


#ifndef HK_LandscapeComparisonDemo_H
#define HK_LandscapeComparisonDemo_H

#include <Demos/DemoCommon/DemoFramework/hkDefaultPhysics2012Demo.h>
#include <Physics2012/Collide/Shape/Deprecated/CompressedMesh/hkpCompressedMeshShape.h>
#include <Physics2012/Collide/Shape/Deprecated/CompressedMesh/hkpCompressedMeshShapeBuilder.h>
#include <Common/Base/Algorithm/PseudoRandom/hkPseudoRandomGenerator.h>
#include <Demos/Physics2012/Api/Collide/Shapes/Misc/LandscapeComparison/LandscapeDemoUtil.h>
#include <Demos/Physics2012/Api/Collide/Shapes/Misc/LandscapeComparison/FallingBodyDemoUtil.h>

class hkRootLevelContainer;
class hkpExtendedMeshShape;

	/// A demo on how to use the compressed mesh shape.
class LandscapeComparisonDemo : public hkDefaultPhysics2012Demo
{
	public:

		HK_DECLARE_CLASS_ALLOCATOR(HK_MEMORY_CLASS_DEMO);

		LandscapeComparisonDemo(hkDemoEnvironment* env);
		~LandscapeComparisonDemo();

	public:

		
		// The MOPP shape broken into chunks
		hkpShape* m_shape;

		// Keep track of time and use to move the casts around
		hkReal m_time;

		hkAabb m_bounds;
		int m_minIndex;

		hkArray< hkArray<hkpShapeKey> > m_keys;

		HK_ALIGN16 ( hkSemaphoreBusyWait m_semaphore );

		hkpRigidBody* m_castBody;

		hkpRigidBody* m_terrainBody;
		
		const hkpShape* m_terrainShape;

		hkVector4 m_geometryTranslation;

		hkAabb m_originalAabb;

		bool wireframe ;
		bool showWelded;
		bool showTJ;
		bool m_showChunks;
		//bool showMaterials;
		bool m_showAabb;
		
		bool m_showOriginalGeometry;

		bool m_showBreakdown;
		bool m_serialize;

	public:

		virtual Result stepDemo();

	protected:

		void testRayCast();

		void testLinearCast();

		void randomRayCastScene();

		
		void addDisplayGeometry( hkGeometry geometry, const hkVector4& color, const hkVector4& translate );

		hkPseudoRandomGenerator m_random;

		LandscapeDemoUtil m_landscapeDemoUtil;

		FallingBodyDemoUtil m_fallingBodyDemoUtil;
};



#endif // HK_LandscapeComparisonDemo_H

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
