/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */

#include <Demos/demos.h>
#include <Demos/Physics2012/Api/Collide/Shapes/HeightField/PlaneShape/PlaneShapeDemo.h>

#include <Physics2012/Collide/Shape/HeightField/Plane/hkpPlaneShape.h>

PlaneShapeDemo::PlaneShapeDemo(hkDemoEnvironment* env)
:	hkDefaultPhysics2012Demo(env)
{
	// Setup the camera.
	{
		hkVector4 from(0.0f, 5.0f, 5.0f);
		hkVector4 to  (-0.5f, -0.5f,  -0.5f);
		hkVector4 up  (0.0f, 1.0f,  0.0f);
		setupDefaultCameras(env, from, to, up);
	}

	// Create the world
	hkpWorldCinfo info;
	info.m_gravity.set(0.0f, 0.0f, 0.0f);	
	info.setBroadPhaseWorldSize( 100.0f );
	m_world = new hkpWorld(info);
	m_world->lock();

	setupGraphics();

	// Create the shape
	hkpShape* shape = 0;
	{
		hkAabb aabb;
		{
			aabb.m_min.set( -1.0f, -1.0f, -1.0f );
			aabb.m_max.set( 0.0f, 0.0f, 0.0f );
		}

		hkVector4 planeEquation;
		{
			planeEquation.set( 1.0f, 1.0f, 1.0f );
			planeEquation.normalize3();
			planeEquation( 3 ) = 0.75;
		}

		shape = new hkpPlaneShape( planeEquation, aabb );
	}

	// Make sure that a shape was created
	HK_ASSERT(0, shape);

	// To illustrate using the shape, first define a rigid body template.
	hkpRigidBodyCinfo rigidBodyInfo;
	rigidBodyInfo.m_position.set(0.0f, 0.0f, 0.0f);
	rigidBodyInfo.m_shape = shape;
	rigidBodyInfo.m_motionType = hkpMotion::MOTION_FIXED;

	// Create a rigid body (using the template above).
	hkpRigidBody* rigidBody = new hkpRigidBody(rigidBodyInfo);

	// Remove reference since the body now "owns" the Shape.
	shape->removeReference();

	// Finally add body so we can see it, and remove reference since the world now "owns" it.
	m_world->addEntity(rigidBody);
	rigidBody->removeReference();

	m_world->unlock();
}


static const char helpString[] = "A hkpPlaneShape is a plane bounded by an AABB.";

HK_DECLARE_DEMO( PlaneShapeDemo, HK_DEMO_TYPE_PHYSICS_2012, "The plane shape", helpString );

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
