/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */

#ifndef HKP_BV_COMPRESSED_MESH_DEMO_H
#define HKP_BV_COMPRESSED_MESH_DEMO_H

#include <Demos/DemoCommon/DemoFramework/hkDefaultPhysics2012Demo.h>

class hkpBvCompressedMeshShape;
class hkPerlinNoise2d;
class hkDisplayConvex;


	/// Demo showing the construction and use of hkpBvCompressedMeshShape
class BvCompressedMeshDemo : public hkDefaultPhysics2012Demo
{

	public:

		HK_DECLARE_CLASS_ALLOCATOR(HK_MEMORY_CLASS_DEMO);

		BvCompressedMeshDemo(hkDemoEnvironment* env);
		hkpBvCompressedMeshShape* createBvCompressedMeshShape();
		hkDemo::Result stepDemo();
		~BvCompressedMeshDemo();		

	protected:

		void createMeshGeometry(hkGeometry& geometry);
		void createMeshDisplayGeometry();
		void createFallingShapes();
		void createGroundBox();
		void calculateRays(hkArray<hkVector4>& from, hkArray<hkVector4>& to);
		void drawRayCastOuput(hkVector4Parameter from, hkVector4Parameter to, int layer, const hkpWorldRayCastOutput& output);		

	protected:

		int m_numFrames;
		hkRefPtr<hkpBvCompressedMeshShape> m_meshShape;
		hkRefPtr<hkpRigidBody> m_meshBody;	
		hkArray< hkRefPtr<hkDisplayConvex> > m_displayGeometries;
		hkRefPtr<hkpGroupFilter> m_groupFilter;
};


#endif // HKP_BV_COMPRESSED_MESH_DEMO_H

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
