/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */

// This demo demonstrates the use of contactPointCallbacks.
// When an entity collides with another object a collision callback is fired.
// By deriving a custom class from the standard hkpContactListener class we can
// implement a variety of functions utilizing the collision information.

#ifndef HK_SHAPE_KEYS_IN_CALLBACK_DEMO_H
#define HK_SHAPE_KEYS_IN_CALLBACK_DEMO_H

#include <Demos/DemoCommon/DemoFramework/hkDefaultPhysics2012Demo.h>
#include <Physics2012/Dynamics/Collide/ContactListener/hkpContactListener.h>

class MyContactListener;	// Will handle the collision events. Defined below the ExtendedUserDataDemo
class FlatLand;

class ShapeKeysInCallbackDemo : public hkDefaultPhysics2012Demo
{
	public:

		HK_DECLARE_CLASS_ALLOCATOR( HK_MEMORY_CLASS_DEMO);

		ShapeKeysInCallbackDemo( hkDemoEnvironment* env);
		~ShapeKeysInCallbackDemo();

		Result stepDemo();

		class MyContactListener* m_listener;

		hkpRigidBody* m_body;

		FlatLand* m_flatLand;
};

// This specific implementation is not referenced by any other class, but adds itself
// as a listener to the entity. It automatically deletes itself, if the entity gets 
// deleted.	

class MyContactListener : public hkReferencedObject, public hkpContactListener
{
	public:
		HK_DECLARE_CLASS_ALLOCATOR( HK_MEMORY_CLASS_DEMO );

		// This is the main callback which does most of the work.
		virtual void contactPointCallback( const hkpContactPointEvent& event );
};

#endif // HK_SHAPE_KEYS_IN_CALLBACK_DEMO_H

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
