/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */

#ifndef BROADPHASE_CULLING_DEMO_H
#define BROADPHASE_CULLING_DEMO_H

#include <Demos/DemoCommon/DemoFramework/hkDefaultPhysics2012Demo.h>

#include <Common/Base/Algorithm/PseudoRandom/hkPseudoRandomGenerator.h>

#include <Physics2012/Dynamics/Phantom/hkpSimpleShapePhantom.h>

//
// This demonstrate how to use hkpTreeBroadPhase for frustum culling.
//

class BroadphaseCullingDemo : public hkDefaultPhysics2012Demo
{
	public:

		struct Variant
		{
			HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR(HK_MEMORY_CLASS_DEMO,Variant);

			const char*	m_name;
			const char*	m_details;
			int			m_numRigidBodies;
			int			m_numUserObjects;
		};			

		HK_DECLARE_CLASS_ALLOCATOR(HK_MEMORY_CLASS_DEMO);

		BroadphaseCullingDemo(hkDemoEnvironment* env);
		
		~BroadphaseCullingDemo();

		hkDemo::Result stepDemo();

		hkPseudoRandomGenerator			m_rand;
		hkArray<hkpSimpleShapePhantom*>	m_userObjects;
		hkQuaternion					m_orientations[2];
		hkReal							m_animTime;
		hkBool							m_cullFarPlane;
		hkBool							m_useVelocityForUserObjects;
		hkBool							m_sort;
};

#endif // BROADPHASE_CULLING_DEMO_H

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
