/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */

//
// One or Two diffuse maps, along with a normal and specular map, with and without shadows. The most common demo shaders 
// with 'proper' assets. These will currently also allow loading of a gloss map, but will ignore it
// 

//:STYLE UberVS HK_NULL HK_NULL HK_NULL UberPS UBER

#define NAME_SAMPLERS
#include "CommonHeader.hlslh"

#ifdef HKG_DX10
CBUFFER uber {
#endif
float4x4 g_mWorldInv;
float4x4 g_mWorldView;
float4x4 g_mViewInv;
float4x4 g_mProj;


#ifdef HKG_DX10
};
#endif


struct vertexInputUber {
		float3 position  : POSITION; 	
		float3 normal    : NORMAL; 	
		float2 texCoord0 : TEXCOORD0; 
	#ifdef TWO_TCOORDS	
		float2 texCoord1 : TEXCOORD1; 	
	#endif
	#ifdef HKG_NORMAL_MAP0
		float3 tangent   : TANGENT; 
		float3 binormal  : BINORMAL;	
	#endif
#ifdef HKG_INSTANCING
	float4 transformRow0    : TEXCOORD5; 
	float4 transformRow1    : TEXCOORD6;
	float4 transformRow2	: TEXCOORD7;
#endif
#ifdef HKG_SKINNING
    float4 blendWeights     : BLENDWEIGHT; 
	#if defined(HKG_DX10)
		uint4	blendIndices    : BLENDINDICES;
	#else
		float4  blendIndices    : BLENDINDICES;
	#endif
#endif
	};
	
struct vertexOutputUber {
	float4 position     	: SV_Position; 
	float3 posView	    	: TEXCOORD0; 
	float4 texCoord01    	: TEXCOORD1;
	#ifdef HKG_NORMAL_MAP0
		float4 tangToWorld0 	: TEXCOORD2; //worldEye.x in .w
		float4 tangToWorld1 	: TEXCOORD3; //worldEye.y in .w
		float4 tangToWorld2 	: TEXCOORD4; //worldEye.z in .w
	#else
		float3 worldNormal  : TEXCOORD2; 
		float3 worldEye		: TEXCOORD3;
	#endif 	
};
	
void computeTangentSpace( float3x3 worldInv, float3 tangent, float3 binormal, float3 normal, inout float4 tangentToWorldSpaceRow0, inout float4 tangentToWorldSpaceRow1, inout float4 tangentToWorldSpaceRow2 )
{
	float bumpHeight = 1.0f;
	float3x3 objToTangentSpaceInv;
	objToTangentSpaceInv[0] = tangent * bumpHeight;
	objToTangentSpaceInv[1] = binormal * bumpHeight;
	objToTangentSpaceInv[2] = normal;
 
	tangentToWorldSpaceRow0.x = dot(objToTangentSpaceInv[0].xyz, worldInv[0]);
	tangentToWorldSpaceRow0.y = dot(objToTangentSpaceInv[1].xyz, worldInv[0]);
	tangentToWorldSpaceRow0.z = dot(objToTangentSpaceInv[2].xyz, worldInv[0]);
	tangentToWorldSpaceRow1.x = dot(objToTangentSpaceInv[0].xyz, worldInv[1]);
	tangentToWorldSpaceRow1.y = dot(objToTangentSpaceInv[1].xyz, worldInv[1]);
	tangentToWorldSpaceRow1.z = dot(objToTangentSpaceInv[2].xyz, worldInv[1]);
	tangentToWorldSpaceRow2.x = dot(objToTangentSpaceInv[0].xyz, worldInv[2]);
	tangentToWorldSpaceRow2.y = dot(objToTangentSpaceInv[1].xyz, worldInv[2]);
	tangentToWorldSpaceRow2.z = dot(objToTangentSpaceInv[2].xyz, worldInv[2]);  
}

vertexOutputUber UberVS( vertexInputUber In )
{
	vertexOutputUber Out;

#ifdef HKG_INSTANCING
	float3x4 world;
   	world[0] = In.transformRow0;
   	world[1] = In.transformRow1;
   	world[2] = In.transformRow2;
   	//world[3] = In.transformRow3;
   	float3 worldVertPos = mul(world , float4(In.position.xyz, 1) ).xyz;
	float4 viewPos = mul( float4(worldVertPos, 1.0), g_mView);
	
	float3 eyeVec = g_mViewInv[3].xyz - worldVertPos.xyz; // world space eye vector
	eyeVec = normalize(eyeVec);
	
	#ifdef HKG_NORMAL_MAP0
		Out.tangToWorld0.w = eyeVec.x;
		Out.tangToWorld1.w = eyeVec.y;
		Out.tangToWorld2.w = eyeVec.z;
		computeTangentSpace( (float3x3)world, In.tangent, In.binormal, In.normal, Out.tangToWorld0, Out.tangToWorld1, Out.tangToWorld2);
	#else 
		Out.worldEye = eyeVec;
		Out.worldNormal = mul( (float3x3)world , In.normal ).xyz;
	#endif
#else
	
	float3 position = In.position.xyz;
    float3 normal = In.normal;

#ifdef HKG_SKINNING   
    float4 blendWeightsArray = In.blendWeights;    
	#if defined(HKG_DX10)
		int4  indexArray = (int4)In.blendIndices;    
	#else
		int4  indexArray = D3DCOLORtoUBYTE4(In.blendIndices);
	#endif
    skinPositionNormal( In.position.xyz, In.normal.xyz, blendWeightsArray, indexArray, position, normal );     
#endif 


	float3 worldVertPos = mul(float4(position , 1.0), g_mWorld).xyz;
	float4 viewPos = mul( float4(position, 1.0), g_mWorldView);
	float3 eyeVec = g_mViewInv[3].xyz - worldVertPos.xyz; // world space eye vector
	
	eyeVec = normalize(eyeVec);
	#ifdef HKG_NORMAL_MAP0
		Out.tangToWorld0.w = eyeVec.x;
		Out.tangToWorld1.w = eyeVec.y;
		Out.tangToWorld2.w = eyeVec.z;
		computeTangentSpace( (float3x3) g_mWorldInv, In.tangent, In.binormal, normal, Out.tangToWorld0, Out.tangToWorld1, Out.tangToWorld2);
	#else
		Out.worldEye = eyeVec;
		Out.worldNormal = mul( In.normal.xyz, (float3x3)g_mWorld).xyz;
	#endif
	
#endif

	Out.texCoord01.xy = In.texCoord0;
#ifdef TWO_TCOORDS
	Out.texCoord01.zw = In.texCoord1;
#else
	Out.texCoord01.zw = 0;
#endif

	Out.position = mul( viewPos, g_mProj);	
	Out.posView = viewPos.xyz;

	return Out;
}

float ComputeSpecular(float3 l, float3 n, float3 e, float specularPower)
{
	float NdotL = dot(n, l); 
	float3 NE = normalize( e );
	float3 H = normalize( NE + l );
	float NdotH = dot( n, H );
	NdotH = max(NdotH, 0.0);
	float specular = pow(NdotH, specularPower);
	return specular;
}

// Pixel Shader
pixelOutput UberPS( vertexOutputUber In )
{
 	HKG_TEST_DEPTH_PEEL

	
	#ifdef HKG_SHADOWS
		float lightAmount = getLightAmountShadow( In.posView );
	#else
		float lightAmount = 1;
	#endif
		
#ifdef HKG_DIFFUSE_MAP0 
	float4 ColorMap = _sampleDiffuse( HKG_DIFFUSE_MAP0_TC );
#else
	float4 ColorMap = float4(1,1,1,1);
#endif
		
#ifdef HKG_DIFFUSE_MAP1 
	ColorMap *= _sampleDiffuse( HKG_DIFFUSE_MAP1_TC );
#endif

#ifdef HKG_NORMAL_MAP0 
	float3 N = _sampleNormal(HKG_NORMAL_MAP0_TC).xyz*2.0 - 1.0;
	float3 worldEyeVec = float3( -In.tangToWorld0.w, -In.tangToWorld1.w, -In.tangToWorld2.w ); 
	float3 worldNormal = float3( dot(In.tangToWorld0.xyz, N), dot(In.tangToWorld1.xyz, N), dot(In.tangToWorld2.xyz, N) );
#else
	float3 worldEyeVec = In.worldEye;
	float3 worldNormal = In.worldNormal;
#endif
	
#ifdef HKG_SPECULAR_MAP0 
	float3 S = _sampleSpecular(HKG_SPECULAR_MAP0_TC).rgb;
		
#else
	float3 S = float3(1,1,1);
#endif


#ifdef HKG_EMIT_MAP0 
	float3 EmitMap = _sampleEmit(HKG_EMIT_MAP0_TC).rgb;
	float emitLuminosity = (EmitMap.r*0.33 + EmitMap.g*0.59 + EmitMap.b*0.11);
#else
	float3 EmitMap = float3(0,0,0);
	float emitLuminosity = 0;
#endif
	
	ColorMap *= g_cDiffuseColor;
	clip( ColorMap.a - ALPHA_DISCARD_TOLERANCE );
	
	
	// Assume DIM if using this shader for now at least	
#if defined(HKG_IRRADIANCE_MAPS) || defined(HKG_REFLECTION_MAP0)
	float3x3 rotWorldToEnv = (float3x3)g_mWorldToEnv;
	float3 envNormal = mul( worldNormal, rotWorldToEnv);
	float3 envRefl  = reflect(  mul(-worldEyeVec, rotWorldToEnv), envNormal ); 
#endif
	
#ifdef HKG_IRRADIANCE_MAPS
	float3 diffuseIrradiance = _cubeSampleDIM( envNormal ).rgb;
	float3 specularIrradiance = S * _cubeSampleSIM( envRefl  ).rgb;

	float facingMainLight = max(0, dot(worldNormal, g_vLightDir));
	float3 shadowDiffuseIrradiance = lerp(diffuseIrradiance, _cubeSampleDIM( -envNormal ).rgb, facingMainLight);
	float3 shadowSpecularIrradiance = lerp(specularIrradiance, _cubeSampleSIM( -envRefl ).rgb, facingMainLight);
#else
	//worldNormal = normalize(worldNormal);
	// No specialization for this material and no Irradiance map
	// XX add normal per pixel lighting here, for now mark as error with a bright red look
	float3 diffuseIrradiance = float3(1,0,0);
	float3 shadowDiffuseIrradiance = diffuseIrradiance * 0.5f;
	float3 specularIrradiance = S;
	float3 shadowSpecularIrradiance = 0;
#endif

#ifdef HKG_REFLECTION_MAP0
	float3 ReflectionMap = _cubeSampleReflect(envRefl).rgb * S; 
	ColorMap.rgb = ColorMap.rgb + ( (1-emitLuminosity)*ReflectionMap.rgb); // so that emmisive areas not so shiney  
#endif
	
#ifdef HKG_OPACITY_MAP0
	float Opacity = _sampleOpacity(HKG_OPACITY_MAP0_TC).r; 
	ColorMap.a *= Opacity;
#endif

	pixelOutput Output;
	Output.color.rgb = EmitMap.rgb + (1-lightAmount)*( shadowDiffuseIrradiance + g_cSpecularColor.rgb*shadowSpecularIrradiance )*ColorMap.rgb + lightAmount*( diffuseIrradiance*ColorMap.rgb + g_cSpecularColor.rgb*specularIrradiance );
	Output.color.a = ColorMap.a; // modulate alpha as is, light etc doesn't affect it.

	if ( g_iFogParams.x > 0)
    {
		Output.color = computeFog( In.posView.z, Output.color );
    }	
	
	if (getColorRangeCorrectionEnabled())
	{
		Output.color.rgb *= getExposurePow2();
		Output.color.rgb = pow(Output.color.rgb, getInvGamma() ); 
	}
	
    
    Output.pzDepth.rgb = In.posView.z * g_iDepthParams.x ;
    Output.pzDepth.a = Output.color.a;

    return Output; 
}

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
