/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */

//
// One or Two diffuse maps, along with a normal and specular map, with and without shadows. The most common demo shaders 
// with 'proper' assets. These will currently also allow loading of a gloss map, but will ignore it
//
//:STYLE VertOneLightBumpT5 HK_NULL HK_NULL HK_NULL PixT5Bump LD* T5 DIFFUSE0 DIFFUSE1 NORMAL1 SPECULAR1
//:STYLE VertOneLightBumpT5 HK_NULL HK_NULL HK_NULL PixT5Bump LD* T5 SHADOWMAP DIFFUSE0 DIFFUSE1 NORMAL1 SPECULAR1 DEFINE:SHADOW_LOOKUP

//:STYLE VertOneLightBumpT5 HK_NULL HK_NULL HK_NULL PixT5Bump LD* T5 DIFFUSE0 DIFFUSE1 NORMAL1 SPECULAR1 SKINNED DEFINE:HKG_SKINNING
//:STYLE VertOneLightBumpT5 HK_NULL HK_NULL HK_NULL PixT5Bump LD* T5 SHADOWMAP DIFFUSE0 DIFFUSE1 NORMAL1 SPECULAR1 SKINNED DEFINE:HKG_SKINNING DEFINE:SHADOW_LOOKUP

//:STYLE VertOneLightBumpT5 HK_NULL HK_NULL HK_NULL PixT5Bump LD* T5 DIFFUSE0 DIFFUSE1 NORMAL1 SPECULAR1 INSTANCED DEFINE:HKG_INSTANCING
//:STYLE VertOneLightBumpT5 HK_NULL HK_NULL HK_NULL PixT5Bump LD* T5 SHADOWMAP DIFFUSE0 DIFFUSE1 NORMAL1 SPECULAR1 INSTANCED DEFINE:HKG_INSTANCING DEFINE:SHADOW_LOOKUP

#include "CommonHeader.hlslh"
#include "CommonSampleHeader.hlslh"

// Matrices
float4x4 g_mWorldInv;
float4x4 g_mWorldView;
float4x4 g_mProj	;
float4x4 g_mViewInv	;

	struct vertexInputT5B {
		float4 position  : POSITION; 	
		float3 normal    : NORMAL; 	
		float2 texCoord0 : TEXCOORD0; 	
		float2 texCoord1 : TEXCOORD1; 	
		float2 texCoord2 : TEXCOORD2; 	
		float2 texCoord3 : TEXCOORD3; 	
		float2 texCoord4 : TEXCOORD4; 	
		float3 tangent   : TANGENT; 
		float3 binormal  : BINORMAL;	
	};
	
	struct vertexOutputT5B {
		float4 position    : SV_Position; 
		float3 posView	   : TEXCOORD0;   
		float2 texCoord0     : TEXCOORD1; // mask coords
		float4 texCoord12    : TEXCOORD2;
		float4 texCoord34    : TEXCOORD3;
		float3 toLightDir0TS : TEXCOORD4; 
		float3 toLightDir1TS : TEXCOORD5; 
		float3 eyeDirTS      : TEXCOORD6; 
	};
	
// Vertex Shaders
vertexOutputT5B VertOneLightBumpT5( vertexInputT5B In )
{
	vertexOutputT5B Out;

	float3 position = In.position.xyz;
    float3 normal = In.normal;

	float3 worldVertPos = mul(float4(position, 1.0), g_mWorld).xyz;
	float4 viewPos = mul( float4(position, 1.0), g_mWorldView);
	float3 toLight0 = g_vLightDir.xyz;
	if (lightZeroIsOmniOrSpot())
	{
		toLight0 = normalize(g_vLightPos.xyz - worldVertPos.xyz);
	}
	float3 lightVec = mul( toLight0, (float3x3)g_mWorldInv ); 
	float3 lightVec1 = mul( g_vLight1Dir.xyz, (float3x3)g_mWorldInv );  
	float3 eyeVec = g_mViewInv[3].xyz - worldVertPos.xyz; // world space eye vector
	eyeVec = mul(eyeVec, (float3x3) g_mWorldInv );  // transform back to object space	
	
	// copy texture coordinates
	    
    Out.texCoord0.xy = In.texCoord0.xy;
	Out.texCoord12.xy = In.texCoord1.xy;
	Out.texCoord12.zw = In.texCoord2.xy;
	Out.texCoord34.xy = In.texCoord3.xy;
	Out.texCoord34.zw = In.texCoord4.xy;
	
	// transform position to clip space
	Out.position = mul( viewPos, g_mProj);
   
	// compute the 3x3 tranform from object space to tangent space
	float3x3 objToTangentSpace;
	float bumpHeight = 1.0f;
	objToTangentSpace[0] = In.tangent * bumpHeight;
	objToTangentSpace[1] = In.binormal * bumpHeight;
	objToTangentSpace[2] = normal;
	
    // light vector
	Out.toLightDir0TS = mul( objToTangentSpace, lightVec ).xyz; // transform from object to tangent space
	Out.toLightDir1TS = 0;
	if (g_iNumLights > 1)
	{
		Out.toLightDir1TS = mul( objToTangentSpace, lightVec1 ).xyz; // transform from object to tangent space
	}

	// eye vector
	Out.eyeDirTS = mul( objToTangentSpace, eyeVec );
	Out.posView = viewPos.xyz;

	return Out;
}

// Does both shadow and non shadow compile
pixelOutput PixT5Bump( vertexOutputT5B In )
{
 	HKG_TEST_DEPTH_PEEL


    pixelOutput Output;
    
#ifdef SHADOW_LOOKUP
	float lightAmount = getLightAmountShadow( In.posView );
	float4 mask = _sample4(In.texCoord0.xy);
#else	
    float lightAmount = 1;
	float4 mask = _sample0(In.texCoord0.xy);
#endif
				
	// This ia a little swizzled due to the first assets we have that use it
	// where rgba does not map to ch(1,2,3,4) but to ch(2,3,1,4)..
	float2 uv0 = In.texCoord12.zw; //channel1 (r in mask)
	float2 uv1 = In.texCoord34.xy; //channel2 (g in mask)
	float2 uv2 = In.texCoord12.xy; //channel3 (b in mask)
	float2 uv3 = In.texCoord34.zw; //channel4 (a in mask)
	
	// x0.5 as our actuyal uvs will be half space
	float2 gradUV0x = ddx( uv0 * 0.5);
	float2 gradUV0y = ddy( uv0 * 0.5);
	float2 gradUV1x = ddx( uv1 * 0.5);
	float2 gradUV1y = ddy( uv1 * 0.5);
	float2 gradUV2x = ddx( uv2 * 0.5);
	float2 gradUV2y = ddy( uv2 * 0.5);
	float2 gradUV3x = ddx( uv3 * 0.5);
	float2 gradUV3y = ddy( uv3 * 0.5);	
	    
	float fullTexSize = 1024.0; 
	float fullTexSizeSqrd = fullTexSize * fullTexSize;
	float mipLevelT0 = 0.5 * log2( max(dot(gradUV0x, gradUV0x), dot(gradUV0y, gradUV0y)) * fullTexSizeSqrd );
	float mipLevelT1 = 0.5 * log2( max(dot(gradUV1x, gradUV1x), dot(gradUV1y, gradUV1y)) * fullTexSizeSqrd );
	float mipLevelT2 = 0.5 * log2( max(dot(gradUV2x, gradUV2x), dot(gradUV2y, gradUV2y)) * fullTexSizeSqrd );
	float mipLevelT3 = 0.5 * log2( max(dot(gradUV3x, gradUV3x), dot(gradUV3y, gradUV3y)) * fullTexSizeSqrd );
	    
	float texSize = fullTexSize;
	float uv0texSize = texSize / pow(2, mipLevelT0);
	float uv1texSize = texSize / pow(2, mipLevelT1);
	float uv2texSize = texSize / pow(2, mipLevelT2);
	float uv3texSize = texSize / pow(2, mipLevelT3);
	
	float2 minUV0 = 1.0 / uv0texSize;
	float2 maxUV0 = ( uv0texSize - 1) / uv0texSize;
	float2 minUV1 = 1.0 / uv1texSize;
	float2 maxUV1 = ( uv1texSize - 1) / uv1texSize;
	float2 minUV2 = 1.0 / uv2texSize;
	float2 maxUV2 = ( uv2texSize - 1) / uv2texSize;
	float2 minUV3 = 1.0 / uv3texSize;
	float2 maxUV3 = ( uv3texSize - 1) / uv3texSize;
	
	float2 atlasUV0 = float2( clamp( frac( uv0 ), minUV0, maxUV0 ) * 0.5);
	float2 atlasUV1 = float2( clamp( frac( uv1 ), minUV1, maxUV1 ) * 0.5);
	float2 atlasUV2 = float2( clamp( frac( uv2 ), minUV2, maxUV2 ) * 0.5);
	float2 atlasUV3 = float2( clamp( frac( uv3 ), minUV3, maxUV3 ) * 0.5);

	atlasUV0 += float2(0.5,0.5);
	atlasUV1 += float2(0.5,0  );
	atlasUV2 += float2(0  ,0.5);
		
	float mr = mask.r;
	float mg = mask.g;
	float mb = mask.b;
	float ma = mask.a;
	
#ifdef SHADOW_LOOKUP
	float4 ColorMap 	= mr*_sample5grad(atlasUV0, gradUV0x, gradUV0y)     + mg*_sample5grad(atlasUV1, gradUV1x, gradUV1y)      + mb*_sample5grad(atlasUV2, gradUV2x, gradUV2y)     + ma*_sample5grad(atlasUV3, gradUV3x, gradUV3y);
	float3 N 			= mr*_sample6grad(atlasUV0, gradUV0x, gradUV0y).xyz	+ mg*_sample6grad(atlasUV1, gradUV1x, gradUV1y).xyz	 + mb*_sample6grad(atlasUV2, gradUV2x, gradUV2y).xyz + ma*_sample6grad(atlasUV3, gradUV3x, gradUV3y).xyz;
	#if !defined(HKG_DEPTH_PEEL)
	float3 SpecMap		= mr*_sample7grad(atlasUV0, gradUV0x, gradUV0y).xyz	+ mg*_sample7grad(atlasUV1, gradUV1x, gradUV1y).xyz	 + mb*_sample7grad(atlasUV2, gradUV2x, gradUV2y).xyz + ma*_sample7grad(atlasUV3, gradUV3x, gradUV3y).xyz;
	#else
	float3 SpecMap		= float3(1,1,1);
	#endif
#else
	float4 ColorMap 	= mr*_sample1grad(atlasUV0, gradUV0x, gradUV0y)     + mg*_sample1grad(atlasUV1, gradUV1x, gradUV1y)      + mb*_sample1grad(atlasUV2, gradUV2x, gradUV2y)     + ma*_sample1grad(atlasUV3, gradUV3x, gradUV3y);
	float3 N 			= mr*_sample2grad(atlasUV0, gradUV0x, gradUV0y).xyz	+ mg*_sample2grad(atlasUV1, gradUV1x, gradUV1y).xyz	 + mb*_sample2grad(atlasUV2, gradUV2x, gradUV2y).xyz + ma*_sample2grad(atlasUV3, gradUV3x, gradUV3y).xyz;
	float3 SpecMap		= mr*_sample3grad(atlasUV0, gradUV0x, gradUV0y).xyz	+ mg*_sample3grad(atlasUV1, gradUV1x, gradUV1y).xyz	 + mb*_sample3grad(atlasUV2, gradUV2x, gradUV2y).xyz + ma*_sample3grad(atlasUV3, gradUV3x, gradUV3y).xyz;
#endif

	
	ColorMap *= g_cDiffuseColor;
	ColorMap /= (mr+mg+mb+ma);
	
	clip( ColorMap.a - ALPHA_DISCARD_TOLERANCE );

	SpecMap *= g_cSpecularColor.rgb; 
	SpecMap /= (mr+mg+mb+ma);
	
	N = N*2.0 - 1.0;
	N = normalize(N);
		
	float4 light0 = 1;
	float3 light1 = 0;
	LightPixel( In.posView, N, In.toLightDir0TS, In.toLightDir1TS, In.eyeDirTS, light0, light1);
	
	float3 totalLight = light0.rgb + light1.rgb + g_cAmbientColor.rgb;
	saturate(totalLight);
	Output.color.rgb = (1-lightAmount)*(light1.rgb+g_cAmbientColor.rgb)*ColorMap.rgb + lightAmount*( totalLight*ColorMap.rgb + light0.www*SpecMap );
	Output.color.a = ColorMap.a; // modulate alpha as is, shadow doesn't affect it.
	
    if ( g_iFogParams.x > 0)
    {
		Output.color = computeFog( In.posView.z, Output.color );
    }
    
    Output.pzDepth.rgb = In.posView.z * g_iDepthParams.x ;
    Output.pzDepth.a = Output.color.a;

    return Output;
}

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
