/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */
// Used directly by light Hair renders, not a generic shaderlib style

#include "CommonHeader.hlslh"
#include "CommonVertexShaders.hlslh"

// #ifdef __PSSL__
// #	define HAIR_WITH_SHADOWS	1
// #endif
//
// Kajiya-Kay anisotropic strand model (Rendering Fur with 3D textures, Siggraph 1989)
// Instead on dot(N,H)^spec iit uses(sin(T,H)^spec = sqrt(1 - dot(T,H)^2)^spec 
// Marcscher Model for Secondary highlihghts is the shift below (Light Scattering from Hair Fibers, Siggraph 2003)
// ( uses Kajiya-Kay for main spec, and a very cut down Marcscher for the dual specular )
// ATI, GDC2004 Hair Rendering and Shading (for the Ruby demo) is main source of all of the above, availble from the AMD dev site (Scheuermann)
// NV 'Nalu' demo impls Marcscher using more accurately using auto computed lookup tables
//

float g_primaryHairShift;
float g_secondaryHairShift;
float g_shiftTexScale;

float g_diffuseScale;
float g_specularScale;
float g_envScale;

float4 g_primarySpecularColor; // exp in .w
float4 g_secondarySpecularColor; // exp in .w

float3 shiftTangent( float3 T, float3 N, float shift )
{
	float3 shifted = T + shift*N;
	return normalize(shifted);
}

float kajiyaKayStrandSpec( float3 T, float3 V, float3 L, float exponent )
{
	float3 H = normalize(L + V);
	float dotTH = dot(T,H);
	float sinTH = sqrt(1.0 - dotTH*dotTH);
	float dirAtten = smoothstep(-1.0, 0.0, dotTH);
	return dirAtten * pow(sinTH, exponent);
}

float3 hairSpecularLighting( float3 T, float3 N, float3 lightVec, float3 viewVec, float shiftSample)
{
	float shiftTex = shiftSample - 0.5f; // This is the normal specular level texture for now XXX add a spec shift texture instead
	float3 t1 = shiftTangent( T, N, g_primaryHairShift + shiftTex * g_shiftTexScale);
	float3 t2 = shiftTangent( T, N, g_secondaryHairShift + shiftTex * g_shiftTexScale);
	
	float3 specular = g_primarySpecularColor.rgb *  kajiyaKayStrandSpec(t1, viewVec, lightVec, g_primarySpecularColor.w );
	
	// XX add a sparkels (stranded noise) texture
	float specMask = 1; //_sample4(In.texCoord0).rgb

	// Marcscher secondary highlight
	specular += g_secondarySpecularColor.rgb * specMask * kajiyaKayStrandSpec(t2, viewVec, lightVec, g_secondarySpecularColor.w );
	
	return specular;
}

pixelOutput hairPS( vertexOutputT1B In )
{
 	HKG_TEST_DEPTH_PEEL

    pixelOutput Output;
    
    #ifdef HAIR_WITH_SHADOWS
		float lightAmount = 1.0; // hair does not self shadow (or get any shadows..) //getLightAmountShadow( In.posView );
	    float4 ColorMap = _sample4(In.texCoord0);
		float3 N = _sample5(In.texCoord0).xyz*2.0 - 1.0;
		float3 SpecMap = _sample6(In.texCoord0).rgb;
	#else
		float lightAmount = 1.0;
	    float4 ColorMap = _sample0(In.texCoord0);
		float3 N = _sample1(In.texCoord0).xyz*2.0 - 1.0;
		float3 SpecMap = _sample2(In.texCoord0).rgb;
	#endif

	ColorMap *= g_cDiffuseColor;
	clip( ColorMap.a - 0.15f ); // quite high clip to avoid issues with 
	
	float3 T = float3(0,1,0); // Tangent along hair in _tanget space_ is Y
	float3 eDir = normalize(In.eyeDirTS);
	float3 lDir = normalize(In.toLightDir0TS);
	float3 nDir = normalize(N);
	float3 hairSpecular = hairSpecularLighting( T, nDir, lDir, eDir, SpecMap.r );
	
	//Add a little from back light too
	float3 backLightDir = normalize(In.toLightDir1TS);
	hairSpecular += hairSpecularLighting( T, nDir, backLightDir, eDir, SpecMap.r )*0.5f;
	
	
	float4 light0 = 1;
	float3 light1 = 0;
	//XX LightPixel here does to much as calcs spec that is not used etc. Replace with similer ver
	//XX Calculate hairSpecular from second light too (would look great)
	LightPixel( In.posView, N, In.toLightDir0TS, In.toLightDir1TS, In.eyeDirTS, light0, light1);
	
	float3 totalLight = light0.rgb + light1.rgb  + g_cAmbientColor.rgb;
	saturate(totalLight);
	float3 totalSpec = g_specularScale*hairSpecular;
	float3 totalDiffuse = g_diffuseScale*ColorMap.rgb; 
	Output.color.rgb = (1-lightAmount)*( (light1.rgb+g_cAmbientColor.rgb)*totalDiffuse + (0.3*totalSpec)) + lightAmount*( totalDiffuse*totalLight + totalSpec );
	Output.color.a = ColorMap.a; // modulate alpha as is, shadow doesn't affect it.
	
	if ( g_iFogParams.x > 0)
    {
		Output.color = computeFog( In.posView.z, Output.color );
    }

    Output.pzDepth.rgb = In.posView.z; // always output depth   (was * g_iDepthParams.x);
    Output.pzDepth.a = Output.color.a;

    return Output;
}

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
