/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */
// Used directly by light Hair renders, not a generic shaderlib style

//:STYLE VertBump HK_NULL HK_NULL HK_NULL hairPS LD* T1 DIFFUSE0 NORMAL0 SPECULAR0

//
// Kajiya-Kay anisotropic strand model (Rendering Fur with 3D textures, Siggraph 1989)
// Instead on dot(N,H)^spec iit uses(sin(T,H)^spec = sqrt(1 - dot(T,H)^2)^spec 
// Marcscher Model for Secondary highlihghts is the shift below (Light Scattering from Hair Fibers, Siggraph 2003)
// ( uses Kajiya-Kay for main spec, and a very cut down Marcscher for the dual specular )
// ATI, GDC2004 Hair Rendering and Shading (for the Ruby demo) is main source of all of the above, availble from the AMD dev site (Scheuermann)
// NV 'Nalu' demo impls Marcscher using more accurately using auto computed lookup tables
//
#ifdef HKG_OGLES2
#	define LOWP lowp
#	define MEDIUMP mediump
#	define HIGHP highp
precision mediump int;
precision highp float;

#else
#	define LOWP 
#	define MEDIUMP 
#	define HIGHP 
#endif


#define ALPHA_DISCARD_TOLERANCE 1.0/255

uniform HIGHP float g_primaryHairShift;
uniform HIGHP float g_secondaryHairShift;
uniform HIGHP float g_shiftTexScale;

uniform HIGHP vec4 g_diffuseScale;
uniform HIGHP vec4 g_specularScale;
uniform HIGHP vec4 g_envScale;

uniform HIGHP vec4 g_primarySpecularColor; // exp in .w
uniform HIGHP vec4 g_secondarySpecularColor; // exp in .w

// Textures, set assignment so that the behaviour is the same no mater what shader is using it 
uniform sampler2D g_sSamplerZero; 
uniform sampler2D g_sSamplerOne;  
uniform sampler2D g_sSamplerTwo;  

uniform HIGHP mat4 g_mWorld;
uniform HIGHP mat4 g_mWorldInv;
uniform HIGHP mat4 g_mWorldView;
uniform HIGHP mat4 g_mProj;	
uniform HIGHP mat4 g_mViewInv;	

uniform LOWP vec3 g_cLightColor;
uniform HIGHP vec3 g_vLightDir;

// Material
uniform LOWP vec3 g_cAmbientColor;
uniform LOWP vec4 g_cDiffuseColor;
uniform LOWP vec3 g_cSpecularColor;
uniform MEDIUMP float  g_cSpecularPower;

#ifdef ENTRYPOINT_VertBump
attribute HIGHP vec4 InPosition;  
attribute HIGHP vec2 InTexCoord0;
attribute HIGHP vec3 InNormal;
attribute HIGHP vec3 InTangent;
attribute HIGHP vec3 InBinormal;
varying HIGHP vec2 VOutTexCoord0;
varying HIGHP vec3 VOutTexCoord2;
varying HIGHP vec3 VOutTexCoord3;
void main()
{
	vec4 position = vec4(InPosition.xyz,1.0);
    vec3 normal = InNormal;
	
    // copy texture coordinates
    VOutTexCoord0.xy = InTexCoord0.xy;
	
	// transform position to clip space
	vec4 viewPos = g_mWorldView * position;
	gl_Position = g_mProj * viewPos;
	
	mat3 objToTangentSpace;
	
	float bumpHeight = 1.0;
		
	objToTangentSpace[0] = InTangent.xyz * bumpHeight;
	objToTangentSpace[1] = InBinormal.xyz * bumpHeight;
	objToTangentSpace[2] = normal;
	
    vec4 vertexPos = g_mWorld * position; // world space position

	// light vector
	vec3 lightVec =  mat3(g_mWorldInv) * g_vLightDir;  // transform back to object space
	VOutTexCoord2.xyz = lightVec * objToTangentSpace; // transform from object to tangent space
	
	// eye vector
	vec3 eyeVec = g_mViewInv[3].xyz - vertexPos.xyz; // world space eye vector
	eyeVec = mat3(g_mWorldInv) * eyeVec;  // transform back to object space
	eyeVec = normalize(eyeVec);
	
	// half-angle vector
	vec3 H = normalize(lightVec + eyeVec);
	VOutTexCoord3.xyz = H * objToTangentSpace;	// transform to tangent space
}
#endif

vec3 shiftTangent( in vec3 T, in vec3 N, in float shift )
{
	vec3 shifted = T.xyz + shift*N.xyz;
	return normalize(shifted);
}

float kajiyaKayStrandSpec( in vec3 T, in vec3 V, in vec3 L, in float exponent )
{
	vec3 H = normalize(L + V);
	float dotTH = dot(T,H);
	float sinTH = sqrt(1.0 - dotTH*dotTH);
	float dirAtten = smoothstep(-1.0, 0.0, dotTH);
	return dirAtten * pow(sinTH, exponent);
}

vec3 hairSpecularLighting( in vec3 T, in vec3 N, in vec3 lightVec, in vec3 viewVec, in float shiftSample)
{
	float shiftTex = shiftSample - 0.5; // This is the normal specular level texture for now XXX add a spec shift texture instead
	float primaryHairShift = 0.49; //g_primaryHairShift;
	float secondaryHairShift = 1.01;//g_secondaryHairShift;
	float shiftTexScale = -3.64; //g_shiftTexScale;
	vec3 t1 = shiftTangent( T, N, primaryHairShift + shiftTex * shiftTexScale).xyz;
	vec3 t2 = shiftTangent( T, N, secondaryHairShift + shiftTex * shiftTexScale).xyz;
	
	vec4 primarySpecularColor = vec4(0.33,0.33,0.3339, 239.0);//g_primarySpecularColor;
	float kajiyaKayStrandPrimarySpecValue = kajiyaKayStrandSpec(t1, viewVec, lightVec, primarySpecularColor.w );
	vec3 specular = primarySpecularColor.rgb * kajiyaKayStrandPrimarySpecValue;
	
//	// XX add a sparkels (stranded noise) texture
	float specMask = 1.0; //texture2D(g_sSamplerFour, In.texCoord0).rgb;

	// Marcscher secondary highlight
	vec4 secondarySpecularColor = vec4(0.318,0.263,0.202, 136.0);//g_secondarySpecularColor;
	float kajiyaKayStrandSecondarySpecValue = specMask * kajiyaKayStrandSpec(t2, viewVec, lightVec, secondarySpecularColor.w );
	specular = specular.xyz + secondarySpecularColor.rgb*kajiyaKayStrandSecondarySpecValue;
	
	return specular;
}

vec4 Phong(in float NdotL, in float NdotH, in float specularPower) 
{
	float diffuse = max(NdotL, 0.0);
	NdotH = max(NdotH, 0.0);
	float specular = pow(NdotH, specularPower); // * dot(g_cSpecularColor.rgb,g_cSpecularColor.rgb);
	if (NdotL <= 0.0 ) 
	{
		specular = 0.0;
	}
	return vec4(diffuse, diffuse, diffuse, specular);
}

#ifdef ENTRYPOINT_hairPS
varying HIGHP vec2 VOutTexCoord0;
varying HIGHP vec3 VOutTexCoord2;
varying HIGHP vec3 VOutTexCoord3;
void main()
{
 	float lightAmount = 1.0; // hair does not self shadow (or get any shadows..) 
	vec4 ColorMap = vec4(1,1,1,1);
	ColorMap = texture2D(g_sSamplerZero, VOutTexCoord0.xy);

	vec3 N = vec3(0.0,0.0,1.0);
	N = texture2D(g_sSamplerOne, VOutTexCoord0).xyz*2.0 - 1.0;
	
	vec3 SpecMap = g_cSpecularColor.rgb;
	SpecMap = texture2D(g_sSamplerTwo, VOutTexCoord0.xy).rgb;
	
	ColorMap *= g_cDiffuseColor;
	
	//if (ColorMap.a < 1/255.0 )
	//	discard;

	vec3 T = vec3(0.0,1.0,0.0); // Tangent along hair in _tanget space_ is Y
	vec3 lDir = normalize(VOutTexCoord2.xyz);
	vec3 eDir = normalize(VOutTexCoord3.xyz);
	vec3 nDir = normalize(N);
	vec3 hairSpecular = hairSpecularLighting( T, nDir, lDir, eDir, SpecMap.r ).xyz;
	
	float NdotL = dot(nDir, lDir);
	float NdotH = dot(nDir, eDir);
	
	vec4 light0 = lightAmount * Phong(NdotL, NdotH, g_cSpecularPower).xyzw * vec4(g_cLightColor.rgb,1.0);
	vec3 light1 = vec3(0.0, 0.0, 0.0);
	vec3 totalLight = light0.rgb + light1.rgb + g_cAmbientColor.rgb;
	totalLight = clamp(totalLight.xyz,0.0,1.0);
	
	vec3 diffuseScale = vec3(1.24, 1.24, 1.24); // > 1 to account for no ambient light map
	vec3 specularScale = vec3(0.21, 0.21, 0.21);
	vec3 totalSpec = specularScale.xxx*hairSpecular.xyz;
	vec3 totalDiffuse = diffuseScale.xxx*ColorMap.rgb;
	gl_FragColor.rgb = (1.0,-lightAmount)*( (light1.rgb + g_cAmbientColor.rgb)*totalDiffuse.xyz + (0.3*totalSpec.xyz)) + lightAmount*( totalDiffuse*totalLight.xyz + totalSpec.xyz );
	gl_FragColor.a = ColorMap.a; // modulate alpha as is, shadow doesn't affect it.
}
#endif

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
