/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */
// Used directly by light Car renders, not a generic shaderlib style

#define NAME_SAMPLERS

#include "CommonHeader.hlslh"
#include "CommonVertexShaders.hlslh"


struct PSInput 
{
	float4 position     : SV_Position; 
	float3 posView	    : TEXCOORD0; 
	float2 texCoord     : TEXCOORD1;
	float3 normalWorld	: TEXCOORD2; 
	float3 eyeDirWorld	: TEXCOORD3; 
};

 
PSInput glassVS( vertexInputT1 In )
{
	PSInput Out;
	float3 worldVertPos = mul(float4(In.position.xyz , 1.0), g_mWorld).xyz;
	float4 viewPos = mul( float4(In.position.xyz, 1.0), g_mWorldView);
	float3 eyeVec = g_mViewInv[3].xyz - worldVertPos.xyz; // world space eye vector
	
	Out.position = mul( viewPos, g_mProj);	    
	Out.posView = viewPos.xyz;
	Out.texCoord.xy = In.texCoord0;

	float3x3 w = (float3x3)g_mWorld;
	Out.normalWorld = mul( In.normal.xyz, w );
	Out.eyeDirWorld = normalize(eyeVec);

	return Out;
}



pixelOutput glassPS( PSInput In )
{
 	HKG_TEST_DEPTH_PEEL
    pixelOutput Output;

	float lightAmount = getLightAmountShadow( In.posView );
	float4 ColorMap = _sampleDiffuse(In.texCoord.xy );
	float3 SpecMap = _sampleSpecular(In.texCoord.xy ).rgb * g_cSpecularColor.rgb;

	float3 vView = normalize( In.eyeDirWorld ); 
	float3 vNormalWorld = normalize( In.normalWorld ); 

	float fNdotV = saturate(dot( vNormalWorld, vView)); 
	float3 vReflection = 2 * vNormalWorld * fNdotV - vView; 

	float3x3 rotWorldToEnv = (float3x3)g_mWorldToEnv;
	float3 envReflection  = mul( vReflection, rotWorldToEnv);
	float3 envNormal  = mul( vNormalWorld, rotWorldToEnv);

	float3 envMap = _cubeSampleReflect(envReflection).rgb ;
	float3 diffuseIrradiance = _cubeSampleDIM(envNormal).rgb;
	float3 specIrradiance = _cubeSampleSIM(envReflection).rgb;
	
	// Combine result of environment map reflection: 
	float fEnvContribution = 1.0 - 0.5 * fNdotV; 

	Output.color.a = ColorMap.a; 
	Output.color.rgb = diffuseIrradiance*ColorMap.rgb + fEnvContribution*envMap + specIrradiance*SpecMap.r; 
	
	if ( g_iFogParams.x > 0)
    {
		Output.color = computeFog( In.posView.z, Output.color );
	}

	if (getColorRangeCorrectionEnabled())
	{
		Output.color.rgb *= getExposurePow2();
		Output.color.rgb = pow(Output.color.rgb, getInvGamma() ); 
	}
	
	
	Output.pzDepth.rgb = In.posView.z; // always output depth   (was * g_iDepthParams.x);
	Output.pzDepth.a = Output.color.a;

	return Output;
}

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
