/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */

//
// One diffuse map, with and without shadows. Unlit.
//:STYLE VertUnlit HK_NULL HK_NULL HK_NULL PixT1 LD0 T1 DIFFUSE0
//:STYLE VertUnlit HK_NULL HK_NULL HK_NULL PixShadowSceneT1 LD0 T1 SHADOWMAP DIFFUSE0

//:STYLE VertUnlit HK_NULL HK_NULL HK_NULL PixT1 LD0 T1 DIFFUSE0 SKINNED DEFINE:HKG_SKINNING
//:STYLE VertUnlit HK_NULL HK_NULL HK_NULL PixShadowSceneT1 LD0 T1 SHADOWMAP DIFFUSE0 SKINNED DEFINE:HKG_SKINNING

//:STYLE VertUnlit HK_NULL HK_NULL HK_NULL PixT1 LD0 T1 DIFFUSE0 INSTANCED DEFINE:HKG_INSTANCING
//:STYLE VertUnlit HK_NULL HK_NULL HK_NULL PixShadowSceneT1 LD0 T1 SHADOWMAP DIFFUSE0 INSTANCED DEFINE:HKG_INSTANCING

//:STYLE VertUnlit HK_NULL HK_NULL HK_NULL PixT1 LD* T1 EMISSIVE0 DEFINE:EMIT_ONLY
//:STYLE VertUnlit HK_NULL HK_NULL HK_NULL PixShadowSceneT1 LD* T1 SHADOWMAP EMISSIVE0 DEFINE:EMIT_ONLY

//:STYLE VertUnlit HK_NULL HK_NULL HK_NULL PixT1 LD* T1 EMISSIVE0 SKINNED DEFINE:HKG_SKINNING DEFINE:EMIT_ONLY
//:STYLE VertUnlit HK_NULL HK_NULL HK_NULL PixShadowSceneT1 LD* T1 SHADOWMAP EMISSIVE0 SKINNED DEFINE:HKG_SKINNING DEFINE:EMIT_ONLY

//:STYLE VertUnlit HK_NULL HK_NULL HK_NULL PixT1 LD* T1 EMISSIVE0 INSTANCED DEFINE:HKG_INSTANCING DEFINE:EMIT_ONLY
//:STYLE VertUnlit HK_NULL HK_NULL HK_NULL PixShadowSceneT1 LD* T1 SHADOWMAP EMISSIVE0 INSTANCED DEFINE:HKG_INSTANCING DEFINE:EMIT_ONLY


#include "CommonHeader.hlslh"
#include "CommonVertexShaders.hlslh"


pixelOutput PixShadowSceneT1( vertexOutputUnlitT1 In )
{
   	HKG_TEST_DEPTH_PEEL

	pixelOutput Output;

#ifndef EMIT_ONLY
    float lightAmount = getLightAmountShadow( In.posView );
#else
	float lightAmount = 1;
#endif
	
    float4 texel = _sample4(In.texCoord0 );
    Output.color.rgb = texel.rgb * lightAmount.rrr; // modulate rgb wrt shadow.
    Output.color.a = texel.a; // set alpha as is, shadow doesn't affect it.
	clip( texel.a - ALPHA_DISCARD_TOLERANCE );

	if ( g_iFogParams.x > 0)
    {
		Output.color = computeFog( In.posView.z, Output.color );
    }
    
	Output.pzDepth.rgb = In.posView.z * g_iDepthParams.x;
	Output.pzDepth.a = Output.color.a;
	
	return Output;
}


pixelOutput PixT1( vertexOutputUnlitT1 In ) 
{ 
   	HKG_TEST_DEPTH_PEEL

	pixelOutput Output;
    Output.color = _sample0(In.texCoord0); 
	clip( Output.color.a - ALPHA_DISCARD_TOLERANCE );

	if ( g_iFogParams.x > 0)
    {
		Output.color = computeFog( In.posView.z, Output.color );
    }
    	
    Output.pzDepth.rgb = In.posView.z * g_iDepthParams.x;
	Output.pzDepth.a = Output.color.a;

    return Output;
}

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
