/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */

//XXX need a mobile define ghere to do per vert on phones etc

//:STYLE VertNoBumpPP HK_NULL HK_NULL HK_NULL PixT1 LD* T1 DIFFUSE0 OPACITY0 DEFINE:TEX_COORD0 
//:STYLE VertNoBumpPP HK_NULL HK_NULL HK_NULL PixShadowSceneT1 LD* T1 SHADOWMAP DIFFUSE0 OPACITY0 DEFINE:TEX_COORD0 
//:STYLE VertNoBumpPP HK_NULL HK_NULL HK_NULL PixT1 LD* T1 DIFFUSE0 OPACITY0 INSTANCED DEFINE:HKG_INSTANCING DEFINE:TEX_COORD0 
//:STYLE VertNoBumpPP HK_NULL HK_NULL HK_NULL PixShadowSceneT1 LD* T1 SHADOWMAP DIFFUSE0 OPACITY0 INSTANCED DEFINE:HKG_INSTANCING DEFINE:TEX_COORD0 

//:STYLE VertNoBumpPP HK_NULL HK_NULL HK_NULL PixT1 LD* T1 OPACITY0 DEFINE:TEX_COORD0 
//:STYLE VertNoBumpPP HK_NULL HK_NULL HK_NULL PixShadowSceneT1 LD* T1 SHADOWMAP OPACITY0 DEFINE:TEX_COORD0 
//:STYLE VertNoBumpPP HK_NULL HK_NULL HK_NULL PixT1 LD* T1 OPACITY0 INSTANCED DEFINE:HKG_INSTANCING DEFINE:TEX_COORD0 
//:STYLE VertNoBumpPP HK_NULL HK_NULL HK_NULL PixShadowSceneT1 LD* T1 SHADOWMAP OPACITY0 INSTANCED DEFINE:HKG_INSTANCING DEFINE:TEX_COORD0 


//:STYLE VertNoBumpPP HK_NULL HK_NULL HK_NULL PixT2 LD* T2 DIFFUSE0 OPACITY1 DEFINE:TEX_COORD0 DEFINE:TEX_COORD1 DEFINE:HAVE_OPACITY1 
//:STYLE VertNoBumpPP HK_NULL HK_NULL HK_NULL PixShadowSceneT2 LD* T2 SHADOWMAP DIFFUSE0 OPACITY1 DEFINE:TEX_COORD0 DEFINE:TEX_COORD1 DEFINE:HAVE_OPACITY1 
//:STYLE VertNoBumpPP HK_NULL HK_NULL HK_NULL PixT2 LD* T2 DIFFUSE0 OPACITY1 INSTANCED DEFINE:HKG_INSTANCING DEFINE:TEX_COORD0 DEFINE:TEX_COORD1 DEFINE:HAVE_OPACITY1 
//:STYLE VertNoBumpPP HK_NULL HK_NULL HK_NULL PixShadowSceneT2 LD* T2 SHADOWMAP DIFFUSE0 OPACITY1 INSTANCED DEFINE:HKG_INSTANCING DEFINE:TEX_COORD0 DEFINE:TEX_COORD1 DEFINE:HAVE_OPACITY1 

// [None, one or two] diffuse maps, no normal map, with and without shadows. Vertex lit
//:STYLE VertNoBumpPP HK_NULL HK_NULL HK_NULL PixT0 LD* T0 
//:STYLE VertNoBumpPP HK_NULL HK_NULL HK_NULL PixShadowSceneT0 LD* T0 SHADOWMAP 
//:STYLE VertNoBumpPP HK_NULL HK_NULL HK_NULL PixT1 LD* T1 DIFFUSE0 DEFINE:TEX_COORD0 
//:STYLE VertNoBumpPP HK_NULL HK_NULL HK_NULL PixShadowSceneT1 LD* T1 SHADOWMAP DIFFUSE0 DEFINE:TEX_COORD0
//:STYLE VertNoBumpPP HK_NULL HK_NULL HK_NULL PixT1 LD* T1 DIFFUSE0 SPECULAR0 DEFINE:USE_SPEC DEFINE:TEX_COORD0 
//:STYLE VertNoBumpPP HK_NULL HK_NULL HK_NULL PixShadowSceneT1 LD* T1 SHADOWMAP DIFFUSE0 SPECULAR0 DEFINE:USE_SPEC DEFINE:TEX_COORD0 
//:STYLE VertNoBumpPP HK_NULL HK_NULL HK_NULL PixT2 LD* T2 DIFFUSE0 DIFFUSE1 1L DEFINE:TEX_COORD0 DEFINE:TEX_COORD1
//:STYLE VertNoBumpPP HK_NULL HK_NULL HK_NULL PixShadowSceneT2 LD* T2 SHADOWMAP DIFFUSE0 DIFFUSE1 DEFINE:TEX_COORD0 DEFINE:TEX_COORD1

//:STYLE VertNoBumpPP HK_NULL HK_NULL HK_NULL PixT1 LD* T1 DIFFUSE0 OPACITY0 SKINNED DEFINE:HKG_SKINNING DEFINE:TEX_COORD0 
//:STYLE VertNoBumpPP HK_NULL HK_NULL HK_NULL PixShadowSceneT1 LD* T1 SHADOWMAP DIFFUSE0 OPACITY0 SKINNED DEFINE:HKG_SKINNING DEFINE:TEX_COORD0 
//:STYLE VertNoBumpPP HK_NULL HK_NULL HK_NULL PixT1 LD* T1 DIFFUSE0 OPACITY0 SKINNED DEFINE:HKG_SKINNING DEFINE:TEX_COORD0 
//:STYLE VertNoBumpPP HK_NULL HK_NULL HK_NULL PixShadowSceneT1 LD* T1 SHADOWMAP DIFFUSE0 OPACITY0 SKINNED DEFINE:HKG_SKINNING DEFINE:TEX_COORD0 

//:STYLE VertNoBumpPP HK_NULL HK_NULL HK_NULL PixDecalT2 LD* T2 DIFFUSE0 DIFFUSE0 DIFFUSE1 SKINNED DEFINE:HKG_SKINNING DEFINE:TEX_COORD0 DEFINE:TEX_COORD1
//:STYLE VertNoBumpPP HK_NULL HK_NULL HK_NULL PixShadowDecalT2 LD* T2 SHADOWMAP DIFFUSE0 DIFFUSE0 DIFFUSE1 SKINNED DEFINE:HKG_SKINNING DEFINE:TEX_COORD0 DEFINE:TEX_COORD1
//:STYLE VertNoBumpPP HK_NULL HK_NULL HK_NULL PixDecorT2 LD* T2 DIFFUSE0 OPACITY1 SKINNED DEFINE:HKG_SKINNING DEFINE:TEX_COORD0 DEFINE:TEX_COORD1
//:STYLE VertNoBumpPP HK_NULL HK_NULL HK_NULL PixShadowDecorT2 LD* T2 SHADOWMAP DIFFUSE0 OPACITY1 SKINNED DEFINE:HKG_SKINNING DEFINE:TEX_COORD0 DEFINE:TEX_COORD1
// [None, one or two] diffuse maps, no normal map, with and without shadows. Vertex lit
//:STYLE VertNoBumpPP HK_NULL HK_NULL HK_NULL PixT0 LD* T0 SKINNED DEFINE:HKG_SKINNING
//:STYLE VertNoBumpPP HK_NULL HK_NULL HK_NULL PixShadowSceneT0 LD* T0 SHADOWMAP SKINNED DEFINE:HKG_SKINNING
//:STYLE VertNoBumpPP HK_NULL HK_NULL HK_NULL PixT1 LD* T1 DIFFUSE0 SKINNED DEFINE:HKG_SKINNING DEFINE:TEX_COORD0
//:STYLE VertNoBumpPP HK_NULL HK_NULL HK_NULL PixShadowSceneT1 LD* T1 SHADOWMAP DIFFUSE0 SKINNED DEFINE:HKG_SKINNING DEFINE:TEX_COORD0
//:STYLE VertNoBumpPP HK_NULL HK_NULL HK_NULL PixT1 LD* T1 DIFFUSE0 SPECULAR0 DEFINE:USE_SPEC  SKINNED DEFINE:HKG_SKINNING DEFINE:TEX_COORD0
//:STYLE VertNoBumpPP HK_NULL HK_NULL HK_NULL PixShadowSceneT1 LD* T1 SHADOWMAP DIFFUSE0 SPECULAR0 DEFINE:USE_SPEC  SKINNED DEFINE:HKG_SKINNING DEFINE:TEX_COORD0
//:STYLE VertNoBumpPP HK_NULL HK_NULL HK_NULL PixT2 LD* T2 DIFFUSE0 DIFFUSE1 1L SKINNED DEFINE:HKG_SKINNING DEFINE:TEX_COORD0 DEFINE:TEX_COORD1
//:STYLE VertNoBumpPP HK_NULL HK_NULL HK_NULL PixShadowSceneT2 LD* T2 SHADOWMAP DIFFUSE0 DIFFUSE1 SKINNED DEFINE:HKG_SKINNING DEFINE:TEX_COORD0 DEFINE:TEX_COORD1


//:STYLE VertNoBumpPP HK_NULL HK_NULL HK_NULL PixDecalT2 LD* T2 DIFFUSE0 DIFFUSE0 DIFFUSE1 INSTANCED DEFINE:HKG_INSTANCING DEFINE:TEX_COORD0 DEFINE:TEX_COORD1
//:STYLE VertNoBumpPP HK_NULL HK_NULL HK_NULL PixShadowDecalT2 LD* T2 SHADOWMAP DIFFUSE0 DIFFUSE0 DIFFUSE1 INSTANCED DEFINE:HKG_INSTANCING DEFINE:TEX_COORD0 DEFINE:TEX_COORD1
//:STYLE VertNoBumpPP HK_NULL HK_NULL HK_NULL PixDecorT2 LD* T2 DIFFUSE0 OPACITY1 INSTANCED DEFINE:HKG_INSTANCING DEFINE:TEX_COORD0 DEFINE:TEX_COORD1
//:STYLE VertNoBumpPP HK_NULL HK_NULL HK_NULL PixShadowDecorT2 LD* T2 SHADOWMAP DIFFUSE0 OPACITY1 INSTANCED DEFINE:HKG_INSTANCING DEFINE:TEX_COORD0 DEFINE:TEX_COORD1
// [None, one or two] diffuse maps, no normal map, with and without shadows. Vertex lit
//:STYLE VertNoBumpPP HK_NULL HK_NULL HK_NULL PixT0 LD* T0 INSTANCED DEFINE:HKG_INSTANCING
//:STYLE VertNoBumpPP HK_NULL HK_NULL HK_NULL PixShadowSceneT0 LD* T0 SHADOWMAP INSTANCED DEFINE:HKG_INSTANCING
//:STYLE VertNoBumpPP HK_NULL HK_NULL HK_NULL PixT1 LD* T1 DIFFUSE0 INSTANCED DEFINE:HKG_INSTANCING DEFINE:TEX_COORD0
//:STYLE VertNoBumpPP HK_NULL HK_NULL HK_NULL PixShadowSceneT1 LD* T1 SHADOWMAP DIFFUSE0 INSTANCED DEFINE:HKG_INSTANCING DEFINE:TEX_COORD0
//:STYLE VertNoBumpPP HK_NULL HK_NULL HK_NULL PixT1 LD* T1 DIFFUSE0 SPECULAR0 DEFINE:USE_SPEC  INSTANCED DEFINE:HKG_INSTANCING DEFINE:TEX_COORD0
//:STYLE VertNoBumpPP HK_NULL HK_NULL HK_NULL PixShadowSceneT1 LD* T1 SHADOWMAP DIFFUSE0 SPECULAR0 DEFINE:USE_SPEC  INSTANCED DEFINE:HKG_INSTANCING DEFINE:TEX_COORD0
//:STYLE VertNoBumpPP HK_NULL HK_NULL HK_NULL PixT2 LD* T2 DIFFUSE0 DIFFUSE1 1L INSTANCED DEFINE:HKG_INSTANCING DEFINE:TEX_COORD0 DEFINE:TEX_COORD1
//:STYLE VertNoBumpPP HK_NULL HK_NULL HK_NULL PixShadowSceneT2 LD* T2 SHADOWMAP DIFFUSE0 DIFFUSE1 INSTANCED DEFINE:HKG_INSTANCING DEFINE:TEX_COORD0 DEFINE:TEX_COORD1

 
#pragma include(CommonHeader.glslh)
#pragma include(CommonVertexShaders.glslh)


#ifdef ENTRYPOINT_PixShadowSceneT0

varying HIGHP vec3 VOutNormal;
varying HIGHP vec3 VOutLightDir0OS;
varying HIGHP vec3 VOutLightDir1OS;
varying HIGHP vec3 VOutEyeDirOS;
varying HIGHP vec3 VOutPosView; 

void main()
{
    float lightAmount = getLightAmountShadow( VOutPosView );
	
	vec4 light0 = vec4(1.0,1.0,1.0,1.0);
	vec3 light1 = vec3(0.0,0.0,0.0);
	LightPixel( VOutPosView, normalize(VOutNormal), VOutLightDir0OS, VOutLightDir1OS, VOutEyeDirOS, light0, light1);
	
	vec3 specularLight = light0.www*g_cSpecularColor.rgb;
	float specLuminosity = (specularLight.r*0.33 + specularLight.g*0.59 + specularLight.b*0.11);
	specLuminosity = saturate( specLuminosity * lightAmount);
	
	vec3 totalLight = light0.rgb + light1.rgb  + g_cAmbientColor.rgb;
	gl_FragColor.rgb = (1.0-lightAmount)*(light1.rgb+g_cAmbientColor.rgb)*g_cDiffuseColor.rgb + lightAmount*( totalLight*g_cDiffuseColor.rgb + specularLight );
	gl_FragColor.a = saturate( g_cDiffuseColor.a + specLuminosity ); // a few neweer demos use rhe fact that specular is aditional on alpha channel
	
	COMPUTE_FOG
	

	
}
#endif

#ifdef ENTRYPOINT_PixShadowSceneT1

varying HIGHP vec4 VOutTexCoord0;


varying HIGHP vec3 VOutNormal;
varying HIGHP vec3 VOutLightDir0OS;
varying HIGHP vec3 VOutLightDir1OS;
varying HIGHP vec3 VOutEyeDirOS;
varying HIGHP vec3 VOutPosView; 

void main()
{
    float lightAmount = getLightAmountShadow( VOutPosView );
	
	vec4 texel = texture2D(g_sSamplerFour,VOutTexCoord0.xy );

    vec4 SpecMap = vec4(1.0,1.0,1.0,1.0);
#ifdef USE_SPEC 
    SpecMap =texture2D(g_sSamplerFive,VOutTexCoord0.xy );
#endif

	vec4 light0 = vec4(1.0,1.0,1.0,1.0);
	vec3 light1 = vec3(0.0,0.0,0.0);
	LightPixel( VOutPosView, normalize(VOutNormal), VOutLightDir0OS, VOutLightDir1OS, VOutEyeDirOS, light0, light1);
	
	vec3 specularLight = light0.www*g_cSpecularColor.rgb;
	float specLuminosity = (specularLight.r*0.33 + specularLight.g*0.59 + specularLight.b*0.11);
	specLuminosity = saturate( specLuminosity * lightAmount );
	
	vec3 totalLight = light0.rgb + light1.rgb  + g_cAmbientColor.rgb;
	vec4 colorMap = g_cDiffuseColor * texel;
	gl_FragColor.rgb = (1.0-lightAmount)*(light1.rgb+g_cAmbientColor.rgb)*colorMap.rgb + lightAmount*( totalLight*colorMap.rgb + specularLight );
	gl_FragColor.a = saturate( colorMap.a + specLuminosity); // a few neweer demos use rhe fact that specular is aditional on alpha channel
	
	COMPUTE_FOG
}
#endif


#ifdef ENTRYPOINT_PixShadowSceneT2

varying HIGHP vec4 VOutTexCoord0;


varying HIGHP vec3 VOutNormal;
varying HIGHP vec3 VOutLightDir0OS;
varying HIGHP vec3 VOutLightDir1OS;
varying HIGHP vec3 VOutEyeDirOS;
varying HIGHP vec3 VOutPosView; 

void main()
{
    float lightAmount = getLightAmountShadow( VOutPosView );
	
	vec4 texel0 = texture2D(g_sSamplerFour,VOutTexCoord0.xy );
    #ifdef HAVE_OPACITY1
	float texelAlpha = texture2D(g_sSamplerFive,VOutTexCoord0.zw ).r;
    vec3 texelTotal = texel0.rgb;
	#else
    vec4 texel1 = texture2D(g_sSamplerFive,VOutTexCoord0.zw );
    vec3 texelTotal = (texel0.rgb + (texel1.rgb * 0.6));
    float texelAlpha =  texel0.a * texel1.a;
	#endif
	
	vec4 light0 = vec4(1.0,1.0,1.0,1.0);
	vec3 light1 = vec3(0.0,0.0,0.0);
	LightPixel( VOutPosView, normalize(VOutNormal), VOutLightDir0OS, VOutLightDir1OS, VOutEyeDirOS, light0, light1);
	
	vec3 specularLight = light0.www*g_cSpecularColor.rgb;
	float specLuminosity = (specularLight.r*0.33 + specularLight.g*0.59 + specularLight.b*0.11);
	specLuminosity = saturate( specLuminosity * lightAmount  );
	
	vec3 totalLight = light0.rgb + light1.rgb  + g_cAmbientColor.rgb;
	vec3 colorMap = g_cDiffuseColor.rgb * texelTotal;
	gl_FragColor.rgb = (1.0-lightAmount)*(light1.rgb+g_cAmbientColor.rgb)*colorMap.rgb + lightAmount*( totalLight*colorMap.rgb + specularLight );
	gl_FragColor.a = saturate( texelAlpha*g_cDiffuseColor.a 
	#ifndef HAVE_OPACITY1
	+ specLuminosity
	#endif
	); // a few neweer demos use rhe fact that specular is aditional on alpha channel

	COMPUTE_FOG

}
#endif

#ifdef ENTRYPOINT_PixT0

varying HIGHP vec3 VOutNormal;
varying HIGHP vec3 VOutLightDir0OS;
varying HIGHP vec3 VOutLightDir1OS;
varying HIGHP vec3 VOutEyeDirOS;
varying HIGHP vec3 VOutPosView; 

void main()
{
	vec4 light0 = vec4(1.0,1.0,1.0,1.0);
	vec3 light1 = vec3(0.0,0.0,0.0);
	LightPixel( VOutPosView, normalize(VOutNormal), VOutLightDir0OS, VOutLightDir1OS, VOutEyeDirOS, light0, light1);
	
	vec3 totalLight = light0.rgb + light1.rgb;
	totalLight = saturate(totalLight);
	vec3 negLight = vec3(1.0,1.0,1.0) - totalLight;
	
	vec3 specularLight = light0.www*g_cSpecularColor.rgb;
	float specLuminosity = (specularLight.r*0.33 + specularLight.g*0.59 + specularLight.b*0.11);
	specLuminosity = saturate( specLuminosity);
	
	gl_FragColor.rgb = negLight*g_cAmbientColor.rgb*g_cDiffuseColor.rgb + totalLight*g_cDiffuseColor.rgb + specularLight;
	gl_FragColor.a = saturate( g_cDiffuseColor.a + specLuminosity); // a few neweer demos use rhe fact that specular is aditional on alpha channel
	
	COMPUTE_FOG
}
#endif

#ifdef ENTRYPOINT_PixT1
varying HIGHP vec4 VOutTexCoord0;


varying HIGHP vec3 VOutNormal;
varying HIGHP vec3 VOutLightDir0OS;
varying HIGHP vec3 VOutLightDir1OS;
varying HIGHP vec3 VOutEyeDirOS;
varying HIGHP vec3 VOutPosView; 

void main()
{
    vec4 texel =  texture2D(g_sSamplerZero, VOutTexCoord0.xy); 

    vec4 SpecMap = vec4(1.0,1.0,1.0,1.0);
#ifdef USE_SPEC 
    SpecMap =  texture2D(g_sSamplerOne, VOutTexCoord0.xy);
#endif

	vec4 light0 = vec4(1.0,1.0,1.0,1.0);
	vec3 light1 = vec3(0.0,0.0,0.0);
	LightPixel( VOutPosView, normalize(VOutNormal), VOutLightDir0OS, VOutLightDir1OS, VOutEyeDirOS, light0, light1);
	
	vec3 totalLight = light0.rgb + light1.rgb;
	totalLight = saturate(totalLight);
	vec3 negLight = vec3(1.0,1.0,1.0) - totalLight;
	
	vec3 specularLight = light0.www*g_cSpecularColor.rgb;
	float specLuminosity = (specularLight.r*0.33 + specularLight.g*0.59 + specularLight.b*0.11);
	specLuminosity = saturate( specLuminosity );
	
	vec4 colorMap = g_cDiffuseColor * texel;
	gl_FragColor.rgb = negLight*g_cAmbientColor.rgb*colorMap.rgb + totalLight*colorMap.rgb + specularLight;
	gl_FragColor.a = saturate( colorMap.a + specLuminosity); // a few neweer demos use rhe fact that specular is aditional on alpha channel

	COMPUTE_FOG
		
}
#endif

#ifdef ENTRYPOINT_PixT2
varying HIGHP vec4 VOutTexCoord0;


varying HIGHP vec3 VOutNormal;
varying HIGHP vec3 VOutLightDir0OS;
varying HIGHP vec3 VOutLightDir1OS;
varying HIGHP vec3 VOutEyeDirOS;
varying HIGHP vec3 VOutPosView; 

void main()
{
    vec4 texel0 =  texture2D(g_sSamplerZero, VOutTexCoord0.xy );
	#ifdef HAVE_OPACITY1
    float texelAlpha =  texture2D(g_sSamplerOne, VOutTexCoord0.zw).r;
    vec3 texelTotal = texel0.rgb;
	#else
    vec4 texel1 =  texture2D(g_sSamplerOne, VOutTexCoord0.zw);
    vec3 texelTotal = texel0.rgb + (texel1.rgb * 0.6);
	float texelAlpha = texel0.a * texel1.a;
    #endif
	
	vec4 light0 = vec4(1.0,1.0,1.0,1.0);
	vec3 light1 = vec3(0.0,0.0,0.0);
	LightPixel( VOutPosView, normalize(VOutNormal), VOutLightDir0OS, VOutLightDir1OS, VOutEyeDirOS, light0, light1);
	
	vec3 totalLight = light0.rgb + light1.rgb;
	totalLight = saturate(totalLight);
	vec3 negLight = vec3(1.0,1.0,1.0) - totalLight;
	
	vec3 specularLight = light0.www*g_cSpecularColor.rgb;
	float specLuminosity = (specularLight.r*0.33 + specularLight.g*0.59 + specularLight.b*0.11);
	specLuminosity = saturate( specLuminosity  );
	
	vec3 colorMap = g_cDiffuseColor.rgb * texelTotal;
	gl_FragColor.rgb = negLight*g_cAmbientColor.rgb*colorMap.rgb + totalLight*colorMap.rgb + specularLight;
	gl_FragColor.a = saturate( texelAlpha*g_cDiffuseColor.a
#ifndef HAVE_OPACITY1
	+ specLuminosity
#endif
	); // a few neweer demos use rhe fact that specular is aditional on alpha channel

	COMPUTE_FOG
}
#endif

#ifdef ENTRYPOINT_PixDecalT2
varying HIGHP vec4 VOutTexCoord0;

varying HIGHP vec3 VOutNormal;
varying HIGHP vec3 VOutLightDir0OS;
varying HIGHP vec3 VOutLightDir1OS;
varying HIGHP vec3 VOutEyeDirOS;
varying HIGHP vec3 VOutPosView; 

void main()
{	
	// Sample textures: original, fractured, and decal map
	vec4 	clrOrig 	= texture2D(g_sSamplerZero,VOutTexCoord0.xy);
	vec4	clrBroken 	= texture2D(g_sSamplerOne,VOutTexCoord0.xy);
	float	clrD		= texture2D(g_sSamplerTwo,VOutTexCoord0.zw).r;	//Auto-generated decal map
	
	clrD = clamp(2.5 * (clrD - 0.2), -0.5, 0.5);
	
	// Modulate	
    vec4 texelTotal = lerp(clrBroken, clrOrig, 0.5 + clrD);
    
	vec4 light0 = vec4(1.0,1.0,1.0,1.0);
	vec3 light1 = vec3(0.0,0.0,0.0);
	LightPixel( VOutPosView, normalize(VOutNormal), VOutLightDir0OS, VOutLightDir1OS, VOutEyeDirOS, light0, light1);
	
	vec3 totalLight = light0.rgb + light1.rgb;
	totalLight = saturate(totalLight);
	vec3 negLight = vec3(1.0,1.0,1.0) - totalLight;
	
	vec3 specularLight = light0.www*g_cSpecularColor.rgb;
	float specLuminosity = (specularLight.r*0.33 + specularLight.g*0.59 + specularLight.b*0.11);
	specLuminosity = saturate( specLuminosity );
	
	vec4 colorMap = g_cDiffuseColor * texelTotal;
	gl_FragColor.rgb = negLight*g_cAmbientColor.rgb*colorMap.rgb + totalLight*colorMap.rgb + specularLight;
	gl_FragColor.a = saturate( colorMap.a + specLuminosity); // a few neweer demos use rhe fact that specular is aditional on alpha channel

	COMPUTE_FOG

}
#endif

#ifdef ENTRYPOINT_PixShadowDecalT2
varying HIGHP vec4 VOutTexCoord0;


varying HIGHP vec3 VOutNormal;
varying HIGHP vec3 VOutLightDir0OS;
varying HIGHP vec3 VOutLightDir1OS;
varying HIGHP vec3 VOutEyeDirOS;
varying HIGHP vec3 VOutPosView; 

void main()
{ 
	float lightAmount = getLightAmountShadow( VOutPosView );
	
	// Sample textures: original, fractured, and decal map
	vec4 	clrOrig 	= texture2D(g_sSamplerFour,VOutTexCoord0.xy);
	vec4	clrBroken 	= texture2D(g_sSamplerFive,VOutTexCoord0.xy);
	float	clrD		= texture2D(g_sSamplerSix,VOutTexCoord0.zw).r;	//Auto-generated decal map
	
	clrD = clamp(2.5 * (clrD - 0.2), -0.5, 0.5);
	
	// Modulate	
    vec4 texelTotal = lerp(clrBroken, clrOrig, 0.5 + clrD);
     
	vec4 light0 = vec4(1.0,1.0,1.0,1.0);
	vec3 light1 = vec3(0.0,0.0,0.0);
	LightPixel( VOutPosView, normalize(VOutNormal), VOutLightDir0OS, VOutLightDir1OS, VOutEyeDirOS, light0, light1);
	
	vec3 specularLight = light0.www*g_cSpecularColor.rgb;
	float specLuminosity = (specularLight.r*0.33 + specularLight.g*0.59 + specularLight.b*0.11);
	specLuminosity = saturate( specLuminosity * lightAmount );
	
	vec3 totalLight = light0.rgb + light1.rgb  + g_cAmbientColor.rgb;
	vec4 colorMap = g_cDiffuseColor * texelTotal;
	gl_FragColor.rgb = (1.0-lightAmount)*(light1.rgb+g_cAmbientColor.rgb)*colorMap.rgb + lightAmount*( totalLight*colorMap.rgb + specularLight );
	gl_FragColor.a = saturate( colorMap.a + specLuminosity); // a few neweer demos use rhe fact that specular is aditional on alpha channel

	COMPUTE_FOG

 
}
#endif

#ifdef ENTRYPOINT_PixDecorT2
varying HIGHP vec4 VOutTexCoord0;


varying HIGHP vec3 VOutNormal;
varying HIGHP vec3 VOutLightDir0OS;
varying HIGHP vec3 VOutLightDir1OS;
varying HIGHP vec3 VOutEyeDirOS;
varying HIGHP vec3 VOutPosView; 

void main()
{ 
	// Sample textures: original and decor map
	vec4 	clrDecor 	=  texture2D(g_sSamplerZero, VOutTexCoord0.xy);
	float	clrD		=  texture2D(g_sSamplerOne, VOutTexCoord0.zw).r;	//Auto-generated decal map
	
	clrD = clamp(2.5 * (clrD - 0.2), -0.5, .5);
		
	// Apply a threshold
	clrD = (clrD > 0.0) ? 1.0 : 0.0;
	float 	alpha 	= clrDecor.a * (1.0 - clrD);
    vec4 texelTotal = vec4(clrDecor.rgb, alpha);
    
	vec4 light0 = vec4(1.0,1.0,1.0,1.0);
	vec3 light1 = vec3(0.0,0.0,0.0);
	LightPixel( VOutPosView, normalize(VOutNormal), VOutLightDir0OS, VOutLightDir1OS, VOutEyeDirOS, light0, light1);
	
	vec3 totalLight = light0.rgb + light1.rgb;
	totalLight = saturate(totalLight);
	vec3 negLight = vec3(1.0,1.0,1.0) - totalLight;
	
	vec3 specularLight = light0.www*g_cSpecularColor.rgb;
	float specLuminosity = (specularLight.r*0.33 + specularLight.g*0.59 + specularLight.b*0.11);
	specLuminosity = saturate( specLuminosity  );
	
	vec4 colorMap = g_cDiffuseColor * texelTotal;
	gl_FragColor.rgb = negLight*g_cAmbientColor.rgb*colorMap.rgb + totalLight*colorMap.rgb + specularLight;
	gl_FragColor.a = saturate( colorMap.a + specLuminosity); // a few neweer demos use rhe fact that specular is aditional on alpha channel

	COMPUTE_FOG

}
#endif
 
#ifdef ENTRYPOINT_PixShadowDecorT2
varying HIGHP vec4 VOutTexCoord0;


varying HIGHP vec3 VOutNormal;
varying HIGHP vec3 VOutLightDir0OS;
varying HIGHP vec3 VOutLightDir1OS;
varying HIGHP vec3 VOutEyeDirOS;
varying HIGHP vec3 VOutPosView; 

void main()
{
	float lightAmount = getLightAmountShadow( VOutPosView );
	
	// Sample textures: original and decor map
	vec4 	clrDecor 	= texture2D(g_sSamplerFour, VOutTexCoord0.xy);
	float	clrD		= texture2D(g_sSamplerFive, VOutTexCoord0.zw).r;	//Auto-generated decal map
	
	clrD = clamp(2.5 * (clrD - 0.2), -0.5, .5);
	
	// Apply a threshold
	clrD = (clrD > 0.0) ? 1.0 : 0.0;
	float 	alpha 	= clrDecor.a * (1.0 - clrD);
    vec4 texelTotal = vec4(clrDecor.rgb, alpha);
     
	vec4 light0 = vec4(1.0,1.0,1.0,1.0);
	vec3 light1 = vec3(0.0,0.0,0.0);
	LightPixel( VOutPosView, normalize(VOutNormal), VOutLightDir0OS, VOutLightDir1OS, VOutEyeDirOS, light0, light1);
	
	vec3 specularLight = light0.www*g_cSpecularColor.rgb;
	float specLuminosity = (specularLight.r*0.33 + specularLight.g*0.59 + specularLight.b*0.11);
	specLuminosity = saturate( specLuminosity * lightAmount );
	
	vec3 totalLight = light0.rgb + light1.rgb  + g_cAmbientColor.rgb;
	vec4 colorMap = g_cDiffuseColor * texelTotal;
	gl_FragColor.rgb = (1.0-lightAmount)*(light1.rgb+g_cAmbientColor.rgb)*colorMap.rgb + lightAmount*( totalLight*colorMap.rgb + specularLight );
	gl_FragColor.a = saturate( colorMap.a + specLuminosity ); // a few neweer demos use rhe fact that specular is aditional on alpha channel

	COMPUTE_FOG

}
#endif

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
