/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */

//
// One diffuse map along with a normal and displacement map, with and without shadows. A common demo shader
// with 'proper' assets 
//
//:STYLE VsPassThrough HsPassThrough DsOneLightParallax HK_NULL PixT1Bump LD* T1 DIFFUSE0 NORMAL0 DISPLACEMENT0 DOMINANTS0 DEFINE:NORMALMAPPED
//:STYLE VsPassThrough HsPassThrough DsOneLightParallax HK_NULL PixShadowSceneT1Bump LD* T1 SHADOWMAP DIFFUSE0 NORMAL0 DISPLACEMENT0 DOMINANTS0 TESSDATA0 DEFINE:NORMALMAPPED DEFINE:SHADOWMAPPED

// + SPECULAR
//:STYLE VsPassThrough HsPassThrough DsOneLightParallax HK_NULL PixT1Bump LD* T1 DIFFUSE0 NORMAL0 DISPLACEMENT0 SPECULAR0 DOMINANTS0 DEFINE:NORMALMAPPED DEFINE:SPECULARMAPPED 
//:STYLE VsPassThrough HsPassThrough DsOneLightParallax HK_NULL PixShadowSceneT1Bump LD* T1 SHADOWMAP DIFFUSE0 NORMAL0 DISPLACEMENT0 SPECULAR0 DOMINANTS0 DEFINE:NORMALMAPPED DEFINE:SPECULARMAPPED DEFINE:SHADOWMAPPED

// + SKINNED
//:STYLE VsPassThrough HsPassThrough DsOneLightParallax HK_NULL PixT1Bump LD* T1 DIFFUSE0 NORMAL0 DISPLACEMENT0 DOMINANTS0 SKINNED DEFINE:NORMALMAPPED DEFINE:HKG_SKINNING
//:STYLE VsPassThrough HsPassThrough DsOneLightParallax HK_NULL PixShadowSceneT1Bump LD* T1 SHADOWMAP DIFFUSE0 NORMAL0 DISPLACEMENT0 DOMINANTS0 SKINNED DEFINE:NORMALMAPPED DEFINE:SHADOWMAPPED DEFINE:HKG_SKINNING

// + SKINNED + SPECULAR
//:STYLE VsPassThrough HsPassThrough DsOneLightParallax HK_NULL PixT1Bump LD* T1 DIFFUSE0 NORMAL0 DISPLACEMENT0 SPECULAR0 DOMINANTS0 SKINNED DEFINE:NORMALMAPPED DEFINE:SPECULARMAPPED DEFINE:HKG_SKINNING 
//:STYLE VsPassThrough HsPassThrough DsOneLightParallax HK_NULL PixT1Bump LD* T1 DIFFUSE0 NORMAL0 DISPLACEMENT0 DISPLACEMENT0 SPECULAR0 DOMINANTS0 SKINNED DEFINE:NORMALMAPPED DEFINE:SPECULARMAPPED DEFINE:HKG_SKINNING DEFINE:BLEND_TWO_DISPLACEMENTS
//:STYLE VsPassThrough HsPassThrough DsOneLightParallax HK_NULL PixShadowSceneT1Bump LD* T1 SHADOWMAP DIFFUSE0 NORMAL0 DISPLACEMENT0 SPECULAR0 DOMINANTS0 SKINNED DEFINE:NORMALMAPPED DEFINE:SPECULARMAPPED DEFINE:SHADOWMAPPED DEFINE:HKG_SKINNING
//:STYLE VsPassThrough HsPassThrough DsOneLightParallax HK_NULL PixShadowSceneT1Bump LD* T1 SHADOWMAP DIFFUSE0 NORMAL0 DISPLACEMENT0 DISPLACEMENT0 SPECULAR0 DOMINANTS0 SKINNED DEFINE:NORMALMAPPED DEFINE:SPECULARMAPPED DEFINE:SHADOWMAPPED DEFINE:HKG_SKINNING DEFINE:BLEND_TWO_DISPLACEMENTS

#include "CommonDisplacementHeader.hlslh"

//
//	Copied from DiffuseMixNormalSpecular.hlsl

pixelOutput PixT1Bump( vertexOutputT1B In )
{
	HKG_TEST_DEPTH_PEEL

	float4 ColorMap = float4(1,1,1,1);
	float3 SpecMap = 0;
	float3 N = float3(0,0,1); 
	
    ColorMap = _sample0(In.texCoord0);
	float4 DecalMap = 1;

#ifdef DECAL

	DecalMap = _sample1(In.texCoord0);

	N = _sample2(In.texCoord0).xyz*2.0 - 1.0;
	N = normalize(N);

#ifndef NO_SPEC
	SpecMap = _sample3(In.texCoord0).rgb * g_cSpecularColor.rgb;
#endif

#else

	N = _sample1(In.texCoord0).xyz*2.0 - 1.0;
	N = normalize(N);

#ifndef NO_SPEC
	SpecMap = _sample2(In.texCoord0).rgb * g_cSpecularColor.rgb;
#endif
#endif

	ColorMap *= g_cDiffuseColor;
	clip( ColorMap.a - ALPHA_DISCARD_TOLERANCE );

	float4 light0 = 1;
	float3 light1 = 0;
#if ENABLE_LIGHTING
	LightPixel( In.posView, N, In.toLightDir0TS, In.toLightDir1TS, In.eyeDirTS, light0, light1);
#endif
	
	pixelOutput Output;

	float3 totalLight = light0.rgb + light1.rgb;
	saturate(totalLight);
	float3 negLight = float3(1,1,1) - totalLight;
	Output.color.rgb = (negLight*g_cAmbientColor.rgb*ColorMap.rgb + totalLight*ColorMap.rgb + light0.www*SpecMap) * ( DecalMap.rgb );
	Output.color.a = ColorMap.a; // modulate alpha as is, light doesn't affect it.
	if ( g_iFogParams.x > 0)
    {
		Output.color = computeFog( In.posView.z, Output.color );
    }

	// DEBUG!!!
//	Output.color = float4(SAMPLE_DISPLACEMENT(In.texCoord0.xy).rgb, 1);
	
    Output.pzDepth.rgb = In.posView.z * g_iDepthParams.x;
    Output.pzDepth.a = Output.color.a;

	 return Output; 
}

//
//	Copied from DiffuseMixNormalSpecular.hlsl

pixelOutput PixShadowSceneT1Bump( vertexOutputT1B In )
{
	HKG_TEST_DEPTH_PEEL

    pixelOutput Output;
    
	float lightAmount = getLightAmountShadow( In.posView );
	
		
	float3 N = float3(0,0,1); 
	
    float3 SpecMap = 0;

#ifdef DECAL
	
	float4 DecalMap = _sample5(In.texCoord0);
	float4 ColorMap = _sample4(In.texCoord0);
	
	N = _sample6(In.texCoord0).xyz*2.0 - 1.0;
	N = normalize(N);

#if !defined(NO_SPEC) && !defined(HKG_DEPTH_PEEL)
	SpecMap = _sample7(In.texCoord0).rgb * g_cSpecularColor.rgb;
#endif

#else
	float4 DecalMap = 1;
	float4 ColorMap = _sample4(In.texCoord0);

	N = _sample5(In.texCoord0).xyz*2.0 - 1.0;
	N = normalize(N);

#ifndef NO_SPEC
	SpecMap = _sample6(In.texCoord0).rgb * g_cSpecularColor.rgb;
#endif

#endif

	ColorMap *= g_cDiffuseColor;
	clip( ColorMap.a - ALPHA_DISCARD_TOLERANCE );

	float4 light0 = 1;
	float3 light1 = 0;
#if ENABLE_LIGHTING
	LightPixel( In.posView, N, In.toLightDir0TS, In.toLightDir1TS, In.eyeDirTS, light0, light1);
#endif
	
	float3 totalLight = light0.rgb + light1.rgb + g_cAmbientColor.rgb;
	saturate(totalLight);
	Output.color.rgb = ((1-lightAmount)*(light1.rgb+g_cAmbientColor.rgb)*ColorMap.rgb + lightAmount*( totalLight*ColorMap.rgb + light0.www*SpecMap )) * DecalMap.rgb;
	Output.color.a = ColorMap.a; // modulate alpha as is, shadow doesn't affect it.
	
    if ( g_iFogParams.x > 0)
    {
		Output.color = computeFog( In.posView.z, Output.color );
    }
	
	// DEBUG!!!
//	Output.color = float4(SAMPLE_DISPLACEMENT(In.texCoord0.xy).rgb, 1);
    
    Output.pzDepth.rgb = In.posView.z * g_iDepthParams.x;
    Output.pzDepth.a = Output.color.a;

    return Output;
}

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
