/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */

//
// One or Two diffuse maps, along with a normal and specular map, with and without shadows. The most common demo shaders 
// with 'proper' assets. These will currently also allow loading of a gloss map, but will ignore it
//
//:STYLE VertBump HK_NULL HK_NULL HK_NULL PixT1BumpND LD* T1 NORMAL0 SPECULAR0 
//:STYLE VertBump HK_NULL HK_NULL HK_NULL PixT1Bump LD* T1 DIFFUSE0 NORMAL0 SPECULAR0
//:STYLE VertBump HK_NULL HK_NULL HK_NULL PixT1Bump LD* T1 DIFFUSE0 NORMAL0 SPECULAR0 GLOSS0
//:STYLE VertBump HK_NULL HK_NULL HK_NULL PixT2Bump LD* T2 DIFFUSE0 DIFFUSE1 NORMAL0 SPECULAR0 DEFINE:TWO_TCOORDS
//:STYLE VertBump HK_NULL HK_NULL HK_NULL PixT2Bump LD* T1 DIFFUSE0 DIFFUSE0 NORMAL0 DEFINE:DECAL DEFINE:NO_SPEC
//:STYLE VertBump HK_NULL HK_NULL HK_NULL PixT2Bump LD* T2 DIFFUSE0 DIFFUSE1 NORMAL0 DEFINE:TWO_TCOORDS
//:STYLE VertBump HK_NULL HK_NULL HK_NULL PixT2Bump LD* T3 DIFFUSE0 DIFFUSE1 NORMAL2 DEFINE:TWO_TCOORDS
//:STYLE VertBump HK_NULL HK_NULL HK_NULL PixT2Bump LD* T1 DIFFUSE0 DIFFUSE0 NORMAL0 SPECULAR0 DEFINE:DECAL DEFINE:TWO_TCOORDS
//:STYLE VertBump HK_NULL HK_NULL HK_NULL PixT2Bump LD* T2 DIFFUSE0 DIFFUSE1 NORMAL0 SPECULAR0 GLOSS0 DEFINE:TWO_TCOORDS
//:STYLE VertBump HK_NULL HK_NULL HK_NULL PixT2BumpLM LD* T2 DIFFUSE0 LIGHTMAP1 NORMAL0 DEFINE:TWO_TCOORDS DEFINE:NO_SPEC
//:STYLE VertBump HK_NULL HK_NULL HK_NULL PixT2BumpLM LD* T2 DIFFUSE0 LIGHTMAP1 NORMAL0 GLOSS0 DEFINE:TWO_TCOORDS DEFINE:NO_SPEC
//:STYLE VertBump HK_NULL HK_NULL HK_NULL PixT2BumpLM LD* T2 DIFFUSE0 LIGHTMAP1 NORMAL0 SPECULAR0 DEFINE:TWO_TCOORDS
//:STYLE VertBump HK_NULL HK_NULL HK_NULL PixT2BumpLM LD* T2 DIFFUSE0 LIGHTMAP1 NORMAL0 SPECULAR0 GLOSS0 DEFINE:TWO_TCOORDS
//:STYLE VertBump HK_NULL HK_NULL HK_NULL PixShadowSceneT1BumpND LD* T1 SHADOWMAP NORMAL0 SPECULAR0
//:STYLE VertBump HK_NULL HK_NULL HK_NULL PixShadowSceneT1Bump LD* T1 SHADOWMAP DIFFUSE0 NORMAL0 SPECULAR0
//:STYLE VertBump HK_NULL HK_NULL HK_NULL PixShadowSceneT1Bump LD* T1 SHADOWMAP DIFFUSE0 NORMAL0 SPECULAR0 GLOSS0
//:STYLE VertBump HK_NULL HK_NULL HK_NULL PixShadowSceneT1Bump LD* T1 SHADOWMAP DIFFUSE0 DIFFUSE0 NORMAL0 DEFINE:DECAL DEFINE:NO_SPEC
//:STYLE VertBump HK_NULL HK_NULL HK_NULL PixShadowSceneT2Bump LD* T2 SHADOWMAP DIFFUSE0 DIFFUSE1 NORMAL0 DEFINE:TWO_TCOORDS
//:STYLE VertBump HK_NULL HK_NULL HK_NULL PixShadowSceneT2Bump LD* T3 SHADOWMAP DIFFUSE0 DIFFUSE1 NORMAL2 DEFINE:TWO_TCOORDS
//:STYLE VertBump HK_NULL HK_NULL HK_NULL PixShadowSceneT1Bump LD* T1 SHADOWMAP DIFFUSE0 DIFFUSE0 NORMAL0 SPECULAR0 DEFINE:DECAL
//:STYLE VertBump HK_NULL HK_NULL HK_NULL PixShadowSceneT2Bump LD* T2 SHADOWMAP DIFFUSE0 DIFFUSE1 NORMAL0 SPECULAR0 DEFINE:TWO_TCOORDS
//:STYLE VertBump HK_NULL HK_NULL HK_NULL PixShadowSceneT2Bump LD* T2 SHADOWMAP DIFFUSE0 DIFFUSE1 NORMAL0 SPECULAR0 GLOSS0 DEFINE:TWO_TCOORDS
//:STYLE VertBump HK_NULL HK_NULL HK_NULL PixShadowSceneT2BumpLM LD* T2 SHADOWMAP DIFFUSE0 LIGHTMAP1 NORMAL0 DEFINE:TWO_TCOORDS DEFINE:NO_SPEC
//:STYLE VertBump HK_NULL HK_NULL HK_NULL PixShadowSceneT2BumpLM LD* T2 SHADOWMAP DIFFUSE0 LIGHTMAP1 NORMAL0 SPECULAR0 DEFINE:TWO_TCOORDS
//:STYLE VertBump HK_NULL HK_NULL HK_NULL PixShadowSceneT2BumpLM LD* T2 SHADOWMAP DIFFUSE0 LIGHTMAP1 NORMAL0 SPECULAR0 GLOSS0 DEFINE:TWO_TCOORDS

//:STYLE VertBump HK_NULL HK_NULL HK_NULL PixT1BumpND LD* T1 NORMAL0 SPECULAR0 SKINNED DEFINE:HKG_SKINNING
//:STYLE VertBump HK_NULL HK_NULL HK_NULL PixT1Bump LD* T1 DIFFUSE0 NORMAL0 SPECULAR0 SKINNED DEFINE:HKG_SKINNING
//:STYLE VertBump HK_NULL HK_NULL HK_NULL PixT1Bump LD* T1 DIFFUSE0 NORMAL0 SPECULAR0 GLOSS0 SKINNED DEFINE:HKG_SKINNING
//:STYLE VertBump HK_NULL HK_NULL HK_NULL PixT2Bump LD* T2 DIFFUSE0 DIFFUSE1 NORMAL0 SPECULAR0 SKINNED DEFINE:HKG_SKINNING DEFINE:TWO_TCOORDS
//:STYLE VertBump HK_NULL HK_NULL HK_NULL PixT2Bump LD* T1 DIFFUSE0 DIFFUSE0 NORMAL0 SKINNED DEFINE:HKG_SKINNING DEFINE:DECAL DEFINE:NO_SPEC
//:STYLE VertBump HK_NULL HK_NULL HK_NULL PixT2Bump LD* T2 DIFFUSE0 DIFFUSE1 NORMAL0 SKINNED DEFINE:HKG_SKINNING DEFINE:TWO_TCOORDS
//:STYLE VertBump HK_NULL HK_NULL HK_NULL PixT2Bump LD* T1 DIFFUSE0 DIFFUSE0 NORMAL0 SPECULAR0 SKINNED DEFINE:HKG_SKINNING DEFINE:DECAL 
//:STYLE VertBump HK_NULL HK_NULL HK_NULL PixT2Bump LD* T2 DIFFUSE0 DIFFUSE1 NORMAL0 SPECULAR0 GLOSS0 SKINNED DEFINE:HKG_SKINNING DEFINE:TWO_TCOORDS
//:STYLE VertBump HK_NULL HK_NULL HK_NULL PixShadowSceneT1BumpND LD* T1 SHADOWMAP NORMAL0 SPECULAR0 SKINNED DEFINE:HKG_SKINNING
//:STYLE VertBump HK_NULL HK_NULL HK_NULL PixShadowSceneT1Bump LD* T1 SHADOWMAP DIFFUSE0 NORMAL0 SPECULAR0 SKINNED DEFINE:HKG_SKINNING
//:STYLE VertBump HK_NULL HK_NULL HK_NULL PixShadowSceneT1Bump LD* T1 SHADOWMAP DIFFUSE0 NORMAL0 SPECULAR0 GLOSS0 SKINNED DEFINE:HKG_SKINNING
//:STYLE VertBump HK_NULL HK_NULL HK_NULL PixShadowSceneT1Bump LD* T1 SHADOWMAP DIFFUSE0 DIFFUSE0 NORMAL0 SKINNED DEFINE:HKG_SKINNING DEFINE:DECAL DEFINE:NO_SPEC 
//:STYLE VertBump HK_NULL HK_NULL HK_NULL PixShadowSceneT2Bump LD* T2 SHADOWMAP DIFFUSE0 DIFFUSE1 NORMAL0 SKINNED DEFINE:HKG_SKINNING DEFINE:TWO_TCOORDS
//:STYLE VertBump HK_NULL HK_NULL HK_NULL PixShadowSceneT1Bump LD* T1 SHADOWMAP DIFFUSE0 DIFFUSE0 NORMAL0 SPECULAR0 SKINNED DEFINE:HKG_SKINNING DEFINE:DECAL 
//:STYLE VertBump HK_NULL HK_NULL HK_NULL PixShadowSceneT2Bump LD* T2 SHADOWMAP DIFFUSE0 DIFFUSE1 NORMAL0 SPECULAR0 SKINNED DEFINE:HKG_SKINNING DEFINE:TWO_TCOORDS
//:STYLE VertBump HK_NULL HK_NULL HK_NULL PixShadowSceneT2Bump LD* T2 SHADOWMAP DIFFUSE0 DIFFUSE1 NORMAL0 SPECULAR0 GLOSS0 SKINNED DEFINE:HKG_SKINNING DEFINE:TWO_TCOORDS

//:STYLE VertBump HK_NULL HK_NULL HK_NULL PixT1BumpND LD* T1 NORMAL0 SPECULAR0 INSTANCED DEFINE:HKG_INSTANCING
//:STYLE VertBump HK_NULL HK_NULL HK_NULL PixT1Bump LD* T1 DIFFUSE0 NORMAL0 SPECULAR0 INSTANCED DEFINE:HKG_INSTANCING
//:STYLE VertBump HK_NULL HK_NULL HK_NULL PixT1Bump LD* T1 DIFFUSE0 NORMAL0 SPECULAR0 GLOSS0 INSTANCED DEFINE:HKG_INSTANCING
//:STYLE VertBump HK_NULL HK_NULL HK_NULL PixT2Bump LD* T2 DIFFUSE0 DIFFUSE1 NORMAL0 SPECULAR0 INSTANCED DEFINE:HKG_INSTANCING DEFINE:TWO_TCOORDS
//:STYLE VertBump HK_NULL HK_NULL HK_NULL PixT2Bump LD* T1 DIFFUSE0 DIFFUSE0 NORMAL0 INSTANCED DEFINE:HKG_INSTANCING DEFINE:DECAL DEFINE:NO_SPEC
//:STYLE VertBump HK_NULL HK_NULL HK_NULL PixT2Bump LD* T2 DIFFUSE0 DIFFUSE1 NORMAL0 INSTANCED DEFINE:HKG_INSTANCING DEFINE:TWO_TCOORDS
//:STYLE VertBump HK_NULL HK_NULL HK_NULL PixT2Bump LD* T1 DIFFUSE0 DIFFUSE0 NORMAL0 SPECULAR0 INSTANCED DEFINE:HKG_INSTANCING DEFINE:DECAL 
//:STYLE VertBump HK_NULL HK_NULL HK_NULL PixT2Bump LD* T2 DIFFUSE0 DIFFUSE1 NORMAL0 SPECULAR0 GLOSS0 INSTANCED DEFINE:HKG_INSTANCING DEFINE:TWO_TCOORDS
//:STYLE VertBump HK_NULL HK_NULL HK_NULL PixT2BumpLM LD* T2 DIFFUSE0 LIGHTMAP1 NORMAL0 SPECULAR0 INSTANCED DEFINE:HKG_INSTANCING DEFINE:TWO_TCOORDS
//:STYLE VertBump HK_NULL HK_NULL HK_NULL PixT2BumpLM LD* T2 DIFFUSE0 LIGHTMAP1 NORMAL0 SPECULAR0 GLOSS0 INSTANCED DEFINE:HKG_INSTANCING DEFINE:TWO_TCOORDS
//:STYLE VertBump HK_NULL HK_NULL HK_NULL PixShadowSceneT1BumpND LD* T1 SHADOWMAP NORMAL0 SPECULAR0 INSTANCED DEFINE:HKG_INSTANCING
//:STYLE VertBump HK_NULL HK_NULL HK_NULL PixShadowSceneT1Bump LD* T1 SHADOWMAP DIFFUSE0 NORMAL0 SPECULAR0 INSTANCED DEFINE:HKG_INSTANCING
//:STYLE VertBump HK_NULL HK_NULL HK_NULL PixShadowSceneT1Bump LD* T1 SHADOWMAP DIFFUSE0 NORMAL0 SPECULAR0 GLOSS0 INSTANCED DEFINE:HKG_INSTANCING
//:STYLE VertBump HK_NULL HK_NULL HK_NULL PixShadowSceneT1Bump LD* T1 SHADOWMAP DIFFUSE0 DIFFUSE0 NORMAL0 INSTANCED DEFINE:HKG_INSTANCING DEFINE:DECAL DEFINE:NO_SPEC 
//:STYLE VertBump HK_NULL HK_NULL HK_NULL PixShadowSceneT2Bump LD* T2 SHADOWMAP DIFFUSE0 DIFFUSE1 NORMAL0 INSTANCED DEFINE:HKG_INSTANCING DEFINE:TWO_TCOORDS
//:STYLE VertBump HK_NULL HK_NULL HK_NULL PixShadowSceneT1Bump LD* T1 SHADOWMAP DIFFUSE0 DIFFUSE0 NORMAL0 SPECULAR0 INSTANCED DEFINE:HKG_INSTANCING DEFINE:DECAL 
//:STYLE VertBump HK_NULL HK_NULL HK_NULL PixShadowSceneT2Bump LD* T2 SHADOWMAP DIFFUSE0 DIFFUSE1 NORMAL0 SPECULAR0 INSTANCED DEFINE:HKG_INSTANCING DEFINE:TWO_TCOORDS
//:STYLE VertBump HK_NULL HK_NULL HK_NULL PixShadowSceneT2Bump LD* T2 SHADOWMAP DIFFUSE0 DIFFUSE1 NORMAL0 SPECULAR0 GLOSS0 INSTANCED DEFINE:HKG_INSTANCING DEFINE:TWO_TCOORDS
//:STYLE VertBump HK_NULL HK_NULL HK_NULL PixShadowSceneT2BumpLM LD* T2 SHADOWMAP DIFFUSE0 LIGHTMAP1 NORMAL0 INSTANCED DEFINE:HKG_INSTANCING DEFINE:TWO_TCOORDS DEFINE:NO_SPEC 
//:STYLE VertBump HK_NULL HK_NULL HK_NULL PixShadowSceneT2BumpLM LD* T2 SHADOWMAP DIFFUSE0 LIGHTMAP1 NORMAL0 SPECULAR0 INSTANCED DEFINE:HKG_INSTANCING DEFINE:TWO_TCOORDS
//:STYLE VertBump HK_NULL HK_NULL HK_NULL PixShadowSceneT2BumpLM LD* T2 SHADOWMAP DIFFUSE0 LIGHTMAP1 NORMAL0 SPECULAR0 GLOSS0 INSTANCED DEFINE:HKG_INSTANCING DEFINE:TWO_TCOORDS

//:STYLE VertBump HK_NULL HK_NULL HK_NULL PixT1Bump LD* T1 DIFFUSE0 NORMAL0 SPECULAR0 INSTANCED SKINNED DEFINE:HKG_SKINNING DEFINE:HKG_INSTANCING
//:STYLE VertBump HK_NULL HK_NULL HK_NULL PixShadowSceneT1Bump LD* T1 SHADOWMAP DIFFUSE0 NORMAL0 SPECULAR0 INSTANCED SKINNED DEFINE:HKG_SKINNING DEFINE:HKG_INSTANCING

//:STYLE VertBump HK_NULL HK_NULL HK_NULL PixT1Bump LD* T1 DIFFUSE0 NORMAL0 SPECULAR0 IRRADIANCE DEFINE:HKG_IRRADIANCE_MAPS DEFINE:HKG_CUBEMAP_SLOT13 DEFINE:HKG_CUBEMAP_SLOT14
//:STYLE VertBump HK_NULL HK_NULL HK_NULL PixShadowSceneT1Bump LD* T1 SHADOWMAP DIFFUSE0 NORMAL0 SPECULAR0 IRRADIANCE DEFINE:HKG_IRRADIANCE_MAPS DEFINE:HKG_CUBEMAP_SLOT13 DEFINE:HKG_CUBEMAP_SLOT14 DEFINE:HKG_SHADOWS
//:STYLE VertBump HK_NULL HK_NULL HK_NULL PixT1Bump LD* T1 DIFFUSE0 NORMAL0 SPECULAR0 IRRADIANCE INSTANCED DEFINE:HKG_INSTANCING DEFINE:HKG_IRRADIANCE_MAPS DEFINE:HKG_CUBEMAP_SLOT13 DEFINE:HKG_CUBEMAP_SLOT14
//:STYLE VertBump HK_NULL HK_NULL HK_NULL PixShadowSceneT1Bump LD* T1 SHADOWMAP DIFFUSE0 NORMAL0 SPECULAR0 IRRADIANCE INSTANCED DEFINE:HKG_INSTANCING DEFINE:HKG_IRRADIANCE_MAPS DEFINE:HKG_CUBEMAP_SLOT13 DEFINE:HKG_CUBEMAP_SLOT14 DEFINE:HKG_SHADOWS
//:STYLE VertBump HK_NULL HK_NULL HK_NULL PixT1Bump LD* T1 DIFFUSE0 NORMAL0 SPECULAR0 IRRADIANCE SKINNED DEFINE:HKG_SKINNING DEFINE:HKG_IRRADIANCE_MAPS DEFINE:HKG_CUBEMAP_SLOT13 DEFINE:HKG_CUBEMAP_SLOT14
//:STYLE VertBump HK_NULL HK_NULL HK_NULL PixShadowSceneT1Bump LD* T1 SHADOWMAP DIFFUSE0 NORMAL0 SPECULAR0 IRRADIANCE SKINNED DEFINE:HKG_SKINNING DEFINE:HKG_IRRADIANCE_MAPS DEFINE:HKG_CUBEMAP_SLOT13 DEFINE:HKG_CUBEMAP_SLOT14 DEFINE:HKG_SHADOWS
//:STYLE VertBump HK_NULL HK_NULL HK_NULL PixT1Bump LD* T1 DIFFUSE0 NORMAL0 SPECULAR0 IRRADIANCE INSTANCED SKINNED DEFINE:HKG_SKINNING DEFINE:HKG_INSTANCING DEFINE:HKG_IRRADIANCE_MAPS DEFINE:HKG_CUBEMAP_SLOT13 DEFINE:HKG_CUBEMAP_SLOT14
//:STYLE VertBump HK_NULL HK_NULL HK_NULL PixShadowSceneT1Bump LD* T1 SHADOWMAP DIFFUSE0 NORMAL0 SPECULAR0 IRRADIANCE INSTANCED SKINNED DEFINE:HKG_SKINNING DEFINE:HKG_INSTANCING DEFINE:HKG_IRRADIANCE_MAPS DEFINE:HKG_CUBEMAP_SLOT13 DEFINE:HKG_CUBEMAP_SLOT14 DEFINE:HKG_SHADOWS
//:STYLE VertBump HK_NULL HK_NULL HK_NULL PixT1Bump LD* T1 DIFFUSE0 NORMAL0 SPECULAR0 IRRADIANCE RIGID SKINNED DEFINE:HKG_RIGID_SKINNING DEFINE:HKG_SKINNING DEFINE:HKG_IRRADIANCE_MAPS DEFINE:HKG_CUBEMAP_SLOT13 DEFINE:HKG_CUBEMAP_SLOT14
//:STYLE VertBump HK_NULL HK_NULL HK_NULL PixShadowSceneT1Bump LD* T1 SHADOWMAP DIFFUSE0 NORMAL0 SPECULAR0 IRRADIANCE RIGID SKINNED DEFINE:HKG_RIGID_SKINNING DEFINE:HKG_SKINNING DEFINE:HKG_IRRADIANCE_MAPS DEFINE:HKG_CUBEMAP_SLOT13 DEFINE:HKG_CUBEMAP_SLOT14 DEFINE:HKG_SHADOWS
//:STYLE VertBump HK_NULL HK_NULL HK_NULL PixT1Bump LD* T1 DIFFUSE0 NORMAL0 SPECULAR0 IRRADIANCE INSTANCED RIGID SKINNED DEFINE:HKG_RIGID_SKINNING DEFINE:HKG_SKINNING DEFINE:HKG_INSTANCING DEFINE:HKG_IRRADIANCE_MAPS DEFINE:HKG_CUBEMAP_SLOT13 DEFINE:HKG_CUBEMAP_SLOT14
//:STYLE VertBump HK_NULL HK_NULL HK_NULL PixShadowSceneT1Bump LD* T1 SHADOWMAP DIFFUSE0 NORMAL0 SPECULAR0 IRRADIANCE INSTANCED RIGID SKINNED DEFINE:HKG_RIGID_SKINNING DEFINE:HKG_SKINNING DEFINE:HKG_INSTANCING DEFINE:HKG_IRRADIANCE_MAPS DEFINE:HKG_CUBEMAP_SLOT13 DEFINE:HKG_CUBEMAP_SLOT14 DEFINE:HKG_SHADOWS

#include "CommonHeader.hlslh"
#include "CommonSampleHeader.hlslh"
#include "CommonVertexShaders.hlslh"

// Pixel shaders
pixelOutput PixT2Bump( vertexOutputT2B In )
{
	HKG_TEST_DEPTH_PEEL
  
    float4 ColorMap = float4(1,1,1,1);
	float3 SpecMap = g_cSpecularColor.rgb;
	float3 N = float3(0,0,1); 
	
#if ENABLE_DIFFUSE_MAP0
    ColorMap = _sample0(In.texCoord01.xy);
#endif

#if ENABLE_DIFFUSE_MAP1
	#if ENABLE_DIFFUSE_MAP0
		ColorMap = ColorMap + (_sample1(In.texCoord01.zw) * 0.6);
	#else
		ColorMap = _sample1(In.texCoord01.zw);
	#endif
#endif
	
#if ENABLE_NORMAL_MAP
	#if ENABLE_LIGHTING
		N = _sample2( In.texCoord01.xy).xyz*2.0 - 1.0;
		N = normalize(N);
	#else
		ColorMap = _sample2(In.texCoord01.xy);
	#endif
#endif

#ifndef NO_SPEC
	SpecMap *= _sample3( In.texCoord01.xy).rgb;
#endif
	
	ColorMap *= g_cDiffuseColor;
	clip( ColorMap.a - getAlphaClipTolerance() );

	float4 light0 = 1;
	float3 light1 = 0;
#if ENABLE_LIGHTING
	LightPixel( In.posView, N, In.toLightDir0TS, In.toLightDir1TS, In.eyeDirTS, light0, light1);
#endif
	
	pixelOutput Output;
	float3 totalLight = light0.rgb + light1.rgb;
	saturate(totalLight);
	float3 negLight = float3(1,1,1) - totalLight;
	
	Output.color.rgb = negLight*g_cAmbientColor.rgb*ColorMap.rgb + totalLight*ColorMap.rgb + light0.www*SpecMap;
	Output.color.a = ColorMap.a; // modulate alpha as is, light doesn't affect it.
	if ( g_iFogParams.x > 0)
    {
		Output.color = computeFog( In.posView.z, Output.color );
	}

	Output.pzDepth.rgb = In.posView.z * g_iDepthParams.x ;
    Output.pzDepth.a = Output.color.a;

    return Output; 
}


// Pixel shaders
pixelOutput PixT2BumpLM( vertexOutputT2B In )
{
	HKG_TEST_DEPTH_PEEL

	float4 ColorMap = float4(1,1,1,1);
	float3 SpecMap = g_cSpecularColor.rgb;
	float3 LightMap = float3(1,1,1);
	float3 N = float3(0,0,1); 
	
#if ENABLE_DIFFUSE_MAP0
    ColorMap = _sample0( In.texCoord01.xy);
#endif

#if ENABLE_LIGHT_MAP
	LightMap = _sample1( In.texCoord01.zw).rgb;
#endif

#if ENABLE_NORMAL_MAP
	#if ENABLE_LIGHTING
		N = _sample2(In.texCoord01.xy).xyz*2.0 - 1.0;
		N = normalize(N);
	#else
		ColorMap = _sample2(In.texCoord01.xy);
	#endif
#endif

#ifndef NO_SPEC
	SpecMap *= _sample3(In.texCoord01.xy).rgb;
#endif
	
	ColorMap *= g_cDiffuseColor;
	clip( ColorMap.a - getAlphaClipTolerance() );


	// Green == 59% of the perceived luminosity, while the red and blue channels account for just 30% and 11%
	float luminosity = (LightMap.r*0.33 + LightMap.g*0.59 + LightMap.b*0.11);
	luminosity = saturate( luminosity );
	
	//float lightMapShadow = 1 - (luminosity * 0.5);
	
	float4 light0 = 1;
	float3 light1 = 0;
#if ENABLE_LIGHTING
	LightPixel( In.posView, N, In.toLightDir0TS, In.toLightDir1TS, In.eyeDirTS, light0, light1);
#endif
	
	light0 *= luminosity;
	float3 specularLight = light0.www*SpecMap.rgb;
	
	pixelOutput Output;
	float3 gammaCorrectLight = ColorMap.rgb * LightMap.rgb; 
	gammaCorrectLight *= 2; // ColorMap is already gamma corrected , but LightMap is not and came from a EXR say in Max. Doing proper 2.2 gamma etc on it seems to wash it out, just *2 looks ok for now
	//gammaCorrectLight *= getExposurePow2();
	//gammaCorrectLight = pow(gammaCorrectLight, getInvGamma() ); 
		
	Output.color.rgb = gammaCorrectLight.rgb + specularLight; 
	
	Output.color.a = ColorMap.a; // modulate alpha as is, light doesn't affect it.
	if ( g_iFogParams.x > 0)
    {
		Output.color = computeFog( In.posView.z, Output.color );
    }

	Output.pzDepth.rgb = In.posView.z * g_iDepthParams.x ;
    Output.pzDepth.a = Output.color.a;

    return Output; 
}
 
 // Pixel shaders
#ifdef HKG_IRRADIANCE_MAPS
pixelOutput PixT1Bump( vertexOutputT1BDim In )
#else
pixelOutput PixT1Bump( vertexOutputT1B In )
#endif
{
	HKG_TEST_DEPTH_PEEL
	
	pixelOutput Output;

	float4 ColorMap = float4(1,1,1,1);
	float3 SpecMap = 0;
	float3 N = float3(0,0,1); 
	
    ColorMap = _sample0(In.texCoord0);
	float4 DecalMap = 1;

#ifdef DECAL

	DecalMap = _sample1(In.texCoord0);

	N = _sample2(In.texCoord0).xyz*2.0 - 1.0;
	N = normalize(N);

#	ifndef NO_SPEC
	SpecMap = _sample3(In.texCoord0).rgb * g_cSpecularColor.rgb;
#	endif
#else

	N = _sample1(In.texCoord0).xyz*2.0 - 1.0;
	N = normalize(N);

#	ifndef NO_SPEC
	SpecMap = _sample2(In.texCoord0).rgb * g_cSpecularColor.rgb;
#	endif
#endif

	ColorMap *= g_cDiffuseColor;
	clip( ColorMap.a - getAlphaClipTolerance() );
	
	float3 litColor;
#ifdef HKG_IRRADIANCE_MAPS
	{
		float3 shadowedColor;
		LightPixelWithCubeMap(ColorMap, SpecMap, N, In.tangToWorld0, In.tangToWorld1, In.tangToWorld2, shadowedColor, litColor);
	}
#else
	{
		float4 light0 = 1;
		float3 light1 = 0;
#	if ENABLE_LIGHTING
		LightPixel( In.posView, N, In.toLightDir0TS, In.toLightDir1TS, In.eyeDirTS, light0, light1);
#	endif

		float3 totalLight = light0.rgb + light1.rgb;
		saturate(totalLight);
		float3 negLight = float3(1,1,1) - totalLight;
		
		litColor = negLight * g_cAmbientColor.rgb * ColorMap.rgb + totalLight * ColorMap.rgb + light0.www * SpecMap;
	}
#endif

	Output.color.rgb = litColor * DecalMap.rgb;
	Output.color.a = ColorMap.a; // modulate alpha as is, light doesn't affect it.
	if ( g_iFogParams.x > 0)
    {
		Output.color = computeFog( In.posView.z, Output.color );
    }

	if ( getColorRangeCorrectionEnabled() )
	{
		Output.color.rgb *= getExposurePow2();
		Output.color.rgb = pow(Output.color.rgb, getInvGamma() ); 
	}
	
    Output.pzDepth.rgb = In.posView.z * g_iDepthParams.x;
    Output.pzDepth.a = Output.color.a;

	 return Output; 
}

 // Pixel shaders
pixelOutput PixT1BumpND( vertexOutputT1B In )
{
	HKG_TEST_DEPTH_PEEL

	float4 ColorMap = g_cDiffuseColor;
	clip( ColorMap.a - getAlphaClipTolerance() );

	float3 SpecMap = g_cSpecularColor.rgb;
	float3 N = float3(0,0,1); 
		
#if ENABLE_NORMAL_MAP
	#if ENABLE_LIGHTING
		N = _sample0( In.texCoord0).xyz*2.0 - 1.0;
		N = normalize(N);
	#else
		ColorMap *= _sample0( In.texCoord0);
	#endif
#endif



#ifndef NO_SPEC
	SpecMap *= _sample1(In.texCoord0).rgb;
#endif

	float4 light0 = 1;
	float3 light1 = 0;
#if ENABLE_LIGHTING
	LightPixel( In.posView, N, In.toLightDir0TS, In.toLightDir1TS, In.eyeDirTS, light0, light1);
#endif
	
	pixelOutput Output;

	float3 totalLight = light0.rgb + light1.rgb;
	saturate(totalLight);
	float3 negLight = float3(1,1,1) - totalLight;
	Output.color.rgb = negLight*g_cAmbientColor.rgb*ColorMap.rgb + totalLight*ColorMap.rgb + light0.www*SpecMap;
	Output.color.a = ColorMap.a; // modulate alpha as is, light doesn't affect it.
	if ( g_iFogParams.x > 0)
    {
		Output.color = computeFog( In.posView.z, Output.color );
    }

    Output.pzDepth.rgb = In.posView.z * g_iDepthParams.x;
    Output.pzDepth.a = Output.color.a;

    return Output; 
}


pixelOutput PixShadowSceneT2Bump( vertexOutputT2B In )
{
  	HKG_TEST_DEPTH_PEEL

	pixelOutput Output;
    
	float lightAmount = getLightAmountShadow( In.posView );
	
		
	float4 ColorMap = float4(1,1,1,1);
	float3 SpecMap = g_cSpecularColor.rgb;
	float3 N = float3(0,0,1); 
	
#if ENABLE_DIFFUSE_MAP0
    ColorMap = _sample4(In.texCoord01.xy);
#endif

#if ENABLE_DIFFUSE_MAP1
	#if ENABLE_DIFFUSE_MAP0
		ColorMap = ColorMap + (_sample5(In.texCoord01.zw) * 0.6);
	#else
		ColorMap = _sample5(In.texCoord01.zw);
	#endif
#endif
		
#if ENABLE_NORMAL_MAP
	#if ENABLE_LIGHTING
		N = _sample6(In.texCoord01.xy).xyz*2.0 - 1.0;
		N = normalize(N);
	#else
		ColorMap = _sample6( In.texCoord01.xy);
	#endif
#endif

#if !defined(NO_SPEC) && !defined(HKG_DEPTH_PEEL)
	SpecMap *= _sample7(In.texCoord01.xy).rgb;
#endif

	ColorMap *= g_cDiffuseColor;
	clip( ColorMap.a - getAlphaClipTolerance() );

	float4 light0 = 1;
	float3 light1 = 0;
#if ENABLE_LIGHTING
	LightPixel( In.posView, N, In.toLightDir0TS, In.toLightDir1TS, In.eyeDirTS, light0, light1);
#endif
	
	float3 totalLight = light0.rgb + light1.rgb + g_cAmbientColor.rgb;
	saturate(totalLight);
	Output.color.rgb = (1-lightAmount)*(light1.rgb+g_cAmbientColor.rgb)*ColorMap.rgb + lightAmount*( totalLight*ColorMap.rgb + light0.www*SpecMap );
	Output.color.a = ColorMap.a; // modulate alpha as is, shadow doesn't affect it.
	
    if ( g_iFogParams.x > 0)
    {
		Output.color = computeFog( In.posView.z, Output.color );
    }
    
    Output.pzDepth.rgb = In.posView.z * g_iDepthParams.x ;
    Output.pzDepth.a = Output.color.a;

    return Output;
}


#ifdef HKG_IRRADIANCE_MAPS
pixelOutput PixShadowSceneT1Bump( vertexOutputT1BDim In )
#else
pixelOutput PixShadowSceneT1Bump( vertexOutputT1B In )
#endif
{
	HKG_TEST_DEPTH_PEEL

    pixelOutput Output;
    
	float lightAmount = getLightAmountShadow( In.posView );
	
		
	float3 N = float3(0,0,1); 
	
    float3 SpecMap = 0;

#ifdef DECAL
	
	float4 DecalMap = _sample5(In.texCoord0);
	float4 ColorMap = _sample4(In.texCoord0);
	
	N = _sample6(In.texCoord0).xyz*2.0 - 1.0;
	N = normalize(N);

#	if !defined(NO_SPEC) && !defined(HKG_DEPTH_PEEL)
	SpecMap = _sample7(In.texCoord0).rgb * g_cSpecularColor.rgb;
#	endif
#else
	float4 DecalMap = 1;
	float4 ColorMap = _sample4(In.texCoord0);

	N = _sample5(In.texCoord0).xyz*2.0 - 1.0;
	N = normalize(N);

#	ifndef NO_SPEC
	SpecMap = _sample6(In.texCoord0).rgb * g_cSpecularColor.rgb;
#	endif
#endif

	ColorMap *= g_cDiffuseColor;
	clip( ColorMap.a - getAlphaClipTolerance() );

	// Lighting
	float3 shadowedColor, litColor;
#ifdef HKG_IRRADIANCE_MAPS
	{
		LightPixelWithCubeMap(ColorMap, SpecMap, N, In.tangToWorld0, In.tangToWorld1, In.tangToWorld2, shadowedColor, litColor);
	}
#else
	{
		float4 light0 = 1;
		float3 light1 = 0;
#	if ENABLE_LIGHTING
		LightPixel( In.posView, N, In.toLightDir0TS, In.toLightDir1TS, In.eyeDirTS, light0, light1);
#	endif
	
		float3 totalLight = light0.rgb + light1.rgb + g_cAmbientColor.rgb;
		saturate(totalLight);
		
		shadowedColor 	= (light1.rgb+g_cAmbientColor.rgb)*ColorMap.rgb;
		litColor		= totalLight*ColorMap.rgb + light0.www * SpecMap;
	}
#endif

	Output.color.rgb 	= ((1-lightAmount) * shadowedColor + lightAmount * litColor) * DecalMap.rgb;
	Output.color.a 		= ColorMap.a; // modulate alpha as is, shadow doesn't affect it.
		
    if ( g_iFogParams.x > 0)
    {
		Output.color = computeFog( In.posView.z, Output.color );
    }
	
	if ( getColorRangeCorrectionEnabled() )
	{
		Output.color.rgb *= getExposurePow2();
		Output.color.rgb = pow(Output.color.rgb, getInvGamma() ); 
	}
    
    Output.pzDepth.rgb = In.posView.z * g_iDepthParams.x;
    Output.pzDepth.a = Output.color.a;

    return Output;
}


pixelOutput PixShadowSceneT1BumpND( vertexOutputT1B In )
{
	HKG_TEST_DEPTH_PEEL

    pixelOutput Output;
    
	float lightAmount = getLightAmountShadow( In.posView );
	
		
	float4 ColorMap = g_cDiffuseColor;
	clip( ColorMap.a - getAlphaClipTolerance() );

	float3 SpecMap = g_cSpecularColor.rgb;
	float3 N = float3(0,0,1); 
			
#if ENABLE_NORMAL_MAP
	#if ENABLE_LIGHTING
		N = _sample4(In.texCoord0).xyz*2.0 - 1.0;
		N = normalize(N);
	#else
		ColorMap *= _sample4(In.texCoord0);
	#endif
#endif

#ifndef NO_SPEC
	SpecMap *= _sample5(In.texCoord0).rgb;
#endif

	float4 light0 = 1;
	float3 light1 = 0;
#if ENABLE_LIGHTING
	LightPixel( In.posView, N, In.toLightDir0TS, In.toLightDir1TS, In.eyeDirTS, light0, light1);
#endif
	
	float3 totalLight = light0.rgb + light1.rgb + g_cAmbientColor.rgb;
	saturate(totalLight);
	Output.color.rgb = (1-lightAmount)*(light1.rgb+g_cAmbientColor.rgb)*ColorMap.rgb + lightAmount*( totalLight*ColorMap.rgb + light0.www*SpecMap );
	Output.color.a = ColorMap.a; // modulate alpha as is, shadow doesn't affect it.
	
    if ( g_iFogParams.x > 0)
    {
		Output.color = computeFog( In.posView.z, Output.color );
    }
    
    Output.pzDepth.rgb = In.posView.z * g_iDepthParams.x;
    Output.pzDepth.a = Output.color.a;

    return Output;
}



pixelOutput PixShadowSceneT2BumpLM( vertexOutputT2B In )
{
 	HKG_TEST_DEPTH_PEEL

	pixelOutput Output;
    
	float shadowAmount = getLightAmountShadow( In.posView );
	
		
	float4 ColorMap = float4(1,1,1,1);
	float3 SpecMap = g_cSpecularColor.rgb;
	float3 LightMap = float3(1,1,1);
	float3 N = float3(0,0,1); 
	
#if ENABLE_DIFFUSE_MAP0
    ColorMap = _sample4(In.texCoord01.xy);
#endif

#if ENABLE_LIGHT_MAP
    LightMap = _sample5(In.texCoord01.zw).rgb;
#endif
		
#if ENABLE_NORMAL_MAP
	#if ENABLE_LIGHTING
		N = _sample6(In.texCoord01.xy).xyz*2.0 - 1.0;
		N = normalize(N);
	#else
		ColorMap = _sample6( In.texCoord01.xy);
	#endif
#endif

#if !defined(NO_SPEC) && !defined(HKG_DEPTH_PEEL)
	SpecMap *= _sample7( In.texCoord01.xy).rgb;
#endif

	ColorMap *= g_cDiffuseColor;
	clip( ColorMap.a - getAlphaClipTolerance() );

	// Green == 59% of the perceived luminosity, while the red and blue channels account for just 30% and 11%
	float luminosity = (LightMap.r*0.33 + LightMap.g*0.59 + LightMap.b*0.11);
	luminosity = saturate( luminosity );
	//float lightMapShadow = 1 - (luminosity * 0.5); // 1 when in dark areas
	//shadowAmount = max( shadowAmount, lightMapShadow ); // don't have dark shadows in dark lightmap areas
	
	float3 gammaCorrectLight = ColorMap.rgb * LightMap.rgb; 
	gammaCorrectLight *= 1+shadowAmount; // ColorMap is already gamma corrected , but LightMap is not and came from a EXR say in Max. Doing proper 2.2 gamma etc on it seems to wash it out, just *2 looks ok for now
	//gammaCorrectLight *= getExposurePow2();
	//gammaCorrectLight = pow(gammaCorrectLight, getInvGamma() ); 
	
	float4 light0 = 1;
	float3 light1 = 0;
#if ENABLE_LIGHTING
	LightPixel( In.posView, N, In.toLightDir0TS, In.toLightDir1TS, In.eyeDirTS, light0, light1);
#endif
	
	// Discard normal map and spec map in darker areas
	light0 *= luminosity; // don't want spec etc in dark areas
		
	Output.color.rgb = gammaCorrectLight + (light0.www*SpecMap*shadowAmount);
	Output.color.a = ColorMap.a; // modulate alpha as is, shadow doesn't affect it.
	
    if ( g_iFogParams.x > 0)
    {
		Output.color = computeFog( In.posView.z, Output.color );
    }
   
    Output.pzDepth.rgb = In.posView.z * g_iDepthParams.x;
    Output.pzDepth.a = Output.color.a;

    return Output;
}

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
