
/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */

//:STYLE VertVel HK_NULL HK_NULL HK_NULL PixVel LD* T* VELOCITY 

#include "CommonHeader.hlslh"

vertexOutputVel VertVel( vertexInputVel In)
{
	vertexOutputVel Output;
	
	float3 curWorldVertPos;
	float3 prevWorldVertPos;
	
	#ifdef HKG_INSTANCING
		
		float3x4 curWorld;
		float3x4 prevWorld;
		curWorld[0] = In.transformRow0;
		curWorld[1] = In.transformRow1;
		curWorld[2] = In.transformRow2;
		prevWorld[0] = In.prevTransformRow0;
		prevWorld[1] = In.prevTransformRow1;
		prevWorld[2] = In.prevTransformRow2;
	
		curWorldVertPos = mul(curWorld , float4(In.position, 1) );
		prevWorldVertPos = mul(prevWorld , float4(In.position, 1) );
	 
	#elif defined(HKG_SKINNING) && defined(HKG_VELOCITY_SHADER)
	
		float4 blendWeightsArray = In.blendWeights;    
		#ifdef HKG_DX10
			int4 indexArray = (int4)In.blendIndices;
		#else
			int4 indexArray = D3DCOLORtoUBYTE4(In.blendIndices);
		#endif
		
		float3 curLocalVertPos;
		float3 prevLocalVertPos;
		
		skinPosition( In.position, blendWeightsArray, indexArray, curLocalVertPos );   
		curWorldVertPos = mul( float4(curLocalVertPos, 1), g_mWorld ).xyz;
		#ifdef HKG_DX10
			skinPrevPosition( In.position, blendWeightsArray, indexArray, prevLocalVertPos );   
			prevWorldVertPos = mul( float4(prevLocalVertPos, 1), g_mPrevWorld ).xyz;
		#else // not enough constants, would need to make the mesh sections very small (<32)
			prevWorldVertPos = mul( float4(curLocalVertPos, 1), g_mPrevWorld ).xyz;
		#endif

	#else // rigid (could be CPU skinned or cloth etc thouigh, so see if it has a dynamic vb)
		
		curWorldVertPos = mul(float4(In.position,1), g_mWorld).xyz;
		
		#ifdef HKG_DYNAMIC_VB // CPU skinned or cloth etc
			prevWorldVertPos = mul(float4(In.prevPosition,1), g_mPrevWorld).xyz;
		#else
			prevWorldVertPos = mul(float4(In.position,1), g_mPrevWorld).xyz;
		#endif
	
	#endif
	
	Output.position = mul(float4(curWorldVertPos,1), g_mViewProj); 
	Output.wpCur = Output.position; //SM3.0..
	Output.wpPrev = mul(float4(prevWorldVertPos,1), g_mPrevViewProj);
  #ifdef HKG_VELOCITY_MAPS_RESPECT_ALPHA
	Output.texCoord0 = In.texCoord0;
  #endif
	return Output;
}

float4 PixVel( vertexOutputVel In ) : SV_Target0
{
	#ifdef HKG_VELOCITY_MAPS_RESPECT_ALPHA
	if (g_iDepthParams.g > 0)
	{
		float4 tex = _sample0( In.texCoord0.xy );
		clip(tex.a - 0.25); // will be neg for <25 and will discard pixel
	}
	#endif
		
	float2 curP  = In.wpCur.xy / In.wpCur.w; 
	float2 prevP = In.wpPrev.xy / In.wpPrev.w; 
	float2 velocityXY;
	velocityXY = curP - prevP;
	velocityXY /= 2;
	
	return float4(velocityXY,0,1);
}

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
