/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */

#ifndef HK_SOLVER_ALLOCATOR_BUFFER_H
#define HK_SOLVER_ALLOCATOR_BUFFER_H

#include <Common/Base/Memory/Allocator/Solver/hkSolverAllocator.h>

/// Used to temporarily replace the default solver allocator buffer in demos with larger memory requirements.
class SolverAllocatorBuffer : public hkReferencedObject
{
	public:

		HK_DECLARE_CLASS_ALLOCATOR(HK_MEMORY_CLASS_UTILITIES);

		SolverAllocatorBuffer(int sizeInBytes) : m_oldBufferStart(HK_NULL)
		{
			hkMemoryAllocator* solverAllocatorUntyped = &hkMemoryRouter::getInstance().solver();
			hkSolverAllocator referenceAllocator;

			// Check that the v-table pointer of the solver allocator is that of a hkSolverAllocator. This will 
			// fail if we are using the checking memory system or with compilers that place the v-table pointer at the 
			// end of the class as hkMemoryAllocator does not inherit from hkBaseObject.
			if (*((void**)&referenceAllocator) != *((void**)solverAllocatorUntyped))
			{
				HK_WARN(0x6f54877d, "The solver allocator is not a hkSolverAllocator, solver allocator buffer size will remain unchanged");
				return;
			}

			// Save the current buffer
			hkSolverAllocator* solverAllocator = reinterpret_cast<hkSolverAllocator*>(solverAllocatorUntyped);
			m_oldBufferStart = solverAllocator->m_bufferStart;
			m_oldBufferSize = (int)(solverAllocator->m_bufferEnd - solverAllocator->m_bufferStart);

			// Set the new one
			m_solverBuffer.setSize(sizeInBytes);
			solverAllocator->setBuffer(m_solverBuffer.begin(), m_solverBuffer.getSize());			
		}

		~SolverAllocatorBuffer()
		{
			if (m_oldBufferStart)
			{
				hkSolverAllocator* allocator = reinterpret_cast<hkSolverAllocator*>(&hkMemoryRouter::getInstance().solver());
				allocator->setBuffer(m_oldBufferStart, m_oldBufferSize);
			}
		}

	protected:

		hkArray<hkUint8> m_solverBuffer;
		char* m_oldBufferStart;
		int m_oldBufferSize;
};

#endif // HK_SOLVER_ALLOCATOR_BUFFER_H

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
