/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */

#ifndef HK_PATH_CONTAINER_H
#define HK_PATH_CONTAINER_H

#include <Common/Visualize/hkDebugDisplay.h>

class PathContainer : public hkReferencedObject
{
public:

	HK_DECLARE_CLASS_ALLOCATOR(HK_MEMORY_CLASS_DEMO);
	HK_DECLARE_REFLECTION();
	
	PathContainer() {}

	struct Path
	{
		Path() {}
		HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR(HK_MEMORY_CLASS_DEMO, Path);
		HK_DECLARE_REFLECTION();
		hkArray< hkVector4 > m_points;
		explicit Path( hkFinishLoadedObjectFlag flag ) : m_points(flag) {}
	};

	explicit PathContainer( hkFinishLoadedObjectFlag flag ) : hkReferencedObject(flag), m_paths(flag) { }
	hkArray< Path > m_paths;
};

struct PathContainerUtility
{
	static PathContainer* HK_CALL loadPathContainer( const char* filename );
	static hkResult HK_CALL savePathContainer( const char* filename, const PathContainer& container );
	static void HK_CALL debugDisplayPathContainer( const PathContainer& container, hkColor::Argb color = hkColor::RED );
	static void HK_CALL debugDisplayPath( const PathContainer::Path& path , hkColor::Argb color = hkColor::RED );
	static void HK_CALL addPath( const hkVector4* pts, int numPoints, PathContainer& container );
	static void HK_CALL removePath( int index, PathContainer& container );

};
#endif	// HK_PATH_CONTAINER_H

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
