/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */
#include <Demos/demos.h>
#include <Demos/DemoCommon/Utilities/PathContainer/PathContainer.h>
#include <Common/Base/System/Io/Writer/hkStreamWriter.h>
#include <Common/Base/System/Io/Reader/hkStreamReader.h>
#include <Common/Serialize/Util/hkSerializeUtil.h>
#include <Common/Serialize/Util/hkRootLevelContainer.h>
#include <Common/Base/Reflection/Registry/hkVtableClassRegistry.h>

extern const hkClass PathContainerClass;
extern const hkTypeInfo PathContainerTypeInfo;
extern const hkClass PathContainerPathClass;
extern const hkTypeInfo PathContainerPathTypeInfo;

PathContainer* HK_CALL PathContainerUtility::loadPathContainer( const char* filename )
{
	hkBuiltinTypeRegistry::getInstance().addType( &PathContainerTypeInfo, &PathContainerClass );
	hkBuiltinTypeRegistry::getInstance().addType( &PathContainerPathTypeInfo, &PathContainerPathClass );

	hkObjectResource* res = hkSerializeUtil::loadOnHeap( filename );
	if ( !res )
	{
		HK_WARN( 0x54e32123, "Unable to load from file " << filename );
		return HK_NULL;
	}

	PathContainer* pathContainer = res->getContents<PathContainer>();
	pathContainer->addReference();
	res->removeReference();
	return pathContainer;
}

hkResult HK_CALL PathContainerUtility::savePathContainer( const char* filename, const PathContainer& pathContainer )
{
	hkOfstream file(filename);
	if (!file.isOk())
		return HK_FAILURE;

	hkBuiltinTypeRegistry::getInstance().addType( &PathContainerTypeInfo, &PathContainerClass );
	hkBuiltinTypeRegistry::getInstance().addType( &PathContainerPathTypeInfo, &PathContainerPathClass );
	hkSerializeUtil::saveTagfile(&pathContainer, PathContainerClass, file.getStreamWriter());

	return HK_SUCCESS;
}

void HK_CALL PathContainerUtility::debugDisplayPathContainer( const PathContainer& container, hkColor::Argb color )
{
	for (int p=0 ; p< container.m_paths.getSize(); p++)
	{
		PathContainerUtility::debugDisplayPath( container.m_paths[p], color );
	}
}

void HK_CALL PathContainerUtility::debugDisplayPath( const PathContainer::Path& path , hkColor::Argb color )
{
	for (int p=1 ; p< path.m_points.getSize(); p++)
	{
		HK_DISPLAY_LINE( path.m_points[p-1], path.m_points[p], color );
	}
}

void HK_CALL PathContainerUtility::addPath( const hkVector4* pts, int numPoints, PathContainer& container )
{
	PathContainer::Path& path = container.m_paths.expandOne();
	path.m_points.setSize( numPoints );
	hkMemUtil::memCpy( path.m_points.begin(), pts, numPoints * sizeof(hkVector4) );
}

void HK_CALL PathContainerUtility::removePath( int index, PathContainer& container )
{
	container.m_paths.removeAtAndCopy( index );
}

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
