/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */

#ifndef HK_PARTICLE_UTILS_PHYS_H
#define HK_PARTICLE_UTILS_PHYS_H

#include <Demos/DemoCommon/Utilities/Particles/ParticleSystem/SparksParticleSystem.h>

namespace ParticleUtils
{
	/// Ray-cast interface based on hkpWorld
	struct WorldRayCastInterface : public SparksParticleSystem::RayCastInterface
	{
		HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR(HK_MEMORY_CLASS_BASE, ParticleUtils::WorldRayCastInterface);

		/// Destructor
		virtual ~WorldRayCastInterface() {}

		/// Locks the physics simulation
		void lock() HK_OVERRIDE;

		/// Unlocks the physics simulation
		void unlock() HK_OVERRIDE;

		/// Casts a ray, returns true if the ray has hit
		bool castRay(hkVector4Parameter vFrom, hkVector4Parameter vTo, hkSimdReal& fractionOut, hkVector4& normalOut) HK_OVERRIDE;

		hkpWorld* m_world;
	};

	// Advances the positions and velocities of particles over a time step while processing collisions using one
	// world raycast per particle. Collisions are simply resolved by moving the particle position to the ray hit
	// point and adjusting the particle velocity according to the supplied friction and restitution parameters -
	// the velocity of the collided object is not taken into account.
	// Note that sometimes particle collisions will go undetected when using raycasts since rays in Havok that
	// start inside an object will not register hits. For this reason, this function does not always work well
	// when particles are colliding against moving geometry, but it does work well for static geometry.
	void moveParticlesWithRaycastCollisions( int numParticles, char* posPtr, char* velPtr, int particleStride,
											hkReal timestep, const hkVector4& acceleration, hkReal friction, hkReal restitution, SparksParticleSystem::RayCastInterface * rayCaster );

}

#endif // HK_PARTICLE_UTILS_PHYS_H

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
