/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */

#include <Demos/demos.h>
#include <Demos/DemoCommon/Utilities/Particles/Utilities/ParticleUtils.h>
#include <Demos/DemoCommon/Utilities/Particles/Utilities/ParticleUtilsPhysics.h>
#include <Physics2012/Collide/Query/CastUtil/hkpWorldRayCastInput.h>
#include <Physics2012/Collide/Query/Collector/RayCollector/hkpClosestRayHitCollector.h>
#include <Physics2012/Dynamics/World/hkpWorld.h>

//
//	Locks the physics simulation

void ParticleUtils::WorldRayCastInterface::lock()
{
	m_world->lock();
}

//
//	Unlocks the physics simulation

void ParticleUtils::WorldRayCastInterface::unlock()
{
	m_world->unlock();
}

//
//	Casts a ray, returns true if the ray has hit

bool ParticleUtils::WorldRayCastInterface::castRay(hkVector4Parameter vFrom, hkVector4Parameter vTo, hkSimdReal& fractionOut, hkVector4& normalOut)
{
	hkpWorldRayCastInput rayInput;
	rayInput.m_from = vFrom;
	rayInput.m_to	= vTo;

	hkpWorldRayCastOutput rayOutput;
	m_world->castRay(rayInput, rayOutput);

	if ( rayOutput.hasHit() )
	{
		fractionOut = rayOutput.m_hitFraction;
		normalOut	= rayOutput.m_normal;
		return true;
	}

	return false;
}



void ParticleUtils::moveParticlesWithRaycastCollisions( int numParticles, char* posPtr, char* velPtr, int particleStride,
													   hkReal timestep, const hkVector4& acceleration, hkReal friction, hkReal restitution, SparksParticleSystem::RayCastInterface* rayCaster )
{
	rayCaster->lock();
	const hkSimdReal dt = hkSimdReal::fromFloat(timestep);
	const hkSimdReal f	= hkSimdReal::fromFloat(friction);
	const hkSimdReal r	= hkSimdReal::fromFloat(restitution);

	for(int i = 0; i < numParticles; ++i)
	{
		hkVector4& position = *reinterpret_cast<hkVector4*>(posPtr);
		hkVector4& velocity = *reinterpret_cast<hkVector4*>(velPtr);

		hkVector4 candVel;		candVel.setAddMul(velocity, acceleration, dt);
		hkVector4 candPos;		candPos.setAddMul(position, candVel, dt);
		hkSimdReal hitFraction;
		hkVector4 hitNormal;

		if ( rayCaster->castRay(position, candPos, hitFraction, hitNormal) )
		{
			position.setInterpolate(position, candPos, hitFraction);

			hkVector4 vel_norm;	vel_norm.setMul(hitNormal, velocity.dot<3>(hitNormal));
			hkVector4 vel_tang;	vel_tang.setSub(velocity, vel_norm);

			velocity.setMul(vel_tang, f);
			velocity.subMul(r, vel_norm);
		}
		else
		{
			position = candPos;
			velocity = candVel;
		}

		posPtr += particleStride;
		velPtr += particleStride;
	}

	rayCaster->unlock();
}

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
