/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */

#include <Demos/demos.h>
#include <Demos/DemoCommon/Utilities/Particles/HkgParticleSystem/HkgParticleSystem.h>

#include <Graphics/Common/DisplayWorld/hkgDisplayWorld.h>
#include <Graphics/Common/DisplayObject/hkgParticleDisplayObject.h>

hkgMaterial* HK_CALL HkgParticleSystem::createParticleMaterial( hkDemoEnvironment* env, const char* shaderFile, const char* textureFile, const char* vertexShaderProg, const char* geomShaderProg, const char* pixelShaderProg, void (HK_CALL* vertexShaderBindCallback)(hkgShaderEffect* shader) /*= HK_NULL */ )
{
	hkgWindow* window = env->m_window;
	hkgDisplayContext* context = window->getContext();

	context->lock();

	// Material
	hkgMaterial* mat = hkgMaterial::create();
	mat->setDiffuseColor(1.0f, 1.0f, 1.0f, 0.3f);

	if( (!context->getRenderCaps().m_shaderCompilationSupported) || (context->getRenderCaps().m_vertexShaderMajorVersion < 2)) 
	{
		HK_WARN(0x02346, "Particle demos require shader hardware to display properly.");
	}
	else
	{
		// Shaders
		hkgShader* vertexShader = hkgShader::create(HKG_VERTEX_SHADER, context);
		hkgShader* pixelShader = hkgShader::create(HKG_PIXEL_SHADER, context);

		// HKG DX10 requires geom shader to do point to quad/sprite expansion
		hkgShader* geomShader = HK_NULL;
		hkStringBuf shaderName;
		if(geomShaderProg && (context->getRenderCaps().m_geometryShaderMajorVersion > 0) )
		{
			geomShader = hkgShader::create(HKG_GEOMETRY_SHADER, context);
			shaderName.setJoin("./Resources/Common/Graphics/Particles/", shaderFile, "10", vertexShader->getDefaultFileNameExtension());
		}
		else
		{
			shaderName.setJoin("./Resources/Common/Graphics/Particles/", shaderFile, vertexShader->getDefaultFileNameExtension());
		}

		// No Shadows
		HKG_SHADER_RENDER_STYLE normalStyle = HKG_SHADER_RENDER_1LIGHTS | HKG_SHADER_RENDER_MODULATE_TEXTURE0;
		const hkgShader::ShaderDefine* defines = HK_NULL;
		vertexShader->realizeCompileFromFile(shaderName.cString(), vertexShaderProg, normalStyle, HK_NULL, 0, defines);
		pixelShader->realizeCompileFromFile(shaderName.cString(), pixelShaderProg, normalStyle, HK_NULL, 0, defines);
		if(geomShader)
		{
			geomShader->realizeCompileFromFile(shaderName.cString(), geomShaderProg, normalStyle, HK_NULL, 0, defines);
		}

		// Add shaders and texture to mat
		hkgShaderEffectCollection* effect = hkgShaderEffectCollection::create();

		effect->addShaderEffect(vertexShader, pixelShader, geomShader);
		effect->getShaderEffect(0)->m_userBindCallback = vertexShaderBindCallback;

		vertexShader->removeReference();
		pixelShader->removeReference();
		if(geomShader)
		{
			geomShader->removeReference();
		}

		mat->setShaderCollection(effect);
		effect->removeReference();

		// Texture
		if(textureFile)
		{
			hkgTexture* tex = hkgTexture::create(context);
			hkStringBuf textureName("./Resources/Common/Graphics/Particles/", textureFile);
			tex->loadFromFile(textureName.cString());
			tex->setAutoMipMaps(true);
			tex->realize(); // make the h/w version
			mat->addTexture(tex);
			tex->removeReference();
		}
	}

	context->unlock();

	return mat;
}

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
