/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */

#ifndef HK_COMPARE_UTIL_H
#define HK_COMPARE_UTIL_H

#include <Common/Base/Reflection/hkClassMember.h>
#include <Common/Base/Container/Tree/hkTree.h>


//Takes two serializable objects and compares their values.
//Differences are stored in an array & tree structure which keep each members' values as text as well as the path to that member
//Root node in tree structure contains have blank/NULL values, differences are stored in the roots descendant 
//Note: Cannot compare pointers if either is a null pointer
//Note: Does not yet compare arrays of different lengths
//Note: If the Util comes across a hkClassMember type for which a comparison hasn't been written, a warning is printed to the console.
class ComparisonUtil
{

public:
	HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR(HK_MEMORY_CLASS_BASE,ComparisonUtil);

	ComparisonUtil()
	{
		m_diffTree.appendChild(m_diffTree.iterGetFirst(), StringValues());
	}

	//compare objects with a vtable
	void compareObjects(void* objAStart, void* objBStart);

	//compare objects without a vtable
	void compareObjects(void* objAStart, void* objBStart, const hkClass& objClass);

	//prints m_differences to the console and/or file
	void printDifferences(hkBool printToConsole = true, hkBool printToFile = true, const char* filename = "Differences.txt");
	
private:

	struct StringValues
	{
		HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR(HK_MEMORY_CLASS_BASE,StringValues);
		hkStringPtr m_memPath;
		hkStringPtr m_valueA;
		hkStringPtr m_valueB;

		StringValues()
		{
			m_memPath = HK_NULL;
			m_valueA = HK_NULL;
			m_valueB = HK_NULL;
		}
	};

	typedef hkTree<StringValues>::Iter TreeIter;
	
	//Compares each member of both objects
	void compareAllMembers(void* objAStart, void* objBStart, const hkClass& objClass, hkStringBuf parentStr, TreeIter parentItr);
	
	//the main event
	void compareMember(void* objAStart, void* objBStart, const hkClassMember& member, hkStringBuf parentStr, TreeIter parentItr);

	//compares sizes and then each individual members in an array member
	void compareArrayMember(void* objAMember, void* objBMember, const hkClassMember& member, hkStringBuf parentStr, TreeIter parentItr);

	//dereference pointer members ad compare them (elem = array index, default -1 for non arrays)
	//returns result of compare if simple type, else true
	hkBool comparePointerMember(void* objAMember, void* objBMember, const hkClassMember& member, hkStringBuf& valueAstr, hkStringBuf& valueBstr, hkStringBuf parentStr, TreeIter parentItr, int elem = -1);

	//compares two members of type "type" and prints their respective values to valueAstr & valueBstr
	hkBool compareSimpleType(void* objAMember, void* objBMember, const hkClassMember::Type type, hkStringBuf& valueAstr, hkStringBuf& valueBstr);

	//changes the printed values if the object has a hkSemanticsAttribute e.g. angles
	void applyAttributes(const hkClassMember& member, hkStringBuf& valueAstr, hkStringBuf& valueBstr);

	//store differences in m_differences & m_diffTree (elem = array index, default -1 for non arrays)
	void storeDifference(const hkClassMember& member, hkStringBuf& valueAstr, hkStringBuf& valueBstr, const hkStringBuf parentStr, TreeIter parentItr, const int elem = -1);

	//Is one of a member's ancestors is itself?
	hkBool loopInHierachy(const TreeIter currentParent, const char* currentMember);
	
	hkArray<StringValues> m_differences;
	hkTree<StringValues> m_diffTree;

};
#endif

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
