/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */

// Havok CompareDemo

//
// Includes
//

#include <Demos/demos.h>
#include <Demos/DemoCommon/Utilities/ObjectComparison/ComparisonUtil.h>

class CompareDemo : public hkDemo
{
	public:

		CompareDemo(hkDemoEnvironment* env);
		~CompareDemo();

		Result stepDemo();
		Result stepVisualDebugger(){ return DEMO_OK; }
		bool visualDebuggerEnabled() { return false; }
		void makeFakeInput() {}
	
};

#include <Common/SceneData/Scene/hkxScene.h>
#include <Common/Serialize/Util/hkLoader.h>
#include <Common/Serialize/Util/hkRootLevelContainer.h>

CompareDemo::CompareDemo(hkDemoEnvironment* env)
	:	hkDemo(env)
{

	void* objAStart;
	void* objBStart;
	hkClass objClass = hkClassClass;
	{
		objClass = hkxSceneClass;

		hkLoader* m_loader = new hkLoader();

		hkStringBuf assetFileA("Resources/Physics2012/levels/twosided_test_level.hkt");
		hkRootLevelContainer* containerA = m_loader->load( assetFileA.cString() );
		HK_ASSERT2(0x27343441, containerA != HK_NULL , "Could not load asset");
		hkxScene* objA = reinterpret_cast<hkxScene*>( containerA->findObjectByType( hkxSceneClass.getName() ));
		
		hkStringBuf assetFileB("Resources/Common/Graphics/default_preview_scene.hkt" );
		hkRootLevelContainer* containerB = m_loader->load( assetFileB.cString() );
		HK_ASSERT2(0x27343441, containerB != HK_NULL , "Could not load scene asset");
		hkxScene* objB = reinterpret_cast<hkxScene*>( containerB->findObjectByType( hkxSceneClass.getName() ));

		objAStart = (void*)objA;
		objBStart = (void*)objB;
		//hkxScene defaultObj;
		//objBStart = &defaultObj;
	}

	ComparisonUtil comparsion;
	comparsion.compareObjects(objAStart, objBStart, objClass);
	comparsion.printDifferences();
}

CompareDemo::~CompareDemo()
{
}

hkDemo::Result CompareDemo::stepDemo()
{
	return DEMO_OK;
}


HK_DECLARE_DEMO(CompareDemo, HK_DEMO_TYPE_OTHER, "Compare two objects.", "Differences between the two objects are printed to the console and Differences.txt file");

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
