/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */

#ifndef DEMOS_UTILITIES_MENUDEMO_H
#define DEMOS_UTILITIES_MENUDEMO_H

#include <Demos/DemoCommon/DemoFramework/hkDemoDatabase.h>
#include <Demos/DemoCommon/DemoFramework/hkTextDisplay.h>
#include <Common/Base/Monitor/MonitorStreamAnalyzer/hkMonitorStreamAnalyzer.h>
#include <Common/Base/Memory/System/hkMemorySystem.h>
#include <Graphics/Common/Window/hkgWindow.h>
#include <Demos/DemoCommon/Utilities/Replay/DemoReplay.h>
#include <Graphics/Bridge/SeriesGraph/hkgSeriesGraph.h>
#include <Graphics/Bridge/StatGraph/hkgStatGraph.h>
#include <Graphics/Bridge/MemoryTrackerGraph/hkgMemoryTrackerGraph.h>
#include <Graphics/Bridge/SeriesGraph/hkgTimerGraph.h>

extern const class hkClass MenuDemoEmptyClass;

class Tweaker;
class GpuStatsUtil;

// Demo framework menu
class MenuDemo : public hkDefaultDemo
{
	//+hk.ReflectedFile("Destruction2012Preview")
	public:
		HK_DECLARE_CLASS_ALLOCATOR(HK_MEMORY_CLASS_BASE);
		// Destruction Preview requires this to be in a separate file

		MenuDemo(hkDemoEnvironment* env);
		~MenuDemo();

		// Forwards to the current demo's advanceFrame
		virtual void advanceFrame();
		virtual Result stepDemo();

		virtual void preRenderDisplayWorld(class hkgViewport* v);
		virtual void postRenderDisplayWorld(class hkgViewport* v);
		virtual void postRenderWindow(class hkgWindow* w);

		virtual void renderSecondaryViewport(class hkgViewport* v);

		virtual Result stepVisualDebugger();

		virtual void windowResize(int w, int h);
		virtual void windowDropFile(const char* filename, int x, int y); // window has a file dropped. The const char is temporary, strDup if you want to keep it.
		virtual bool touchDown(int id, int x, int y);
		virtual void touchMove(int id, int x, int y, int dx, int dy);
		virtual void touchUp(int id, int x, int y);
		virtual void accelerometerChange(const float highPass[3], const float lowPass[3]);


		struct Empty
		{
			HK_DECLARE_REFLECTION();
		};

		// whether or not help is being displayed
		bool isHelpOn();

		// stop displaying the help text
		void turnOffHelp();

		// whether the monitors are turned on
		bool areMonitorsOn();

		// get a menu demo (kinda like a singleton)
		static MenuDemo* getMenuDemo();

		struct Entry
		{
			HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR( HK_MEMORY_CLASS_DEMO, Entry);
			extStringPtr	m_name;
			extStringPtr	m_fullPath;
			const char*	m_help;
			int			m_index;

			Entry(const char* name, const char* fullPath, const char* help, int index)
			: m_name(name), m_fullPath(fullPath), m_help(help), m_index(index) {}
			hkBool isDir() { return m_help == HK_NULL; }
			HK_FORCE_INLINE Entry() {}
		private:
			friend class extArray<Entry>;
		};

	private:

		Result stepMenuDemo();
		Result stepCurrentDemo();

		void stopCurrentDemo();
		void startCurrentDemo();

		void writeSimpleMemoryStatistics();
		void renderStatGraphs(bool useCurrentViewport);
	
		void addStatus(const char* s);
		const char* getStatus();

			// show and handle the paused menu
		Result showPausedMenu( bool handleKeysOnly );

		Result showTweakMenu();

		void showMonitorAnalysis(int xOffset, extArray<hkTimerData>& threadStreamInfos, extArray<hkTimerData>& spuStreamInfos );
		void stepStatGraph( extArray<hkTimerData>& threadStreamInfos, extArray<hkTimerData>& spuStreamInfos );
		void stepTimerGraph( extArray<hkTimerData>& threadStreamInfos, extArray<hkTimerData>& spuStreamInfos );
		void stepMainMemoryGraph(const hkMemorySystem::MemoryStatistics& stats);
		void showMemoryTracker();
		void cycleTimerGraph();
		void toggleTrackerGraph();
		void toggleMemoryGraphs();
		
		void showGpuStats();
public:
		class GraphManager* m_graphManager;

	private:

		const char* m_defaultDemo;	// set if there is a demo name we should launch by default
									// else we will show the menu demo

		hkPerformanceCounterUtility* m_performanceCounterUtility;

		hkDemoFrameworkOptions m_originalOptions;

		extStringBuf m_currentPath;		// full path of current demo
		hkDemo* m_currentDemo;		// current demo if it exists

		hkReal m_helpTimeMax;		// how long do we want help for (in seconds)
		hkReal m_helpTimeLeft;		// number of seconds left to show help. zero means help is off. HK_REAL_MAX means show keys
		hkStopwatch m_stopwatch;
		extStringPtr m_statusLine;		// status text
		extStringBuf m_searchString;	// quicksearch

		hkgTexture* m_menuImage;
		float		m_menuImageBackground[3];
		float		m_menuImageBackgroundDirection[3];

		// switches
		hkBool m_paused;
		hkBool m_wantMonitors;
		hkBool m_wantTweak;
		hkBool m_childDemoJustCreated;
		hkBool m_wantCameraData;

		// for determinism checks
		int	m_frameCounter;
		int m_determinismCheckRunIndex;

		hkDemoReplayUtility m_replay;

		// current node for monitors
		hkMonitorStreamAnalyzer::Node* m_activeNode;
		hkMonitorStreamAnalyzer::Node* m_statsTree;

		// These are added by the test suite
		extArray<hkDemoEntryRegister*> m_extraDemos;
		extArray<extStringPtr> m_extraNames;

		// which button are we tracking for picking  (-1 for none)
		bool m_mouseInGraphZoomMode;
		int m_mousePadTrackedButton;
		bool m_viewportMouseEventBackup;
		int m_mouseStatZoomOriginX;
		int m_mouseStatZoomOriginY;


		// Current index of search.
		int m_searchIndex;

		// in tweak mode which entry are we modifiying?
		Tweaker* m_tweaker;

		hkPadSpu<char*> m_savedStreamBegin;
		hkPadSpu<char*> m_savedStreamCurrent;
		hkPadSpu<char*> m_savedStreamEnd;
		hkPadSpu<char*> m_simTimersEnd;
		hkPadSpu<char*> m_pausedSimTimers;

		bool m_newTimersGathered;

		// an instance of the menu demo if there is one
		static MenuDemo* m_menuDemo;

		hkBool            m_gpuStats;
		GpuStatsUtil* m_gpuStatsUtil;
		hkgSeriesGraph* m_mainMemoryGraph;
};

/// A handy graphical display of the  memory / timer / tracker stats


class GraphManager
{
	public:
		HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR(HK_MEMORY_CLASS_DEMO, GraphManager);
		enum Graph
		{
			TIMER,	///< timers graph		(lower zone)
			STATS,	///< timers chronograph (lower zone)
			TRACKER,///< memory tracker		(lower zone)
			MEMORY	///< memory graphs		(upper zone)
		};

		GraphManager( hkDemoEnvironment* env); 

		/// Immediately displays the enabled graphs.
		void renderGraphs( int origZoomX, int origZoomY, bool useCurrentViewport, bool mouseOverlay );
		
		/// Tell the graph to update their size.
		void onWindowResize( int w, int h );

		/// Returns true if the mouse is in the lower graph zone.
		hkBool inStatGraphBounds(int px, int py ) const;

		/// Zooms on the graph that support it (tracker and stats)
		void mouseZoom( int origX, int origY, int px, int py );

		/// Turns a graph on or off.
		void toggleGraph(Graph graph, bool enable);

		/// Is the given graph enabled or not.
		bool isEnabled(Graph graph) const ;

		/// For graphs that support it, manage an action at the given coordinates. Returns true if an action other than
		/// NONE has been done.
		hkBool manageUserAction( int px, int py );

		/// Add a new memory graph on the upper zone.
		void addMemoryGraph( hkgSeriesGraph* memoryGraph);

		/// Remove a memory graph from the upper zone.
		void removeMemoryGraph( hkgSeriesGraph* memoryGraph);
	
	public:
		/// Bar chart show timers in a chronograph
		hkRefPtr<hkgStatGraph> m_statGraph;

		/// Memory breakdown from the memory tracker
		hkRefPtr<hkgMemoryTrackerGraph> m_trackerGraph;

		/// Graph of the timers value over time
		hkRefPtr<hkgTimerGraph> m_timerGraph;

		/// Graphs of the memory usage over time.
		hkArray < hkRefPtr < hkgSeriesGraph > > m_memoryGraphs;
	
	private:
		// Whether to show memory graphs or not
		hkBool m_showMemoryGraphs; 

		// Interface with the demo graphical environment.
		hkDemoEnvironment* m_env;
};

#endif // DEMOS_UTILITIES_MENUDEMO_H

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
