/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */

#ifndef HK_DEMO_GPU_STATS_UTIL_H
#define HK_DEMO_GPU_STATS_UTIL_H

#include <Graphics/Common/DisplayContext/hkgDisplayContext.h>

class GpuStatsUtil : public hkReferencedObject
{
	public:

		enum ObjectsState
		{
			OBJECTS_CLOSED,
			OBJECTS_NAMES,
			OBJECTS_OPENED,
		};

	public:

		HK_DECLARE_CLASS_ALLOCATOR(HK_MEMORY_CLASS_DEMO_FRAMEWORK);

		GpuStatsUtil();

		void display( const hkgDisplayContext &context, hkStringBuf& sb );
		void handleKeys( const hkDemoEnvironment &env );

	protected:

		hkBool m_groupOpen[ hkgDisplayStatistics::GROUP_MAX ];
		ObjectsState m_objectsOpen[ hkgDisplayStatistics::GROUP_MAX ];

		hkgDisplayStatistics::Group m_selectedGroup;
		int m_selectedObject;
};


#endif	// HK_DEMO_GPU_STATS_UTIL_H

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
