/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */

#include <Demos/demos.h>

// this
#include <Demos/DemoCommon/Utilities/GpuStats/GpuStatsUtil.h>

#include <Graphics/Common/Window/hkgWindow.h>


GpuStatsUtil::GpuStatsUtil()
{
	for ( int i=0; i<hkgDisplayStatistics::GROUP_MAX; i++ )
	{
		m_groupOpen[i] = false;
		m_objectsOpen[i] = OBJECTS_CLOSED;
	}

	m_selectedGroup  = hkgDisplayStatistics::GROUP_SUM;
	m_selectedObject = -1;
}

void GpuStatsUtil::display( const hkgDisplayContext &context, hkStringBuf& result )
{
#ifdef HK_GPU_STATS
	result.clear();

	// Get statistics
	const hkgDisplayStatistics &stats = context.m_prevStatistics;

	result.appendPrintf( "vertices: %d\n", stats.m_hwStats.m_inputVertices );
	result.appendPrintf( "primitives: %d\n", stats.m_hwStats.m_renderedPrimitives );
	result.appendPrintf( "pixels: %d\n", stats.m_hwStats.m_pixels );

	// Loop through all the groups and gather stats
	for ( int i=0; i<hkgDisplayStatistics::GROUP_MAX; i++ )
	{
		const hkgDisplayStatistics::GroupStatistics &group = stats.m_groups[i];

		// Don't display empty groups
		if ( group.m_objects[0].m_numDrawCalls == 0 ) continue;

		result.appendPrintf( "%c", ( m_selectedGroup == i && m_selectedObject == -1 ) ? HKG_FONT_BUTTON_RIGHT : '  ' );

		if ( m_groupOpen[i] )
		{	// Display full statistics
			result.appendPrintf( "%c%s:\n", HKG_FONT_BUTTON_DOWN, hkgDisplayStatistics::m_groupNames[i] );

			for ( int o=0; o<group.m_objects.getSize(); o++ )
			{
				if ( i == 0 && o > 0 ) break;

				const hkgDisplayStatistics::ObjectStatistics &object = group.m_objects[o];

				if ( i == 0 || m_objectsOpen[ i ] == OBJECTS_OPENED || ( o == 0 && m_objectsOpen[ i ] == OBJECTS_NAMES ) )
				{
					if ( i > 0 )
					{
						result.appendPrintf( "%c", ( m_selectedGroup == i && m_selectedObject == o ) ? HKG_FONT_BUTTON_RIGHT : '  ' );
						result.appendPrintf( "  %c%s:\n", ( o == 0 && m_objectsOpen[ i ] ) ? HKG_FONT_BUTTON_DOWN : HKG_FONT_BUTTON_RIGHT, object.m_name );
					}

					result.appendPrintf( "        DrawCalls: %d\n", object.m_numDrawCalls );
					result.appendPrintf( "        - Non-instanced: %d\n", object.m_numNonInstancedDrawCalls );
					result.appendPrintf( "        - Instanced: %d\n", object.m_numInstancedDrawCalls );
					result.appendPrintf( "        Primitives: %d\n", object.m_numPrimitives );
					result.appendPrintf( "        - Non-instanced: %d\n", object.m_numNonInstancedPrimitives );
					result.appendPrintf( "        - Instanced: %d\n", object.m_numInstancedPrimitives );
					result.appendPrintf( "        Instances: %d\n", object.m_numInstances );
					result.appendPrintf( "        Resource updates: %d\n", object.m_numResourceUpdates );
					result.appendPrintf( "        Clears: %d\n", object.m_numClears );
				}
				else
				{
					result.appendPrintf( "%c", ( m_selectedGroup == i && m_selectedObject == o ) ? HKG_FONT_BUTTON_RIGHT : '  ' );
					result.appendPrintf( "  %c%s ( %d / %d / %d )", HKG_FONT_BUTTON_RIGHT, object.m_name, object.m_numDrawCalls, object.m_numPrimitives, object.m_numResourceUpdates );
					if ( object.m_numInstances > 0 )
					{
						result.appendPrintf( "(%d)", object.m_numInstances );
					}
					result.appendPrintf( "\n" );
				}
			}
		}
		else
		{	// Display one-liner
			const hkgDisplayStatistics::ObjectStatistics &object = group.m_objects[0];
			result.appendPrintf( "%c%s ( %d / %d / %d )", HKG_FONT_BUTTON_RIGHT, hkgDisplayStatistics::m_groupNames[i], object.m_numDrawCalls, object.m_numPrimitives, object.m_numResourceUpdates );
			if ( object.m_numInstances > 0 )
			{
				result.appendPrintf( "(%d)", object.m_numInstances );
			}
			result.appendPrintf( "\n" );
		}
	}
#else
	result.set( "HK_GPU_STATS are turned off." );
#endif
}

void GpuStatsUtil::handleKeys( const hkDemoEnvironment &env )
{
	if ( env.wasButtonPressed( HKG_PAD_DPAD_UP ) )
	{
		if ( m_selectedObject == 0 )
		{
			m_selectedObject = -1;
		}
		else
		{
			m_selectedGroup = hkgDisplayStatistics::Group( ( m_selectedGroup + hkgDisplayStatistics::GROUP_MAX - 1 ) % hkgDisplayStatistics::GROUP_MAX );
			m_selectedObject = ( m_groupOpen[ m_selectedGroup ] && m_selectedGroup != 0 ) ? 0 : -1;
		}
	}
	if ( env.wasButtonPressed( HKG_PAD_DPAD_DOWN ) )
	{
		if ( m_selectedObject == -1 && m_groupOpen[ m_selectedGroup ] && m_selectedGroup != 0 )
		{
			m_selectedObject = 0;
		}
		else
		{
			m_selectedGroup = hkgDisplayStatistics::Group( ( m_selectedGroup + 1 ) % hkgDisplayStatistics::GROUP_MAX );
			m_selectedObject = -1;
		}
	}
	if ( env.wasButtonPressed( HKG_PAD_DPAD_LEFT ) )
	{
		if ( m_selectedObject == 0 )
		{
			if ( m_objectsOpen[ m_selectedGroup ] != OBJECTS_CLOSED )
			{
				m_objectsOpen[ m_selectedGroup ] = (ObjectsState)(m_objectsOpen[ m_selectedGroup ] - 1);
			}
		}
		else
		{
			m_groupOpen[ m_selectedGroup ] = false;
		}
	}
	if ( env.wasButtonPressed( HKG_PAD_DPAD_RIGHT ) )
	{
		if ( m_selectedObject == 0 )
		{
			if ( m_objectsOpen[ m_selectedGroup ] != OBJECTS_OPENED )
			{
				m_objectsOpen[ m_selectedGroup ] = (ObjectsState)(m_objectsOpen[ m_selectedGroup ] + 1 );
			}
		}
		else
		{
			m_groupOpen[ m_selectedGroup ] = true;
		}
	}
}

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
