/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */


template <typename HEIGHTFUNCTION>
void HK_CALL GeometryMaker::createFromHeightFunction(const HEIGHTFUNCTION& heightFunction, int numSamplesX, int numSamplesZ, 
													 hkVector4Parameter up, int defaultMaterial, hkGeometry& geometryOut)
{
	const hkReal quadsX = numSamplesX - 1.0f;
	const hkReal quadsZ = numSamplesZ - 1.0f;
	const Rectangle functionDomain(-0.5f * quadsX, -0.5f * quadsZ, quadsX, quadsZ);
	const Rectangle outputDomain = functionDomain;
	createFromHeightFunction(heightFunction, numSamplesX, numSamplesZ, up, defaultMaterial, geometryOut, functionDomain, outputDomain);
}


template <typename HEIGHTFUNCTION>
void HK_CALL GeometryMaker::createFromHeightFunction(const HEIGHTFUNCTION& heightFunction, int numSamplesX, int numSamplesZ, 
													 hkVector4Parameter up, int defaultMaterial, hkGeometry& geometryOut, 
													 const GeometryMaker::Rectangle& functionDomain, 
													 const GeometryMaker::Rectangle& outputDomain)
{
	// Allocate space for geometry	
	hkArray<hkVector4>& vertices = geometryOut.m_vertices;
	hkArray<hkGeometry::Triangle>& triangles = geometryOut.m_triangles;
	const int numVertices = numSamplesX * numSamplesZ;
	const int numTriangles = 2 * (numSamplesX - 1) * (numSamplesZ -1);
	vertices.setSize(numVertices);
	triangles.setSize(numTriangles);

	// Evaluate height function in the vertices position
	const hkReal stepX = functionDomain.getWidth() / (numSamplesX - 1);
	const hkReal stepZ = functionDomain.getHeight() / (numSamplesZ - 1);
	const hkReal stepOutX = outputDomain.getWidth() / (numSamplesX - 1);
	const hkReal stepOutZ = outputDomain.getHeight() / (numSamplesZ - 1);
	hkVector4* vertex = vertices.begin();
	hkReal z = functionDomain.getZ();
	for (int j = 0; j < numSamplesZ; ++j)
	{
		hkReal x = functionDomain.getX();
		for (int i  = 0; i < numSamplesX; ++i)
		{
			vertex->set(outputDomain.getX() + i * stepOutX, heightFunction(x, z), outputDomain.getZ() + j * stepOutZ);
			vertex++;
			x += stepX;
		}
		z += stepZ;
	}

	// Create triangles
	hkGeometry::Triangle* triangle = triangles.begin();
	for (int sz = 0; sz < numSamplesZ - 1; ++sz)
	{
		for (int sx = 0; sx < numSamplesX - 1; ++sx)
		{
			const int a = sx + sz * numSamplesX;
			const int b = a + numSamplesX;
			const int c = a + 1;
			const int d = c + numSamplesX;
			triangle->set(a, b, c, defaultMaterial);
			triangle++;
			triangle->set(b, d, c, defaultMaterial);
			triangle++;
		}
	}

	// Transform to match the desired up direction
	hkSimdReal epsilon; epsilon.setFromFloat(0.0001f);
	if (!up.allEqual<3>(hkVector4::getConstant<HK_QUADREAL_0100>(), epsilon))
	{
		hkQuaternion rotation; hkQuaternionUtil::_computeShortestRotation(hkVector4::getConstant<HK_QUADREAL_0100>(), up, rotation);		
		hkTransform transform(rotation, hkVector4::getZero());
		applyTransform(transform, geometryOut);
	}
}

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
