/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */

#ifndef HK_GEOMETRY_MAKER_H
#define HK_GEOMETRY_MAKER_H

#include <Common/Base/Types/Color/hkColor.h>
#include <Common/Base/Types/Geometry/hkGeometry.h>
#include <Common/Base/Math/Quaternion/hkQuaternionUtil.h>

// All methods that create new geometries will set triangles material to 0
class GeometryMaker
{
	public:

		HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR(HK_MEMORY_CLASS_DEMO, GeometryMaker);

		struct Rectangle
		{
			public:

				HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR(HK_MEMORY_CLASS_DEMO, GeometryMaker::Rectangle);

				Rectangle() {}
				Rectangle(hkReal x, hkReal z, hkReal width, hkReal height) : m_rectangle(x, z, width, height) {}
				HK_FORCE_INLINE hkReal getX() const { return m_rectangle.getComponent<0>(); }
				HK_FORCE_INLINE hkReal getZ() const { return m_rectangle.getComponent<1>(); }
				HK_FORCE_INLINE hkReal getWidth() const { return m_rectangle.getComponent<2>(); }
				HK_FORCE_INLINE hkReal getHeight() const { return m_rectangle.getComponent<3>(); }

			protected:

				hkVector4 m_rectangle;
		};

	public:

		static void HK_CALL createQuad(hkReal sideX, hkReal sideZ, int defaultMaterial, hkGeometry& geometryOut, const hkTransform& transform = hkTransform::getIdentity());
		static void HK_CALL createPyramid(hkReal sideX, hkReal sideZ, hkReal heightY, int defaultMaterial, hkGeometry& geometryOut, const hkTransform& transform = hkTransform::getIdentity());
		static void HK_CALL createBox(hkVector4Parameter halfExtents, int defaultMaterial, hkGeometry& geometryOut, const hkTransform& transform = hkTransform::getIdentity());
		static void HK_CALL createTjunctions(int defaultMaterial, hkGeometry& geometryOut);
		static void HK_CALL createIcosahedron(hkReal radius, int defaultMaterial, hkGeometry& geometryInOut);
		static void HK_CALL createIcosahedronVertices(hkReal radius, hkVector4 verticesOut[12]);
		static void HK_CALL createTetrahedronVertices(hkReal radius, hkVector4 verticesOut[4]);
		static void HK_CALL createTetragonalBipyramidVertices(hkReal radius, hkVector4 verticesOut[6]);


		// HEIGHFUNCTION must implement hkReal operator()(hkReal x, hkReal z) const
		template <typename HEIGHTFUNCTION>
		static void HK_CALL createFromHeightFunction(const HEIGHTFUNCTION& heightFunction, int numSamplesX, int numSamplesZ,
													 hkVector4Parameter up, int defaultMaterial, hkGeometry& geometryOut);
		template <typename HEIGHTFUNCTION>
		static void HK_CALL createFromHeightFunction(const HEIGHTFUNCTION& heightFunction, int numSamplesX, int numSamplesZ,
													 hkVector4Parameter up, int defaultMaterial, hkGeometry& geometryOut,
													 const GeometryMaker::Rectangle& functionDomain,
													 const GeometryMaker::Rectangle& outputDomain);

		static void HK_CALL applyTransform(const hkTransform& transform, hkGeometry& geometry);

		// Creates a grid of xRes by zRes points centered on the origin. X is the fastest running component.
		static void HK_CALL createPointGrid(int xRes, int zRes, hkReal step, hkArray<hkVector4>& grid);

		// Creates a collection of points arranged in concentric rings around the origin and in the plane Y = 0.
		static void HK_CALL createPointDisk(hkReal radius, int outerRes, int numRings, hkArray<hkVector4>& disk);
};

#include <Demos/DemoCommon/Utilities/Geometry/GeometryMaker.inl>

#endif // HK_GEOMETRY_MAKER_H

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
